/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.api.params;

import ca.uhn.fhir.mdm.provider.MdmControllerUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hl7.fhir.instance.model.api.IIdType;

public class MdmHistorySearchParameters {
    private List<IIdType> myGoldenResourceIds = new ArrayList<IIdType>();
    private List<IIdType> mySourceIds = new ArrayList<IIdType>();

    public List<IIdType> getGoldenResourceIds() {
        return this.myGoldenResourceIds;
    }

    public List<IIdType> getSourceIds() {
        return this.mySourceIds;
    }

    public MdmHistorySearchParameters setGoldenResourceIds(List<String> theGoldenResourceIds) {
        this.myGoldenResourceIds = MdmHistorySearchParameters.extractId(theGoldenResourceIds);
        return this;
    }

    public MdmHistorySearchParameters setSourceIds(List<String> theSourceIds) {
        this.mySourceIds = MdmHistorySearchParameters.extractId(theSourceIds);
        return this;
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        MdmHistorySearchParameters that = (MdmHistorySearchParameters)theO;
        return Objects.equals(this.myGoldenResourceIds, that.myGoldenResourceIds) && Objects.equals(this.mySourceIds, that.mySourceIds);
    }

    public int hashCode() {
        return Objects.hash(this.myGoldenResourceIds, this.mySourceIds);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("myMdmGoldenResourceIds", this.myGoldenResourceIds).append("myMdmTargetResourceIds", this.mySourceIds).toString();
    }

    @Nonnull
    private static List<IIdType> extractId(List<String> theTheGoldenResourceIds) {
        return theTheGoldenResourceIds.stream().map(MdmHistorySearchParameters::extractId).collect(Collectors.toUnmodifiableList());
    }

    @Nullable
    private static IIdType extractId(String theTheGoldenResourceId) {
        return MdmControllerUtil.extractGoldenResourceIdDtOrNull("goldenResourceId", theTheGoldenResourceId);
    }
}

