/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.api.paging;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import jakarta.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.springframework.data.domain.PageRequest;

public class MdmPageRequest {
    private final int myPage;
    private final int myOffset;
    private final int myCount;

    public MdmPageRequest(@Nullable IPrimitiveType<Integer> theOffset, @Nullable IPrimitiveType<Integer> theCount, int theDefaultPageSize, int theMaximumPageSize) {
        this.myOffset = theOffset == null ? 0 : (Integer)theOffset.getValue();
        this.myCount = theCount == null ? theDefaultPageSize : Math.min((Integer)theCount.getValue(), theMaximumPageSize);
        this.validatePagingParameters(this.myOffset, this.myCount);
        this.myPage = this.myOffset / this.myCount;
    }

    public MdmPageRequest(@Nullable Integer theOffset, @Nullable Integer theCount, int theDefaultPageSize, int theMaximumPageSize) {
        this.myOffset = theOffset == null ? 0 : theOffset;
        this.myCount = theCount == null ? theDefaultPageSize : Math.min(theCount, theMaximumPageSize);
        this.validatePagingParameters(this.myOffset, this.myCount);
        this.myPage = this.myOffset / this.myCount;
    }

    private void validatePagingParameters(int theOffset, int theCount) {
        Object errorMessage = "";
        if (theOffset < 0) {
            errorMessage = (String)errorMessage + "_offset must be greater than or equal to 0. ";
        }
        if (theCount <= 0) {
            errorMessage = (String)errorMessage + "_count must be greater than 0.";
        }
        if (StringUtils.isNotEmpty((CharSequence)errorMessage)) {
            throw new InvalidRequestException(Msg.code((int)1524) + (String)errorMessage);
        }
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getPage() {
        return this.myPage;
    }

    public int getCount() {
        return this.myCount;
    }

    public int getNextOffset() {
        return this.myOffset + this.myCount;
    }

    public int getPreviousOffset() {
        return this.myOffset - this.myCount;
    }

    public PageRequest toPageRequest() {
        return PageRequest.of((int)this.myPage, (int)this.myCount);
    }
}

