/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.api.paging;

import ca.uhn.fhir.mdm.api.paging.MdmPageLinkTuple;
import ca.uhn.fhir.mdm.api.paging.MdmPageRequest;
import ca.uhn.fhir.mdm.model.mdmevents.MdmLinkJson;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import java.util.Arrays;
import org.springframework.data.domain.Page;

public final class MdmPageLinkBuilder {
    public static MdmPageLinkTuple buildMdmPageLinks(ServletRequestDetails theServletRequestDetails, Page<MdmLinkJson> theCurrentPage, MdmPageRequest thePageRequest) {
        String urlWithoutPaging = RestfulServerUtils.createLinkSelfWithoutGivenParameters((String)theServletRequestDetails.getFhirServerBase(), (RequestDetails)theServletRequestDetails, Arrays.asList("_offset", "_count"));
        return MdmPageLinkBuilder.buildMdmPageLinks(urlWithoutPaging, theCurrentPage, thePageRequest);
    }

    public static MdmPageLinkTuple buildMdmPageLinks(String theUrlWithoutPaging, Page<MdmLinkJson> theCurrentPage, MdmPageRequest thePageRequest) {
        MdmPageLinkTuple tuple = new MdmPageLinkTuple();
        tuple.setSelfLink(MdmPageLinkBuilder.buildLinkWithOffsetAndCount(theUrlWithoutPaging, thePageRequest.getCount(), thePageRequest.getOffset()));
        if (theCurrentPage.hasNext()) {
            tuple.setNextLink(MdmPageLinkBuilder.buildLinkWithOffsetAndCount(theUrlWithoutPaging, thePageRequest.getCount(), thePageRequest.getNextOffset()));
        }
        if (theCurrentPage.hasPrevious()) {
            tuple.setPreviousLink(MdmPageLinkBuilder.buildLinkWithOffsetAndCount(theUrlWithoutPaging, thePageRequest.getCount(), thePageRequest.getPreviousOffset()));
        }
        return tuple;
    }

    public static String buildLinkWithOffsetAndCount(String theBaseUrl, int theCount, int theOffset) {
        StringBuilder builder = new StringBuilder();
        builder.append(theBaseUrl);
        if (!theBaseUrl.contains("?")) {
            builder.append("?");
        } else {
            builder.append("&");
        }
        builder.append("_offset").append("=").append(theOffset);
        builder.append("&");
        builder.append("_count").append("=").append(theCount);
        return builder.toString();
    }
}

