/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.api;

import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class MdmMatchOutcome {
    public static final MdmMatchOutcome POSSIBLE_DUPLICATE = new MdmMatchOutcome(null, null).setMatchResultEnum(MdmMatchResultEnum.POSSIBLE_DUPLICATE);
    public static final MdmMatchOutcome NO_MATCH = new MdmMatchOutcome(null, null).setMatchResultEnum(MdmMatchResultEnum.NO_MATCH);
    public static final MdmMatchOutcome NEW_GOLDEN_RESOURCE_MATCH = new MdmMatchOutcome(null, 1.0).setMatchResultEnum(MdmMatchResultEnum.MATCH).setCreatedNewResource(true);
    public static final MdmMatchOutcome EID_MATCH = new MdmMatchOutcome(null, 1.0).setMatchResultEnum(MdmMatchResultEnum.MATCH).setEidMatch(true);
    public static final MdmMatchOutcome POSSIBLE_MATCH = new MdmMatchOutcome(null, null).setMatchResultEnum(MdmMatchResultEnum.POSSIBLE_MATCH);
    private final Long vector;
    private final Double score;
    private boolean myCreatedNewResource;
    private boolean myEidMatch;
    private MdmMatchResultEnum myMatchResultEnum;
    private int myMdmRuleCount;

    public MdmMatchOutcome(Long theVector, Double theScore) {
        this.vector = theVector;
        this.score = theScore;
    }

    public boolean isMatch() {
        return this.myMatchResultEnum == MdmMatchResultEnum.MATCH;
    }

    public boolean isPossibleMatch() {
        return this.myMatchResultEnum == MdmMatchResultEnum.POSSIBLE_MATCH;
    }

    public boolean isPossibleDuplicate() {
        return this.myMatchResultEnum == MdmMatchResultEnum.POSSIBLE_DUPLICATE;
    }

    public MdmMatchResultEnum getMatchResultEnum() {
        return this.myMatchResultEnum;
    }

    public MdmMatchOutcome setMatchResultEnum(MdmMatchResultEnum theMatchResultEnum) {
        this.myMatchResultEnum = theMatchResultEnum;
        return this;
    }

    public boolean isCreatedNewResource() {
        return this.myCreatedNewResource;
    }

    public MdmMatchOutcome setCreatedNewResource(boolean theCreatedNewResource) {
        this.myCreatedNewResource = theCreatedNewResource;
        return this;
    }

    public boolean isEidMatch() {
        return this.myEidMatch;
    }

    public MdmMatchOutcome setMdmRuleCount(int theMdmRuleCount) {
        this.myMdmRuleCount = theMdmRuleCount;
        return this;
    }

    public int getMdmRuleCount() {
        return this.myMdmRuleCount;
    }

    public MdmMatchOutcome setEidMatch(boolean theEidMatch) {
        this.myEidMatch = theEidMatch;
        return this;
    }

    public Double getScore() {
        return this.score;
    }

    public Long getVector() {
        return this.vector;
    }

    public Double getNormalizedScore() {
        if (this.myMdmRuleCount == 0) {
            return this.score;
        }
        return this.score / (double)this.myMdmRuleCount;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("vector", (Object)this.vector).append("score", (Object)this.score).append("myCreatedNewResource", this.myCreatedNewResource).append("myEidMatch", this.myEidMatch).append("myMatchResultEnum", (Object)this.myMatchResultEnum).toString();
    }
}

