/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.api;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.mdm.rules.json.MdmRulesJson;
import java.util.stream.Collectors;

public interface IMdmSettings {
    public static final String EMPI_CHANNEL_NAME = "empi";
    public static final int MDM_DEFAULT_CONCURRENT_CONSUMERS = 1;

    public boolean isEnabled();

    public int getConcurrentConsumers();

    public MdmRulesJson getMdmRules();

    public boolean isPreventEidUpdates();

    public boolean isPreventMultipleEids();

    public String getRuleVersion();

    public String getSurvivorshipRules();

    default public boolean isSupportedMdmType(String theResourceName) {
        return this.getMdmRules().getMdmTypes().contains(theResourceName);
    }

    default public String getSupportedMdmTypes() {
        return this.getMdmRules().getMdmTypes().stream().collect(Collectors.joining(", "));
    }

    public int getCandidateSearchLimit();

    public String getGoldenResourcePartitionName();

    public void setGoldenResourcePartitionName(String var1);

    public boolean getSearchAllPartitionForMatch();

    public void setSearchAllPartitionForMatch(boolean var1);

    default public boolean isAutoExpungeGoldenResources() {
        return false;
    }

    default public void setAutoExpungeGoldenResources(boolean theShouldAutoExpunge) {
        throw new UnsupportedOperationException(Msg.code((int)2427));
    }
}

