/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.api;

import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.mdm.api.IMdmMetricSvc;
import ca.uhn.fhir.mdm.api.params.GenerateMdmMetricsParameters;
import ca.uhn.fhir.mdm.model.MdmResourceMetrics;
import ca.uhn.fhir.mdm.util.MdmSearchParamBuildingUtils;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;

public abstract class BaseMdmMetricSvc
implements IMdmMetricSvc {
    public static final int BUCKETS = 100;
    public static final String NULL_VALUE = "NULL";
    public static final String FIRST_BUCKET = "x_<_%.2f";
    public static final String NTH_BUCKET = "%.2f_<_x_<=_%.2f";
    protected final DaoRegistry myDaoRegistry;

    public BaseMdmMetricSvc(DaoRegistry theDaoRegistry) {
        this.myDaoRegistry = theDaoRegistry;
    }

    protected double getBucket(int theBucketId) {
        return (double)Math.round((float)(100 * theBucketId) / 100.0f) / 100.0;
    }

    protected MdmResourceMetrics generateResourceMetrics(GenerateMdmMetricsParameters theParameters) {
        String resourceType = theParameters.getResourceType();
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceType);
        IBundleProvider outcome = null;
        SearchParameterMap map = null;
        MdmResourceMetrics metrics = new MdmResourceMetrics();
        metrics.setResourceType(resourceType);
        map = MdmSearchParamBuildingUtils.buildBasicGoldenResourceSearchParameterMap(resourceType);
        this.setCountOnly(map);
        outcome = dao.search(map, (RequestDetails)new SystemRequestDetails());
        metrics.setGoldenResourcesCount(outcome.size().intValue());
        map = MdmSearchParamBuildingUtils.buildSearchParameterForBlockedResourceCount(resourceType);
        this.setCountOnly(map);
        outcome = dao.search(map, (RequestDetails)new SystemRequestDetails());
        metrics.setExcludedResources(outcome.size().intValue());
        map = new SearchParameterMap();
        this.setCountOnly(map);
        outcome = dao.search(map, (RequestDetails)new SystemRequestDetails());
        metrics.setSourceResourcesCount((long)outcome.size().intValue() - metrics.getGoldenResourcesCount());
        return metrics;
    }

    private void setCountOnly(SearchParameterMap theMap) {
        theMap.setCount(Integer.valueOf(0));
        theMap.setLoadSynchronous(true);
        theMap.setSearchTotalMode(SearchTotalModeEnum.ACCURATE);
    }
}

