/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.narrative2;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.narrative.INarrativeGenerator;
import ca.uhn.fhir.narrative2.INarrativeTemplate;
import ca.uhn.fhir.narrative2.NarrativeTemplateManifest;
import ca.uhn.fhir.narrative2.TemplateTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.Logs;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.INarrative;

public abstract class BaseNarrativeGenerator
implements INarrativeGenerator {
    @Override
    public boolean populateResourceNarrative(FhirContext theFhirContext, IBaseResource theResource) {
        INarrativeTemplate template = this.selectTemplate(theFhirContext, theResource);
        if (template != null) {
            this.applyTemplate(theFhirContext, template, theResource);
            return true;
        }
        return false;
    }

    @Nullable
    private INarrativeTemplate selectTemplate(FhirContext theFhirContext, IBaseResource theResource) {
        List<INarrativeTemplate> templates = this.getTemplateForElement(theFhirContext, theResource);
        INarrativeTemplate template = null;
        if (templates.isEmpty()) {
            Logs.getNarrativeGenerationTroubleshootingLog().debug("No templates match for resource of type {}", theResource.getClass());
        } else {
            if (templates.size() > 1) {
                Logs.getNarrativeGenerationTroubleshootingLog().debug("Multiple templates match for resource of type {} - Picking first from: {}", theResource.getClass(), templates);
            }
            template = templates.get(0);
            Logs.getNarrativeGenerationTroubleshootingLog().debug("Selected template: {}", (Object)template);
        }
        return template;
    }

    @Override
    public String generateResourceNarrative(FhirContext theFhirContext, IBaseResource theResource) {
        INarrativeTemplate template = this.selectTemplate(theFhirContext, theResource);
        if (template != null) {
            String narrative = this.applyTemplate(theFhirContext, template, (IBase)theResource);
            return BaseNarrativeGenerator.cleanWhitespace(narrative);
        }
        return null;
    }

    protected List<INarrativeTemplate> getTemplateForElement(FhirContext theFhirContext, IBase theElement) {
        return this.getManifest().getTemplateByElement(theFhirContext, this.getStyle(), theElement);
    }

    private boolean applyTemplate(FhirContext theFhirContext, INarrativeTemplate theTemplate, IBaseResource theResource) {
        if (this.templateDoesntApplyToResource(theTemplate, theResource)) {
            return false;
        }
        boolean retVal = false;
        String resourceName = theFhirContext.getResourceType(theResource);
        String contextPath = (String)StringUtils.defaultIfEmpty((CharSequence)theTemplate.getContextPath(), (CharSequence)resourceName);
        List<IBase> targets = this.findElementsInResourceRequiringNarratives(theFhirContext, theResource, contextPath);
        for (IBase nextTargetContext : targets) {
            INarrative nextTargetNarrative = this.getOrCreateNarrativeChildElement(theFhirContext, nextTargetContext);
            String narrative = this.applyTemplate(theFhirContext, theTemplate, nextTargetContext);
            if (!StringUtils.isNotBlank((CharSequence)(narrative = BaseNarrativeGenerator.cleanWhitespace(narrative)))) continue;
            try {
                nextTargetNarrative.setDivAsString(narrative);
                nextTargetNarrative.setStatusAsString("generated");
                retVal = true;
            }
            catch (Exception e) {
                throw new InternalErrorException(Msg.code(1865) + e);
            }
        }
        return retVal;
    }

    private INarrative getOrCreateNarrativeChildElement(FhirContext theFhirContext, IBase nextTargetContext) {
        INarrative nextTargetNarrative;
        BaseRuntimeElementCompositeDefinition targetElementDef = (BaseRuntimeElementCompositeDefinition)theFhirContext.getElementDefinition(nextTargetContext.getClass());
        BaseRuntimeChildDefinition targetTextChild = targetElementDef.getChildByName("text");
        List<IBase> existing = targetTextChild.getAccessor().getValues(nextTargetContext);
        if (existing.isEmpty()) {
            nextTargetNarrative = (INarrative)theFhirContext.getElementDefinition("narrative").newInstance();
            targetTextChild.getMutator().addValue(nextTargetContext, nextTargetNarrative);
        } else {
            nextTargetNarrative = (INarrative)existing.get(0);
        }
        return nextTargetNarrative;
    }

    private List<IBase> findElementsInResourceRequiringNarratives(FhirContext theFhirContext, IBaseResource theResource, String theContextPath) {
        if (theFhirContext.getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
            return Collections.singletonList(theResource);
        }
        IFhirPath fhirPath = theFhirContext.newFluentPath();
        return fhirPath.evaluate((IBase)theResource, theContextPath, IBase.class);
    }

    protected abstract String applyTemplate(FhirContext var1, INarrativeTemplate var2, IBase var3);

    private boolean templateDoesntApplyToResource(INarrativeTemplate theTemplate, IBaseResource theResource) {
        boolean retVal = false;
        if (theTemplate.getAppliesToProfiles() != null && !theTemplate.getAppliesToProfiles().isEmpty()) {
            Set resourceProfiles = theResource.getMeta().getProfile().stream().map(t -> t.getValueAsString()).collect(Collectors.toSet());
            retVal = true;
            for (String next : theTemplate.getAppliesToProfiles()) {
                if (!resourceProfiles.contains(next)) continue;
                retVal = false;
                break;
            }
        }
        return retVal;
    }

    protected abstract EnumSet<TemplateTypeEnum> getStyle();

    public static String cleanWhitespace(String theResult) {
        StringBuilder b = new StringBuilder();
        boolean inWhitespace = false;
        boolean betweenTags = false;
        boolean lastNonWhitespaceCharWasTagEnd = false;
        boolean inPre = false;
        for (int i = 0; i < theResult.length(); ++i) {
            char nextChar = theResult.charAt(i);
            if (inPre) {
                b.append(nextChar);
                continue;
            }
            if (nextChar == '>') {
                b.append(nextChar);
                betweenTags = true;
                lastNonWhitespaceCharWasTagEnd = true;
                continue;
            }
            if (nextChar == '\n' || nextChar == '\r') continue;
            if (betweenTags) {
                if (Character.isWhitespace(nextChar)) {
                    inWhitespace = true;
                    continue;
                }
                if (nextChar == '<') {
                    if (inWhitespace && !lastNonWhitespaceCharWasTagEnd) {
                        b.append(' ');
                    }
                    b.append(nextChar);
                    inWhitespace = false;
                    betweenTags = false;
                    lastNonWhitespaceCharWasTagEnd = false;
                    if (i + 3 >= theResult.length()) continue;
                    char char1 = Character.toLowerCase(theResult.charAt(i + 1));
                    char char2 = Character.toLowerCase(theResult.charAt(i + 2));
                    char char3 = Character.toLowerCase(theResult.charAt(i + 3));
                    char char4 = Character.toLowerCase(i + 4 < theResult.length() ? theResult.charAt(i + 4) : (char)' ');
                    if (char1 == 'p' && char2 == 'r' && char3 == 'e') {
                        inPre = true;
                        continue;
                    }
                    if (char1 != '/' || char2 != 'p' || char3 != 'r' || char4 != 'e') continue;
                    inPre = false;
                    continue;
                }
                lastNonWhitespaceCharWasTagEnd = false;
                if (inWhitespace) {
                    b.append(' ');
                    inWhitespace = false;
                }
                b.append(nextChar);
                continue;
            }
            b.append(nextChar);
        }
        return b.toString();
    }

    protected abstract NarrativeTemplateManifest getManifest();
}

