/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.TerserUtil;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class TerserUtilHelper {
    private FhirContext myContext;
    private FhirTerser myTerser;
    private IBaseResource myResource;

    public static TerserUtilHelper newHelper(FhirContext theFhirContext, String theResourceName) {
        return TerserUtilHelper.newHelper(theFhirContext, (IBaseResource)TerserUtil.newResource(theFhirContext, theResourceName));
    }

    public static TerserUtilHelper newHelper(FhirContext theFhirContext, IBaseResource theResource) {
        TerserUtilHelper retVal = new TerserUtilHelper(theFhirContext, theResource);
        return retVal;
    }

    protected TerserUtilHelper(FhirContext theFhirContext, IBaseResource theResource) {
        this.myContext = theFhirContext;
        this.myResource = theResource;
    }

    public TerserUtilHelper setField(String theField, String theValue) {
        IBase value = this.newStringElement(theValue);
        TerserUtil.setFieldByFhirPath(this.getTerser(), theField, this.myResource, value);
        return this;
    }

    public TerserUtilHelper setField(String theField, String theFieldType, Object theValue) {
        IBase value = this.newElement(theFieldType, theValue);
        TerserUtil.setFieldByFhirPath(this.getTerser(), theField, this.myResource, value);
        return this;
    }

    protected IBase newStringElement(String theValue) {
        return this.newElement("string", theValue);
    }

    protected IBase newElement(String theElementType, Object theValue) {
        Object value = TerserUtil.newElement(this.myContext, theElementType, theValue);
        return value;
    }

    public List<IBase> getFieldValues(String theField) {
        return TerserUtil.getValues(this.myContext, this.myResource, theField);
    }

    public List<IBase> getFieldValuesByFhirPath(String theFhirPath) {
        return TerserUtil.getFieldByFhirPath(this.myContext, theFhirPath, this.myResource);
    }

    public IBase getFieldValueByFhirPath(String theFhirPath) {
        return TerserUtil.getFirstFieldByFhirPath(this.myContext, theFhirPath, this.myResource);
    }

    public IBase getFieldValue(String theField) {
        List<IBase> values = this.getFieldValues(theField);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public FhirTerser getTerser() {
        if (this.myTerser == null) {
            this.myTerser = this.myContext.newTerser();
        }
        return this.myTerser;
    }

    public <T extends IBaseResource> T getResource() {
        return (T)this.myResource;
    }

    public RuntimeResourceDefinition getResourceDefinition() {
        return this.myContext.getResourceDefinition(this.myResource);
    }

    public IBase newElement(String theElementName) {
        return TerserUtil.newElement(this.myContext, theElementName);
    }

    public FhirContext getContext() {
        return this.myContext;
    }
}

