/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.param.BaseParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseParamWithPrefix<T extends BaseParam>
extends BaseParam {
    private static final long serialVersionUID = 1L;
    private static final Logger ourLog = LoggerFactory.getLogger(BaseParamWithPrefix.class);
    private ParamPrefixEnum myPrefix;

    BaseParamWithPrefix() {
    }

    String extractPrefixAndReturnRest(String theString) {
        char nextChar;
        int offset;
        for (offset = 0; theString.length() != offset && (nextChar = theString.charAt(offset)) != '-' && nextChar != '%' && !Character.isDigit(nextChar); ++offset) {
        }
        if (offset > 0 && theString.length() == offset) {
            throw new DataFormatException(Msg.code(1940) + "Invalid date/time format: \"" + theString + "\"");
        }
        String prefix = theString.substring(0, offset);
        if (!StringUtils.isBlank((CharSequence)prefix)) {
            this.myPrefix = ParamPrefixEnum.forValue(prefix);
            if (this.myPrefix == null) {
                switch (prefix) {
                    case ">=": {
                        this.myPrefix = ParamPrefixEnum.GREATERTHAN_OR_EQUALS;
                        break;
                    }
                    case ">": {
                        this.myPrefix = ParamPrefixEnum.GREATERTHAN;
                        break;
                    }
                    case "<=": {
                        this.myPrefix = ParamPrefixEnum.LESSTHAN_OR_EQUALS;
                        break;
                    }
                    case "<": {
                        this.myPrefix = ParamPrefixEnum.LESSTHAN;
                        break;
                    }
                    case "~": {
                        this.myPrefix = ParamPrefixEnum.APPROXIMATE;
                        break;
                    }
                    case "=": {
                        this.myPrefix = ParamPrefixEnum.EQUAL;
                        break;
                    }
                    default: {
                        throw new DataFormatException(Msg.code(1941) + "Invalid prefix: \"" + prefix + "\"");
                    }
                }
                ourLog.warn("Date parameter has legacy prefix '{}' which has been removed from FHIR. This should be replaced with '{}'", (Object)prefix, (Object)this.myPrefix.getValue());
            }
        }
        return theString.substring(offset);
    }

    public ParamPrefixEnum getPrefix() {
        return this.myPrefix;
    }

    public T setPrefix(ParamPrefixEnum thePrefix) {
        this.myPrefix = thePrefix;
        return (T)this;
    }
}

