/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeChildContainedResources;
import ca.uhn.fhir.context.RuntimeChildNarrativeDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IIdentifiableElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ISupportsUndeclaredExtensions;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.path.EncodeContextPath;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseElement;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseHasModifierExtensions;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseParser
implements IParser {
    public static final String RESOURCE_CREATED_BY_PARSER = BaseParser.class.getName() + "_RESOURCE_CREATED_BY_PARSER";
    private static final Logger ourLog = LoggerFactory.getLogger(BaseParser.class);
    private static final Set<String> notEncodeForContainedResource = new HashSet<String>(Arrays.asList("security", "versionId", "lastUpdated"));
    private FhirTerser.ContainedResources myContainedResources;
    private boolean myEncodeElementsAppliesToChildResourcesOnly;
    private FhirContext myContext;
    private List<EncodeContextPath> myDontEncodeElements;
    private List<EncodeContextPath> myEncodeElements;
    private Set<String> myEncodeElementsAppliesToResourceTypes;
    private IIdType myEncodeForceResourceId;
    private IParserErrorHandler myErrorHandler;
    private boolean myOmitResourceId;
    private List<Class<? extends IBaseResource>> myPreferTypes;
    private String myServerBaseUrl;
    private Boolean myStripVersionsFromReferences;
    private Boolean myOverrideResourceIdWithBundleEntryFullUrl;
    private boolean mySummaryMode;
    private boolean mySuppressNarratives;
    private Set<String> myDontStripVersionsFromReferencesAtPaths;

    public BaseParser(FhirContext theContext, IParserErrorHandler theParserErrorHandler) {
        this.myContext = theContext;
        this.myErrorHandler = theParserErrorHandler;
    }

    protected FhirContext getContext() {
        return this.myContext;
    }

    List<EncodeContextPath> getDontEncodeElements() {
        return this.myDontEncodeElements;
    }

    @Override
    public IParser setDontEncodeElements(Collection<String> theDontEncodeElements) {
        this.myDontEncodeElements = theDontEncodeElements == null || theDontEncodeElements.isEmpty() ? null : theDontEncodeElements.stream().map(EncodeContextPath::new).collect(Collectors.toList());
        return this;
    }

    List<EncodeContextPath> getEncodeElements() {
        return this.myEncodeElements;
    }

    @Override
    public IParser setEncodeElements(Set<String> theEncodeElements) {
        if (theEncodeElements == null || theEncodeElements.isEmpty()) {
            this.myEncodeElements = null;
            this.myEncodeElementsAppliesToResourceTypes = null;
        } else {
            this.myEncodeElements = theEncodeElements.stream().map(EncodeContextPath::new).collect(Collectors.toList());
            this.myEncodeElementsAppliesToResourceTypes = new HashSet<String>();
            for (String next : this.myEncodeElements.stream().map(t -> t.getPath().get(0).getName()).collect(Collectors.toList())) {
                if (next.startsWith("*")) {
                    this.myEncodeElementsAppliesToResourceTypes = null;
                    break;
                }
                int dotIdx = next.indexOf(46);
                if (dotIdx == -1) {
                    this.myEncodeElementsAppliesToResourceTypes.add(next);
                    continue;
                }
                this.myEncodeElementsAppliesToResourceTypes.add(next.substring(0, dotIdx));
            }
        }
        return this;
    }

    protected Iterable<CompositeChildElement> compositeChildIterator(IBase theCompositeElement, boolean theContainedResource, CompositeChildElement theParent, EncodeContext theEncodeContext) {
        BaseRuntimeElementCompositeDefinition elementDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(theCompositeElement.getClass());
        return theEncodeContext.getCompositeChildrenCache().computeIfAbsent(new Key(elementDef, theContainedResource, theParent, theEncodeContext), k -> {
            List<BaseRuntimeChildDefinition> children = elementDef.getChildrenAndExtension();
            ArrayList<CompositeChildElement> result = new ArrayList<CompositeChildElement>(children.size());
            for (BaseRuntimeChildDefinition child : children) {
                CompositeChildElement myNext = new CompositeChildElement(theParent, child, theEncodeContext);
                if (myNext.getDef().getElementName().equals("id") || !myNext.shouldBeEncoded(theContainedResource) || (myNext.getDef() instanceof RuntimeChildNarrativeDefinition ? this.isSuppressNarratives() || this.isSummaryMode() || theContainedResource : myNext.getDef() instanceof RuntimeChildContainedResources && theContainedResource)) continue;
                result.add(myNext);
            }
            return result;
        });
    }

    private String determineReferenceText(IBaseReference theRef, CompositeChildElement theCompositeChildElement) {
        IIdType ref = theRef.getReferenceElement();
        if (StringUtils.isBlank((CharSequence)ref.getIdPart())) {
            String reference = ref.getValue();
            if (theRef.getResource() != null) {
                IIdType containedId = this.getContainedResources().getResourceId(theRef.getResource());
                if (containedId != null && !containedId.isEmpty()) {
                    reference = containedId.isLocal() ? containedId.getValue() : "#" + containedId.getValue();
                } else {
                    IIdType refId = theRef.getResource().getIdElement();
                    if (refId != null && refId.hasIdPart()) {
                        if (refId.getValue().startsWith("urn:")) {
                            reference = refId.getValue();
                        } else {
                            if (!refId.hasResourceType()) {
                                refId = refId.withResourceType(this.myContext.getResourceDefinition(theRef.getResource()).getName());
                            }
                            reference = this.isStripVersionsFromReferences(theCompositeChildElement) ? refId.toVersionless().getValue() : refId.getValue();
                        }
                    }
                }
            }
            return reference;
        }
        if (!ref.hasResourceType() && !ref.isLocal() && theRef.getResource() != null) {
            ref = ref.withResourceType(this.myContext.getResourceDefinition(theRef.getResource()).getName());
        }
        if (StringUtils.isNotBlank((CharSequence)this.myServerBaseUrl) && StringUtils.equals((CharSequence)this.myServerBaseUrl, (CharSequence)ref.getBaseUrl())) {
            if (this.isStripVersionsFromReferences(theCompositeChildElement)) {
                return ref.toUnqualifiedVersionless().getValue();
            }
            return ref.toUnqualified().getValue();
        }
        if (this.isStripVersionsFromReferences(theCompositeChildElement)) {
            return ref.toVersionless().getValue();
        }
        return ref.getValue();
    }

    protected abstract void doEncodeResourceToWriter(IBaseResource var1, Writer var2, EncodeContext var3) throws IOException, DataFormatException;

    protected abstract <T extends IBaseResource> T doParseResource(Class<T> var1, Reader var2) throws DataFormatException;

    @Override
    public String encodeResourceToString(IBaseResource theResource) throws DataFormatException {
        StringBuilderWriter stringWriter = new StringBuilderWriter();
        try {
            this.encodeResourceToWriter(theResource, (Writer)stringWriter);
        }
        catch (IOException e) {
            throw new Error(Msg.code(1828) + "Encountered IOException during write to string - This should not happen!");
        }
        return stringWriter.toString();
    }

    @Override
    public final void encodeResourceToWriter(IBaseResource theResource, Writer theWriter) throws IOException, DataFormatException {
        EncodeContext encodeContext = new EncodeContext();
        this.encodeResourceToWriter(theResource, theWriter, encodeContext);
    }

    protected void encodeResourceToWriter(IBaseResource theResource, Writer theWriter, EncodeContext theEncodeContext) throws IOException {
        Validate.notNull((Object)theResource, (String)"theResource can not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theWriter, (String)"theWriter can not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theEncodeContext, (String)"theEncodeContext can not be null", (Object[])new Object[0]);
        if (theResource.getStructureFhirVersionEnum() != this.myContext.getVersion().getVersion()) {
            throw new IllegalArgumentException(Msg.code(1829) + "This parser is for FHIR version " + (Object)((Object)this.myContext.getVersion().getVersion()) + " - Can not encode a structure for version " + (Object)((Object)theResource.getStructureFhirVersionEnum()));
        }
        String resourceName = this.myContext.getResourceType(theResource);
        theEncodeContext.pushPath(resourceName, true);
        this.doEncodeResourceToWriter(theResource, theWriter, theEncodeContext);
        theEncodeContext.popPath();
    }

    private void filterCodingsWithNoCodeOrSystem(List<? extends IBaseCoding> tagList) {
        for (int i = 0; i < tagList.size(); ++i) {
            if (!StringUtils.isBlank((CharSequence)tagList.get(i).getCode()) || !StringUtils.isBlank((CharSequence)tagList.get(i).getSystem())) continue;
            tagList.remove(i);
            --i;
        }
    }

    protected IIdType fixContainedResourceId(String theValue) {
        IIdType retVal = (IIdType)this.myContext.getElementDefinition("id").newInstance();
        if (StringUtils.isNotBlank((CharSequence)theValue) && theValue.charAt(0) == '#') {
            retVal.setValue(theValue.substring(1));
        } else {
            retVal.setValue(theValue);
        }
        return retVal;
    }

    ChildNameAndDef getChildNameAndDef(BaseRuntimeChildDefinition theChild, IBase theValue) {
        Class<?> type = theValue.getClass();
        String childName = theChild.getChildNameByDatatype(type);
        BaseRuntimeElementDefinition<?> childDef = theChild.getChildElementDefinitionByDatatype(type);
        if (childDef == null) {
            BaseRuntimeElementDefinition<?> elementDef = this.myContext.getElementDefinition(type);
            if (elementDef.getName().equals("code")) {
                Class<?> type2 = this.myContext.getElementDefinition("code").getImplementingClass();
                childDef = theChild.getChildElementDefinitionByDatatype(type2);
                childName = theChild.getChildNameByDatatype(type2);
            }
            if (childDef == null) {
                Class<?> nextSuperType = theValue.getClass();
                while (IBase.class.isAssignableFrom(nextSuperType) && childDef == null) {
                    if (!Modifier.isAbstract(nextSuperType.getModifiers())) {
                        BaseRuntimeElementDefinition<?> def = this.myContext.getElementDefinition(nextSuperType);
                        Class<?> nextChildType = def.getImplementingClass();
                        childDef = theChild.getChildElementDefinitionByDatatype(nextChildType);
                        childName = theChild.getChildNameByDatatype(nextChildType);
                    }
                    nextSuperType = nextSuperType.getSuperclass();
                }
            }
            if (childDef == null) {
                this.throwExceptionForUnknownChildType(theChild, type);
            }
        }
        return new ChildNameAndDef(childName, childDef);
    }

    protected String getCompositeElementId(IBase theElement) {
        String elementId = null;
        if (!(theElement instanceof IBaseResource)) {
            if (theElement instanceof IBaseElement) {
                elementId = ((IBaseElement)((Object)theElement)).getId();
            } else if (theElement instanceof IIdentifiableElement) {
                elementId = ((IIdentifiableElement)theElement).getElementSpecificId();
            }
        }
        return elementId;
    }

    FhirTerser.ContainedResources getContainedResources() {
        return this.myContainedResources;
    }

    void setContainedResources(FhirTerser.ContainedResources theContainedResources) {
        this.myContainedResources = theContainedResources;
    }

    @Override
    public Set<String> getDontStripVersionsFromReferencesAtPaths() {
        return this.myDontStripVersionsFromReferencesAtPaths;
    }

    @Override
    public IIdType getEncodeForceResourceId() {
        return this.myEncodeForceResourceId;
    }

    @Override
    public BaseParser setEncodeForceResourceId(IIdType theEncodeForceResourceId) {
        this.myEncodeForceResourceId = theEncodeForceResourceId;
        return this;
    }

    protected IParserErrorHandler getErrorHandler() {
        return this.myErrorHandler;
    }

    protected List<Map.Entry<ResourceMetadataKeyEnum<?>, Object>> getExtensionMetadataKeys(IResource resource) {
        ArrayList extensionMetadataKeys = new ArrayList();
        for (Map.Entry entry : resource.getResourceMetadata().entrySet()) {
            if (!(entry.getKey() instanceof ResourceMetadataKeyEnum.ExtensionResourceMetadataKey)) continue;
            extensionMetadataKeys.add(entry);
        }
        return extensionMetadataKeys;
    }

    protected String getExtensionUrl(String extensionUrl) {
        String url = extensionUrl;
        if (StringUtils.isNotBlank((CharSequence)extensionUrl) && StringUtils.isNotBlank((CharSequence)this.myServerBaseUrl)) {
            url = !UrlUtil.isValid(extensionUrl) && extensionUrl.startsWith("/") ? this.myServerBaseUrl + extensionUrl : extensionUrl;
        }
        return url;
    }

    protected TagList getMetaTagsForEncoding(IResource theIResource, EncodeContext theEncodeContext) {
        TagList tags = ResourceMetadataKeyEnum.TAG_LIST.get(theIResource);
        if (this.shouldAddSubsettedTag(theEncodeContext)) {
            tags = new TagList(tags);
            tags.add(new Tag(this.getSubsettedCodeSystem(), "SUBSETTED", this.subsetDescription()));
        }
        return tags;
    }

    @Override
    public List<Class<? extends IBaseResource>> getPreferTypes() {
        return this.myPreferTypes;
    }

    @Override
    public void setPreferTypes(List<Class<? extends IBaseResource>> thePreferTypes) {
        if (thePreferTypes != null) {
            ArrayList<Class<? extends IBaseResource>> types = new ArrayList<Class<? extends IBaseResource>>();
            for (Class<? extends IBaseResource> next : thePreferTypes) {
                if (Modifier.isAbstract(next.getModifiers())) continue;
                types.add(next);
            }
            this.myPreferTypes = Collections.unmodifiableList(types);
        } else {
            this.myPreferTypes = thePreferTypes;
        }
    }

    protected <T extends IPrimitiveType<String>> List<T> getProfileTagsForEncoding(IBaseResource theResource, List<T> theProfiles) {
        switch (this.myContext.getAddProfileTagWhenEncoding()) {
            case NEVER: {
                return theProfiles;
            }
            case ONLY_FOR_CUSTOM: {
                RuntimeResourceDefinition resDef = this.myContext.getResourceDefinition(theResource);
                if (!resDef.isStandardType()) break;
                return theProfiles;
            }
        }
        RuntimeResourceDefinition nextDef = this.myContext.getResourceDefinition(theResource);
        String profile = nextDef.getResourceProfile(this.myServerBaseUrl);
        if (StringUtils.isNotBlank((CharSequence)profile)) {
            for (IPrimitiveType next : theProfiles) {
                if (!profile.equals(next.getValue())) continue;
                return theProfiles;
            }
            ArrayList<T> newList = new ArrayList<T>(theProfiles);
            BaseRuntimeElementDefinition<?> idElement = this.myContext.getElementDefinition("id");
            IPrimitiveType newId = (IPrimitiveType)idElement.newInstance();
            newId.setValue(profile);
            newList.add(newId);
            return newList;
        }
        return theProfiles;
    }

    protected String getServerBaseUrl() {
        return this.myServerBaseUrl;
    }

    @Override
    public Boolean getStripVersionsFromReferences() {
        return this.myStripVersionsFromReferences;
    }

    @Deprecated
    public boolean getSuppressNarratives() {
        return this.mySuppressNarratives;
    }

    protected boolean isChildContained(BaseRuntimeElementDefinition<?> childDef, boolean theIncludedResource) {
        return (childDef.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.CONTAINED_RESOURCES || childDef.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.CONTAINED_RESOURCE_LIST) && !this.getContainedResources().isEmpty() && !theIncludedResource;
    }

    @Override
    public boolean isEncodeElementsAppliesToChildResourcesOnly() {
        return this.myEncodeElementsAppliesToChildResourcesOnly;
    }

    @Override
    public void setEncodeElementsAppliesToChildResourcesOnly(boolean theEncodeElementsAppliesToChildResourcesOnly) {
        this.myEncodeElementsAppliesToChildResourcesOnly = theEncodeElementsAppliesToChildResourcesOnly;
    }

    @Override
    public boolean isOmitResourceId() {
        return this.myOmitResourceId;
    }

    private boolean isOverrideResourceIdWithBundleEntryFullUrl() {
        Boolean overrideResourceIdWithBundleEntryFullUrl = this.myOverrideResourceIdWithBundleEntryFullUrl;
        if (overrideResourceIdWithBundleEntryFullUrl != null) {
            return overrideResourceIdWithBundleEntryFullUrl;
        }
        return this.myContext.getParserOptions().isOverrideResourceIdWithBundleEntryFullUrl();
    }

    private boolean isStripVersionsFromReferences(CompositeChildElement theCompositeChildElement) {
        Boolean stripVersionsFromReferences = this.myStripVersionsFromReferences;
        if (stripVersionsFromReferences != null) {
            return stripVersionsFromReferences;
        }
        if (!this.myContext.getParserOptions().isStripVersionsFromReferences()) {
            return false;
        }
        Set<String> dontStripVersionsFromReferencesAtPaths = this.myDontStripVersionsFromReferencesAtPaths;
        if (dontStripVersionsFromReferencesAtPaths != null && !dontStripVersionsFromReferencesAtPaths.isEmpty() && theCompositeChildElement.anyPathMatches(dontStripVersionsFromReferencesAtPaths)) {
            return false;
        }
        dontStripVersionsFromReferencesAtPaths = this.myContext.getParserOptions().getDontStripVersionsFromReferencesAtPaths();
        return dontStripVersionsFromReferencesAtPaths.isEmpty() || !theCompositeChildElement.anyPathMatches(dontStripVersionsFromReferencesAtPaths);
    }

    @Override
    public boolean isSummaryMode() {
        return this.mySummaryMode;
    }

    public boolean isSuppressNarratives() {
        return this.mySuppressNarratives;
    }

    @Override
    public IBaseResource parseResource(InputStream theInputStream) throws DataFormatException {
        return this.parseResource(new InputStreamReader(theInputStream, Charsets.UTF_8));
    }

    @Override
    public <T extends IBaseResource> T parseResource(Class<T> theResourceType, InputStream theInputStream) throws DataFormatException {
        return this.parseResource(theResourceType, new InputStreamReader(theInputStream, Constants.CHARSET_UTF8));
    }

    @Override
    public <T extends IBaseResource> T parseResource(Class<T> theResourceType, Reader theReader) throws DataFormatException {
        T retVal;
        RuntimeResourceDefinition def;
        if (theResourceType != null) {
            this.myContext.getResourceDefinition(theResourceType);
        }
        if ("Bundle".equals((def = this.myContext.getResourceDefinition((IBaseResource)(retVal = this.doParseResource(theResourceType, theReader)))).getName()) && this.isOverrideResourceIdWithBundleEntryFullUrl()) {
            BundleUtil.processEntries(this.myContext, (IBaseBundle)retVal, t -> {
                IBaseResource resource;
                String fullUrl = t.getFullUrl();
                if (fullUrl != null && (resource = t.getResource()) != null) {
                    IIdType resourceId = resource.getIdElement();
                    if (StringUtils.isBlank((CharSequence)resourceId.getValue())) {
                        resourceId.setValue(fullUrl);
                    } else if (fullUrl.startsWith("urn:") && fullUrl.length() > resourceId.getIdPart().length() && fullUrl.charAt(fullUrl.length() - resourceId.getIdPart().length() - 1) == ':' && fullUrl.endsWith(resourceId.getIdPart())) {
                        resourceId.setValue(fullUrl);
                    } else {
                        IIdType fullUrlId = this.myContext.getVersion().newIdType();
                        fullUrlId.setValue(fullUrl);
                        if (this.myContext.getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
                            IIdType newId = fullUrlId;
                            if (!newId.hasVersionIdPart() && resourceId.hasVersionIdPart()) {
                                newId = newId.withVersion(resourceId.getVersionIdPart());
                            }
                            resourceId.setValue(newId.getValue());
                        } else if (StringUtils.equals((CharSequence)fullUrlId.getIdPart(), (CharSequence)resourceId.getIdPart()) && fullUrlId.hasBaseUrl()) {
                            IIdType newResourceId = resourceId.withServerBase(fullUrlId.getBaseUrl(), resourceId.getResourceType());
                            resourceId.setValue(newResourceId.getValue());
                        }
                    }
                }
            });
        }
        return retVal;
    }

    @Override
    public <T extends IBaseResource> T parseResource(Class<T> theResourceType, String theMessageString) {
        StringReader reader = new StringReader(theMessageString);
        return this.parseResource(theResourceType, reader);
    }

    @Override
    public IBaseResource parseResource(Reader theReader) throws ConfigurationException, DataFormatException {
        return this.parseResource(null, theReader);
    }

    @Override
    public IBaseResource parseResource(String theMessageString) throws ConfigurationException, DataFormatException {
        return this.parseResource(null, theMessageString);
    }

    protected List<? extends IBase> preProcessValues(BaseRuntimeChildDefinition theMetaChildUncast, IBaseResource theResource, List<? extends IBase> theValues, CompositeChildElement theCompositeChildElement, EncodeContext theEncodeContext) {
        if (this.myContext.getVersion().getVersion().isRi()) {
            BaseRuntimeElementDefinition<?> metaChild;
            if (theValues.isEmpty() && theMetaChildUncast.getElementName().equals("meta") && IBaseMetaType.class.isAssignableFrom((metaChild = theMetaChildUncast.getChildByName("meta")).getImplementingClass())) {
                IBaseMetaType newType = (IBaseMetaType)metaChild.newInstance();
                theValues = Collections.singletonList(newType);
            }
            if (theValues.size() == 1 && theValues.get(0) instanceof IBaseMetaType) {
                IBaseMetaType metaValue = (IBaseMetaType)theValues.get(0);
                try {
                    metaValue = (IBaseMetaType)metaValue.getClass().getMethod("copy", new Class[0]).invoke((Object)metaValue, new Object[0]);
                }
                catch (Exception e) {
                    throw new InternalErrorException(Msg.code(1830) + "Failed to duplicate meta", (Throwable)e);
                }
                if (StringUtils.isBlank((CharSequence)metaValue.getVersionId()) && theResource.getIdElement().hasVersionIdPart()) {
                    metaValue.setVersionId(theResource.getIdElement().getVersionIdPart());
                }
                this.filterCodingsWithNoCodeOrSystem(metaValue.getTag());
                this.filterCodingsWithNoCodeOrSystem(metaValue.getSecurity());
                List<? extends IPrimitiveType<String>> newProfileList = this.getProfileTagsForEncoding(theResource, metaValue.getProfile());
                List<? extends IPrimitiveType<String>> oldProfileList = metaValue.getProfile();
                if (oldProfileList != newProfileList) {
                    oldProfileList.clear();
                    for (IPrimitiveType<String> iPrimitiveType : newProfileList) {
                        if (!StringUtils.isNotBlank((CharSequence)iPrimitiveType.getValue())) continue;
                        metaValue.addProfile(iPrimitiveType.getValue());
                    }
                }
                if (this.shouldAddSubsettedTag(theEncodeContext)) {
                    IBaseCoding coding = metaValue.addTag();
                    coding.setCode("SUBSETTED");
                    coding.setSystem(this.getSubsettedCodeSystem());
                    coding.setDisplay(this.subsetDescription());
                }
                return Collections.singletonList(metaValue);
            }
        }
        List<? extends IBase> retVal = theValues;
        for (int i = 0; i < retVal.size(); ++i) {
            IBaseReference nextRef;
            String string;
            IBase next = retVal.get(i);
            if (!(next instanceof IBaseReference) || StringUtils.equals((CharSequence)(string = this.determineReferenceText(nextRef = (IBaseReference)next, theCompositeChildElement)), (CharSequence)nextRef.getReferenceElement().getValue())) continue;
            if (retVal == theValues) {
                retVal = new ArrayList<IBase>(theValues);
            }
            IBaseReference newRef = (IBaseReference)this.myContext.getElementDefinition(nextRef.getClass()).newInstance();
            this.myContext.newTerser().cloneInto(nextRef, newRef, true);
            newRef.setReference(string);
            retVal.set(i, newRef);
        }
        return retVal;
    }

    private String getSubsettedCodeSystem() {
        if (this.myContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.R4)) {
            return "http://terminology.hl7.org/CodeSystem/v3-ObservationValue";
        }
        return "http://hl7.org/fhir/v3/ObservationValue";
    }

    @Override
    public IParser setDontStripVersionsFromReferencesAtPaths(String ... thePaths) {
        if (thePaths == null) {
            this.setDontStripVersionsFromReferencesAtPaths((Collection<String>)null);
        } else {
            this.setDontStripVersionsFromReferencesAtPaths(Arrays.asList(thePaths));
        }
        return this;
    }

    @Override
    public IParser setDontStripVersionsFromReferencesAtPaths(Collection<String> thePaths) {
        this.myDontStripVersionsFromReferencesAtPaths = thePaths == null ? Collections.emptySet() : (thePaths instanceof HashSet ? (Set<Object>)((HashSet)thePaths).clone() : new HashSet<String>(thePaths));
        return this;
    }

    @Override
    public IParser setOmitResourceId(boolean theOmitResourceId) {
        this.myOmitResourceId = theOmitResourceId;
        return this;
    }

    @Override
    public IParser setOverrideResourceIdWithBundleEntryFullUrl(Boolean theOverrideResourceIdWithBundleEntryFullUrl) {
        this.myOverrideResourceIdWithBundleEntryFullUrl = theOverrideResourceIdWithBundleEntryFullUrl;
        return this;
    }

    @Override
    public IParser setParserErrorHandler(IParserErrorHandler theErrorHandler) {
        Validate.notNull((Object)theErrorHandler, (String)"theErrorHandler must not be null", (Object[])new Object[0]);
        this.myErrorHandler = theErrorHandler;
        return this;
    }

    @Override
    public IParser setServerBaseUrl(String theUrl) {
        this.myServerBaseUrl = StringUtils.isNotBlank((CharSequence)theUrl) ? theUrl : null;
        return this;
    }

    @Override
    public IParser setStripVersionsFromReferences(Boolean theStripVersionsFromReferences) {
        this.myStripVersionsFromReferences = theStripVersionsFromReferences;
        return this;
    }

    @Override
    public IParser setSummaryMode(boolean theSummaryMode) {
        this.mySummaryMode = theSummaryMode;
        return this;
    }

    @Override
    public IParser setSuppressNarratives(boolean theSuppressNarratives) {
        this.mySuppressNarratives = theSuppressNarratives;
        return this;
    }

    protected boolean shouldAddSubsettedTag(EncodeContext theEncodeContext) {
        if (this.isSummaryMode()) {
            return true;
        }
        if (this.isSuppressNarratives()) {
            return true;
        }
        if (this.myEncodeElements != null) {
            if (this.isEncodeElementsAppliesToChildResourcesOnly() && theEncodeContext.getResourcePath().size() < 2) {
                return false;
            }
            String currentResourceName = theEncodeContext.getResourcePath().get(theEncodeContext.getResourcePath().size() - 1).getName();
            return this.myEncodeElementsAppliesToResourceTypes == null || this.myEncodeElementsAppliesToResourceTypes.contains(currentResourceName);
        }
        return false;
    }

    protected boolean shouldEncodeResourceId(IBaseResource theResource, EncodeContext theEncodeContext) {
        boolean retVal = true;
        if (this.isOmitResourceId() && theEncodeContext.getPath().size() == 1) {
            retVal = false;
        } else if (this.myDontEncodeElements != null) {
            String resourceName = this.myContext.getResourceType(theResource);
            if (this.myDontEncodeElements.stream().anyMatch(t -> t.equalsPath(resourceName + ".id"))) {
                retVal = false;
            } else if (this.myDontEncodeElements.stream().anyMatch(t -> t.equalsPath("*.id"))) {
                retVal = false;
            } else if (theEncodeContext.getResourcePath().size() == 1 && this.myDontEncodeElements.stream().anyMatch(t -> t.equalsPath("id"))) {
                retVal = false;
            }
        }
        return retVal;
    }

    protected boolean shouldEncodeResourceMeta(IResource theResource) {
        return this.shouldEncodePath(theResource, "meta");
    }

    protected boolean shouldEncodePath(IResource theResource, String thePath) {
        if (this.myDontEncodeElements != null) {
            String resourceName = this.myContext.getResourceType(theResource);
            if (this.myDontEncodeElements.stream().anyMatch(t -> t.equalsPath(resourceName + "." + thePath))) {
                return false;
            }
            return this.myDontEncodeElements.stream().noneMatch(t -> t.equalsPath("*." + thePath));
        }
        return true;
    }

    private String subsetDescription() {
        return "Resource encoded in summary mode";
    }

    protected void throwExceptionForUnknownChildType(BaseRuntimeChildDefinition nextChild, Class<? extends IBase> theType) {
        if (nextChild instanceof BaseRuntimeDeclaredChildDefinition) {
            StringBuilder b = new StringBuilder();
            b.append(nextChild.getElementName());
            b.append(" has type ");
            b.append(theType.getName());
            b.append(" but this is not a valid type for this element");
            if (nextChild instanceof RuntimeChildChoiceDefinition) {
                RuntimeChildChoiceDefinition choice = (RuntimeChildChoiceDefinition)nextChild;
                b.append(" - Expected one of: " + choice.getValidChildTypes());
            }
            throw new DataFormatException(Msg.code(1831) + b.toString());
        }
        throw new DataFormatException(Msg.code(1832) + nextChild + " has no child of type " + theType);
    }

    protected boolean shouldEncodeResource(String theName) {
        if (this.myDontEncodeElements != null) {
            for (EncodeContextPath next : this.myDontEncodeElements) {
                if (!next.equalsPath(theName)) continue;
                return false;
            }
        }
        return true;
    }

    protected static <T> List<T> extractMetadataListNotNull(IResource resource, ResourceMetadataKeyEnum<List<T>> key) {
        List<T> securityLabels = key.get(resource);
        if (securityLabels == null) {
            securityLabels = Collections.emptyList();
        }
        return new ArrayList<T>(securityLabels);
    }

    static boolean hasNoExtensions(IBase theElement) {
        Object res;
        if (theElement instanceof ISupportsUndeclaredExtensions && ((res = (ISupportsUndeclaredExtensions)theElement).getUndeclaredExtensions().size() > 0 || res.getUndeclaredModifierExtensions().size() > 0)) {
            return false;
        }
        if (theElement instanceof IBaseHasExtensions && (res = (IBaseHasExtensions)theElement).hasExtension()) {
            return false;
        }
        if (theElement instanceof IBaseHasModifierExtensions) {
            res = (IBaseHasModifierExtensions)((Object)theElement);
            return !res.hasModifierExtension();
        }
        return true;
    }

    public class EncodeContext
    extends EncodeContextPath {
        private final Map<Key, List<CompositeChildElement>> myCompositeChildrenCache = new HashMap<Key, List<CompositeChildElement>>();

        public Map<Key, List<CompositeChildElement>> getCompositeChildrenCache() {
            return this.myCompositeChildrenCache;
        }
    }

    private static class Key {
        private final BaseRuntimeElementCompositeDefinition<?> resDef;
        private final boolean theContainedResource;
        private final CompositeChildElement theParent;
        private final EncodeContext theEncodeContext;

        public Key(BaseRuntimeElementCompositeDefinition<?> resDef, boolean theContainedResource, CompositeChildElement theParent, EncodeContext theEncodeContext) {
            this.resDef = resDef;
            this.theContainedResource = theContainedResource;
            this.theParent = theParent;
            this.theEncodeContext = theEncodeContext;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.resDef == null ? 0 : this.resDef.hashCode());
            result = 31 * result + (this.theContainedResource ? 1231 : 1237);
            result = 31 * result + (this.theParent == null ? 0 : this.theParent.hashCode());
            result = 31 * result + (this.theEncodeContext == null ? 0 : this.theEncodeContext.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Key) {
                Key that = (Key)obj;
                return Objects.equals(this.resDef, that.resDef) && this.theContainedResource == that.theContainedResource && Objects.equals(this.theParent, that.theParent) && Objects.equals(this.theEncodeContext, that.theEncodeContext);
            }
            return false;
        }
    }

    protected class CompositeChildElement {
        private final BaseRuntimeChildDefinition myDef;
        private final CompositeChildElement myParent;
        private final RuntimeResourceDefinition myResDef;
        private final EncodeContext myEncodeContext;

        public CompositeChildElement(@Nullable CompositeChildElement theParent, BaseRuntimeChildDefinition theDef, EncodeContext theEncodeContext) {
            StringBuilder path;
            this.myDef = theDef;
            this.myParent = theParent;
            this.myResDef = null;
            this.myEncodeContext = theEncodeContext;
            if (ourLog.isTraceEnabled() && theParent != null && (path = theParent.buildPath()) != null) {
                path.append('.');
                if (this.myDef != null) {
                    path.append(this.myDef.getElementName());
                }
                ourLog.trace(" * Next path: {}", (Object)path.toString());
            }
        }

        public CompositeChildElement(RuntimeResourceDefinition theResDef, EncodeContext theEncodeContext) {
            this.myResDef = theResDef;
            this.myDef = null;
            this.myParent = null;
            this.myEncodeContext = theEncodeContext;
        }

        public String toString() {
            return this.myDef.getElementName();
        }

        private void addParent(CompositeChildElement theParent, StringBuilder theB) {
            if (theParent != null) {
                if (theParent.myResDef != null) {
                    theB.append(theParent.myResDef.getName());
                    return;
                }
                if (theParent.myParent != null) {
                    this.addParent(theParent.myParent, theB);
                }
                if (theParent.myDef != null) {
                    if (theB.length() > 0) {
                        theB.append('.');
                    }
                    theB.append(theParent.myDef.getElementName());
                }
            }
        }

        public boolean anyPathMatches(Set<String> thePaths) {
            StringBuilder b = new StringBuilder();
            this.addParent(this, b);
            String path = b.toString();
            return thePaths.contains(path);
        }

        private StringBuilder buildPath() {
            if (this.myResDef != null) {
                StringBuilder b = new StringBuilder();
                b.append(this.myResDef.getName());
                return b;
            }
            if (this.myParent != null) {
                StringBuilder b = this.myParent.buildPath();
                if (b != null && this.myDef != null) {
                    b.append('.');
                    b.append(this.myDef.getElementName());
                }
                return b;
            }
            return null;
        }

        private boolean checkIfParentShouldBeEncodedAndBuildPath() {
            boolean retVal;
            List encodeElements = BaseParser.this.myEncodeElements;
            String currentResourceName = this.myEncodeContext.getResourcePath().get(this.myEncodeContext.getResourcePath().size() - 1).getName();
            if (BaseParser.this.myEncodeElementsAppliesToResourceTypes != null && !BaseParser.this.myEncodeElementsAppliesToResourceTypes.contains(currentResourceName)) {
                encodeElements = null;
            }
            if (!(retVal = this.checkIfPathMatchesForEncoding(encodeElements, true))) {
                if ("meta".equals(this.myEncodeContext.getLeafResourcePathFirstField()) && BaseParser.this.shouldAddSubsettedTag(this.myEncodeContext)) {
                    retVal = true;
                } else if ("meta".equals(this.myDef.getElementName()) && BaseParser.this.shouldAddSubsettedTag(this.myEncodeContext)) {
                    retVal = true;
                }
            }
            return retVal;
        }

        private boolean checkIfParentShouldNotBeEncodedAndBuildPath() {
            return this.checkIfPathMatchesForEncoding(BaseParser.this.myDontEncodeElements, false);
        }

        private boolean checkIfPathMatchesForEncoding(List<EncodeContextPath> theElements, boolean theCheckingForEncodeElements) {
            boolean retVal = false;
            if (this.myDef != null) {
                this.myEncodeContext.pushPath(this.myDef.getElementName(), false);
            }
            if (theCheckingForEncodeElements && BaseParser.this.isEncodeElementsAppliesToChildResourcesOnly() && this.myEncodeContext.getResourcePath().size() < 2) {
                retVal = true;
            } else if (theElements == null) {
                retVal = true;
            } else {
                EncodeContextPath currentResourcePath = this.myEncodeContext.getCurrentResourcePath();
                ourLog.trace("Current resource path: {}", (Object)currentResourcePath);
                for (EncodeContextPath next : theElements) {
                    if (next.startsWith(currentResourcePath, true) && (theCheckingForEncodeElements || next.getPath().size() == currentResourcePath.getPath().size())) {
                        retVal = true;
                        break;
                    }
                    if (!next.getPath().get(next.getPath().size() - 1).getName().equals("(mandatory)")) continue;
                    if (this.myDef.getMin() > 0) {
                        retVal = true;
                        break;
                    }
                    if (currentResourcePath.getPath().size() <= next.getPath().size()) continue;
                    retVal = true;
                    break;
                }
            }
            if (this.myDef != null) {
                this.myEncodeContext.popPath();
            }
            return retVal;
        }

        public BaseRuntimeChildDefinition getDef() {
            return this.myDef;
        }

        public CompositeChildElement getParent() {
            return this.myParent;
        }

        public boolean shouldBeEncoded(boolean theContainedResource) {
            String resourceName;
            boolean retVal = true;
            if (BaseParser.this.myEncodeElements != null) {
                retVal = this.checkIfParentShouldBeEncodedAndBuildPath();
            }
            if (retVal && BaseParser.this.myDontEncodeElements != null) {
                boolean bl = retVal = !this.checkIfParentShouldNotBeEncodedAndBuildPath();
            }
            if (theContainedResource) {
                boolean bl = retVal = !notEncodeForContainedResource.contains(this.myDef.getElementName());
            }
            if (!(!retVal || !BaseParser.this.isSummaryMode() || this.getDef() != null && this.getDef().isSummary() || ("Conformance".equals(resourceName = this.myEncodeContext.getLeafResourceName()) || "CapabilityStatement".equals(resourceName)) && ("extension".equals(this.myDef.getElementName()) || "extension".equals(this.myEncodeContext.getLeafElementName())))) {
                retVal = false;
            }
            return retVal;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myDef == null ? 0 : this.myDef.hashCode());
            result = 31 * result + (this.myParent == null ? 0 : this.myParent.hashCode());
            result = 31 * result + (this.myResDef == null ? 0 : this.myResDef.hashCode());
            result = 31 * result + (this.myEncodeContext == null ? 0 : this.myEncodeContext.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CompositeChildElement) {
                CompositeChildElement that = (CompositeChildElement)obj;
                return Objects.equals(this.getEnclosingInstance(), that.getEnclosingInstance()) && Objects.equals(this.myDef, that.myDef) && Objects.equals(this.myParent, that.myParent) && Objects.equals(this.myResDef, that.myResDef) && Objects.equals(this.myEncodeContext, that.myEncodeContext);
            }
            return false;
        }

        private BaseParser getEnclosingInstance() {
            return BaseParser.this;
        }
    }

    class ChildNameAndDef {
        private final BaseRuntimeElementDefinition<?> myChildDef;
        private final String myChildName;

        public ChildNameAndDef(String theChildName, BaseRuntimeElementDefinition<?> theChildDef) {
            this.myChildName = theChildName;
            this.myChildDef = theChildDef;
        }

        public BaseRuntimeElementDefinition<?> getChildDef() {
            return this.myChildDef;
        }

        public String getChildName() {
            return this.myChildName;
        }
    }
}

