/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import ca.uhn.fhir.util.CoverageIgnore;
import java.util.HashMap;
import java.util.Map;

@CoverageIgnore
public enum BundleEntryTransactionMethodEnum {
    GET("GET", "http://hl7.org/fhir/http-verb"),
    POST("POST", "http://hl7.org/fhir/http-verb"),
    PUT("PUT", "http://hl7.org/fhir/http-verb"),
    DELETE("DELETE", "http://hl7.org/fhir/http-verb");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/http-verb";
    public static final String VALUESET_NAME = "BundleEntryStatus";
    private static Map<String, BundleEntryTransactionMethodEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, BundleEntryTransactionMethodEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<BundleEntryTransactionMethodEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public BundleEntryTransactionMethodEnum forCode(String theCode) {
        BundleEntryTransactionMethodEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private BundleEntryTransactionMethodEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, BundleEntryTransactionMethodEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, BundleEntryTransactionMethodEnum>>();
        for (BundleEntryTransactionMethodEnum next : BundleEntryTransactionMethodEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<BundleEntryTransactionMethodEnum>(){
            private static final long serialVersionUID = 7569681479045998433L;

            @Override
            public String toCodeString(BundleEntryTransactionMethodEnum theEnum) {
                return theEnum.getCode();
            }

            @Override
            public String toSystemString(BundleEntryTransactionMethodEnum theEnum) {
                return theEnum.getSystem();
            }

            @Override
            public BundleEntryTransactionMethodEnum fromCodeString(String theCodeString) {
                return (BundleEntryTransactionMethodEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            @Override
            public BundleEntryTransactionMethodEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (BundleEntryTransactionMethodEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

