/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;

public class JdbcUtils {
    public static String safeSqlQueryStringValue(String in) throws Exception {
        if (null == in) {
            return "NULL";
        }
        if (in.indexOf(0) >= 0) {
            throw new Exception("Null character found in string value");
        }
        in = in.replace("'", "''");
        return "'" + in + "'";
    }

    public static String safeSqlQueryIntegerValue(String in) throws Exception {
        int intValue = Integer.parseInt(in);
        return "" + intValue;
    }

    public static String safeSqlQueryIdentifier(String in) throws Exception {
        if (null == in) {
            throw new Exception("Null string passed as identifier");
        }
        if (in.indexOf(0) >= 0) {
            throw new Exception("Null character found in identifier");
        }
        in = in.replace("\"", "\"\"");
        in = "\"" + in + "\"";
        return in;
    }

    public static String extractStringResult(ResultSet rs, ResultSetMetaData rsmd, int index) throws Exception {
        int count = rsmd.getColumnCount();
        if (index > count || index < 1) {
            throw new Exception("Invalid index");
        }
        int type = rsmd.getColumnType(index);
        switch (type) {
            case 1: 
            case 12: {
                return rs.getString(index);
            }
        }
        throw new Exception("Column type (" + type + ") invalid for a string at index: " + index);
    }

    public static int extractIntResult(ResultSet rs, ResultSetMetaData rsmd, int index) throws Exception {
        int count = rsmd.getColumnCount();
        if (index > count || index < 1) {
            throw new Exception("Invalid index");
        }
        int type = rsmd.getColumnType(index);
        switch (type) {
            case 4: 
            case 5: {
                return rs.getInt(index);
            }
        }
        throw new Exception("Column type (" + type + ") invalid for a string at index: " + index);
    }
}

