/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.jdbc;

import ca.carleton.gcrc.jdbc.ConnectionInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class JdbcConnections {
    public static final String JDBC_SERVLET_ATTRIB_NAME = "JdbcConnections";
    public static final String PROPERTIES_SERVLET_ATTRIB_NAME = "JdbcConfigProperties";
    protected final Logger logger = Logger.getLogger(this.getClass());
    private Map<String, ConnectionInfo> nameToInfo = new HashMap<String, ConnectionInfo>();
    private Map<String, Connection> nameToConnection = new HashMap<String, Connection>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JdbcConnections connectionsFromServletContext(ServletContext servletContext) throws ServletException {
        Object jdbcConnectionsObj = servletContext.getAttribute(JDBC_SERVLET_ATTRIB_NAME);
        if (null != jdbcConnectionsObj && jdbcConnectionsObj instanceof JdbcConnections) {
            return (JdbcConnections)jdbcConnectionsObj;
        }
        ServletContext servletContext2 = servletContext;
        synchronized (servletContext2) {
            JdbcConnections connections = new JdbcConnections(servletContext);
            servletContext.setAttribute(JDBC_SERVLET_ATTRIB_NAME, (Object)connections);
            return connections;
        }
    }

    public JdbcConnections(ServletContext servletContext) throws ServletException {
        Object propertiesObj;
        Properties props = new Properties();
        if (null != servletContext && null != (propertiesObj = servletContext.getAttribute(PROPERTIES_SERVLET_ATTRIB_NAME)) && propertiesObj instanceof Properties) {
            props = (Properties)propertiesObj;
        }
        this.readProperties(props);
    }

    public JdbcConnections(Properties props) {
        this.readProperties(props);
    }

    private synchronized void readProperties(Properties props) {
        for (Object keyObj : props.keySet()) {
            String[] components;
            String key;
            String value;
            if (!(keyObj instanceof String) || null == (value = props.getProperty(key = (String)keyObj))) continue;
            String connectionName = null;
            if (key.equals("default")) {
                connectionName = "default";
            } else if (key.startsWith("jdbc.connection.")) {
                connectionName = key.substring("jdbc.connection.".length());
            }
            if (null == connectionName || (components = value.split("\\|")).length < 4) continue;
            ConnectionInfo def = new ConnectionInfo();
            def.setJdbcClass(components[0].trim());
            def.setConnectionString(components[1].trim());
            def.setUserName(components[2].trim());
            def.setPassword(components[3].trim());
            this.nameToInfo.put(connectionName, def);
            this.logger.info((Object)("" + connectionName + " class=" + def.getJdbcClass() + " conn=" + def.getConnectionString() + " name=" + def.getUserName()));
            if (this.nameToInfo.containsKey(null)) continue;
            this.nameToInfo.put(null, def);
        }
    }

    public synchronized Connection getDb() throws Exception {
        return this.getDb(null);
    }

    public synchronized Connection getDb(String db) throws Exception {
        Connection con = null;
        if (this.nameToConnection.containsKey(db)) {
            con = this.nameToConnection.get(db);
        } else {
            ConnectionInfo info = this.nameToInfo.get(db);
            if (null == info) {
                throw new Exception("No information provided for database named: " + db);
            }
            try {
                Class.forName(info.getJdbcClass());
                con = DriverManager.getConnection(info.getConnectionString(), info.getUserName(), info.getPassword());
                DatabaseMetaData dbmd = con.getMetaData();
                this.logger.info((Object)("Connection to " + dbmd.getDatabaseProductName() + " " + dbmd.getDatabaseProductVersion() + " successful.\n"));
                this.nameToConnection.put(db, con);
            }
            catch (Exception e) {
                throw new Exception("Couldn't get db connection: " + db, e);
            }
        }
        return con;
    }

    public synchronized void closeAllConnections() {
        try {
            Map<String, Connection> temp = this.nameToConnection;
            this.nameToConnection = new HashMap<String, Connection>();
            for (Connection con : temp.values()) {
                con.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

