/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;

public class AttributeTable {
    private Hashtable attributes = new Hashtable();

    public AttributeTable(Hashtable hashtable) {
        this.attributes = new Hashtable(hashtable);
    }

    public AttributeTable(DEREncodableVector dEREncodableVector) {
        for (int i = 0; i != dEREncodableVector.size(); ++i) {
            Attribute attribute = Attribute.getInstance(dEREncodableVector.get(i));
            this.attributes.put(attribute.getAttrType(), attribute);
        }
    }

    public AttributeTable(ASN1Set aSN1Set) {
        for (int i = 0; i != aSN1Set.size(); ++i) {
            Attribute attribute = Attribute.getInstance(aSN1Set.getObjectAt(i));
            this.attributes.put(attribute.getAttrType(), attribute);
        }
    }

    public Attribute get(DERObjectIdentifier dERObjectIdentifier) {
        return (Attribute)this.attributes.get(dERObjectIdentifier);
    }

    public Hashtable toHashtable() {
        return new Hashtable(this.attributes);
    }
}

