/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.output.OutputFactory;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;

public class ValueSetOutput<K, V>
extends CommandOutput<K, V, Set<V>> {
    private boolean initialized;

    public ValueSetOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptySet());
    }

    @Override
    public void set(ByteBuffer bytes) {
        ((Set)this.output).add(bytes == null ? null : (Object)this.codec.decodeValue(bytes));
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newSet(count);
            this.initialized = true;
        }
    }
}

