/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.GeoCoordinates;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.output.ListSubscriber;
import com.lambdaworks.redis.output.OutputFactory;
import com.lambdaworks.redis.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GeoCoordinatesListOutput<K, V>
extends CommandOutput<K, V, List<GeoCoordinates>>
implements StreamingOutput<GeoCoordinates> {
    private Double x;
    private boolean initialized;
    private StreamingOutput.Subscriber<GeoCoordinates> subscriber;

    public GeoCoordinatesListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<GeoCoordinates>)ListSubscriber.instance());
    }

    @Override
    public void set(ByteBuffer bytes) {
        Double value = bytes == null ? 0.0 : Double.parseDouble(this.decodeAscii(bytes));
        if (this.x == null) {
            this.x = value;
            return;
        }
        this.subscriber.onNext((Collection)this.output, new GeoCoordinates(this.x, value));
        this.x = null;
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count / 2);
            this.initialized = true;
        }
        if (count == -1) {
            this.subscriber.onNext((Collection)this.output, null);
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<GeoCoordinates> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<GeoCoordinates> getSubscriber() {
        return this.subscriber;
    }
}

