/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.internal.LettuceAssert;
import java.nio.ByteBuffer;

public abstract class CommandOutput<K, V, T> {
    protected final RedisCodec<K, V> codec;
    protected T output;
    protected String error;

    public CommandOutput(RedisCodec<K, V> codec, T output) {
        LettuceAssert.notNull(codec, "RedisCodec must not be null");
        this.codec = codec;
        this.output = output;
    }

    public T get() {
        return this.output;
    }

    public void set(ByteBuffer bytes) {
        throw new IllegalStateException();
    }

    public void set(long integer) {
        throw new IllegalStateException();
    }

    public void setError(ByteBuffer error) {
        this.error = this.decodeAscii(error);
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public String getError() {
        return this.error;
    }

    public void complete(int depth) {
    }

    protected String decodeAscii(ByteBuffer bytes) {
        if (bytes == null) {
            return null;
        }
        char[] chars = new char[bytes.remaining()];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)bytes.get();
        }
        return new String(chars);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [output=").append(this.output);
        sb.append(", error='").append(this.error).append('\'');
        sb.append(']');
        return sb.toString();
    }

    public void multi(int count) {
    }
}

