/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.topology;

import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.topology.Requests;
import com.lambdaworks.redis.cluster.topology.TimedAsyncCommand;
import com.lambdaworks.redis.cluster.topology.TopologyComparators;
import com.lambdaworks.redis.codec.StringCodec;
import com.lambdaworks.redis.output.StatusOutput;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.CommandType;
import java.util.Map;
import java.util.TreeMap;

class Connections {
    private final Map<RedisURI, StatefulRedisConnection<String, String>> connections;

    public Connections() {
        this.connections = new TreeMap<RedisURI, StatefulRedisConnection<String, String>>(TopologyComparators.RedisURIComparator.INSTANCE);
    }

    private Connections(Map<RedisURI, StatefulRedisConnection<String, String>> connections) {
        this.connections = connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(RedisURI redisURI, StatefulRedisConnection<String, String> connection) {
        Map<RedisURI, StatefulRedisConnection<String, String>> map = this.connections;
        synchronized (map) {
            this.connections.put(redisURI, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<RedisURI, StatefulRedisConnection<String, String>> map = this.connections;
        synchronized (map) {
            return this.connections.isEmpty();
        }
    }

    public Requests requestTopology() {
        Requests requests = new Requests();
        for (Map.Entry<RedisURI, StatefulRedisConnection<String, String>> entry : this.connections.entrySet()) {
            CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.UTF8).add(CommandKeyword.NODES);
            Command command = new Command(CommandType.CLUSTER, new StatusOutput<String, String>(StringCodec.UTF8), args);
            TimedAsyncCommand<String, String, String> timedCommand = new TimedAsyncCommand<String, String, String>(command);
            entry.getValue().dispatch(timedCommand);
            requests.addRequest(entry.getKey(), timedCommand);
        }
        return requests;
    }

    public Requests requestClients() {
        Requests requests = new Requests();
        for (Map.Entry<RedisURI, StatefulRedisConnection<String, String>> entry : this.connections.entrySet()) {
            CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.UTF8).add(CommandKeyword.LIST);
            Command command = new Command(CommandType.CLIENT, new StatusOutput<String, String>(StringCodec.UTF8), args);
            TimedAsyncCommand<String, String, String> timedCommand = new TimedAsyncCommand<String, String, String>(command);
            entry.getValue().dispatch(timedCommand);
            requests.addRequest(entry.getKey(), timedCommand);
        }
        return requests;
    }

    public void close() {
        for (StatefulRedisConnection<String, String> connection : this.connections.values()) {
            connection.close();
        }
    }

    public Connections mergeWith(Connections discoveredConnections) {
        TreeMap<RedisURI, StatefulRedisConnection<String, String>> result = new TreeMap<RedisURI, StatefulRedisConnection<String, String>>(TopologyComparators.RedisURIComparator.INSTANCE);
        result.putAll(this.connections);
        result.putAll(discoveredConnections.connections);
        return new Connections(result);
    }
}

