/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.ConnectionFuture;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

class DefaultConnectionFuture<T>
extends CompletableFuture<T>
implements ConnectionFuture<T> {
    private final SocketAddress remoteAddress;
    private final CompletableFuture<T> delegate;

    public DefaultConnectionFuture(SocketAddress remoteAddress, CompletableFuture<T> delegate) {
        this.remoteAddress = remoteAddress;
        this.delegate = delegate;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    private <U> DefaultConnectionFuture<U> adopt(CompletableFuture<U> newFuture) {
        return new DefaultConnectionFuture<U>(this.remoteAddress, newFuture);
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.delegate.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.get(timeout, unit);
    }

    @Override
    public T join() {
        return this.delegate.join();
    }

    @Override
    public T getNow(T valueIfAbsent) {
        return this.delegate.getNow(valueIfAbsent);
    }

    @Override
    public boolean complete(T value) {
        return this.delegate.complete(value);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        return this.delegate.completeExceptionally(ex);
    }

    @Override
    public <U> DefaultConnectionFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return this.adopt((CompletableFuture<U>)this.delegate.thenApply(fn));
    }

    @Override
    public <U> DefaultConnectionFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return this.adopt((CompletableFuture<U>)this.delegate.thenApplyAsync(fn));
    }

    @Override
    public <U> DefaultConnectionFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return this.adopt((CompletableFuture<U>)this.delegate.thenApplyAsync(fn, executor));
    }

    public DefaultConnectionFuture<Void> thenAccept(Consumer<? super T> action) {
        return this.adopt((CompletableFuture)this.delegate.thenAccept((Consumer)action));
    }

    public DefaultConnectionFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return this.adopt((CompletableFuture)this.delegate.thenAcceptAsync((Consumer)action));
    }

    public DefaultConnectionFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return this.adopt((CompletableFuture)this.delegate.thenAcceptAsync((Consumer)action, executor));
    }

    @Override
    public DefaultConnectionFuture<Void> thenRun(Runnable action) {
        return this.adopt((CompletableFuture)this.delegate.thenRun(action));
    }

    @Override
    public DefaultConnectionFuture<Void> thenRunAsync(Runnable action) {
        return this.adopt((CompletableFuture)this.delegate.thenRunAsync(action));
    }

    @Override
    public DefaultConnectionFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.adopt((CompletableFuture)this.delegate.thenRunAsync(action, executor));
    }

    @Override
    public <U, V> DefaultConnectionFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.adopt((CompletableFuture<U>)this.delegate.thenCombine(other, fn));
    }

    @Override
    public <U, V> DefaultConnectionFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.adopt((CompletableFuture<U>)this.delegate.thenCombineAsync(other, fn));
    }

    @Override
    public <U, V> DefaultConnectionFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return this.adopt((CompletableFuture<U>)this.delegate.thenCombineAsync(other, fn, executor));
    }

    public <U> DefaultConnectionFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.adopt((CompletableFuture<U>)this.delegate.thenAcceptBoth(other, (BiConsumer)action));
    }

    public <U> DefaultConnectionFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.adopt((CompletableFuture<U>)this.delegate.thenAcceptBothAsync(other, (BiConsumer)action));
    }

    public <U> DefaultConnectionFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return this.adopt((CompletableFuture<U>)this.delegate.thenAcceptBothAsync(other, (BiConsumer)action, executor));
    }

    public DefaultConnectionFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.adopt((CompletableFuture)this.delegate.runAfterBoth((CompletionStage)other, action));
    }

    public DefaultConnectionFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.adopt((CompletableFuture)this.delegate.runAfterBothAsync((CompletionStage)other, action));
    }

    public DefaultConnectionFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.adopt((CompletableFuture)this.delegate.runAfterBothAsync((CompletionStage)other, action, executor));
    }

    @Override
    public <U> DefaultConnectionFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.adopt((CompletableFuture<U>)this.delegate.applyToEither((CompletionStage)other, fn));
    }

    @Override
    public <U> DefaultConnectionFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.adopt((CompletableFuture<U>)this.delegate.applyToEitherAsync((CompletionStage)other, fn));
    }

    @Override
    public <U> DefaultConnectionFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return this.adopt((CompletableFuture<U>)this.delegate.applyToEitherAsync((CompletionStage)other, fn, executor));
    }

    public DefaultConnectionFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.adopt((CompletableFuture)this.delegate.acceptEither((CompletionStage)other, (Consumer)action));
    }

    public DefaultConnectionFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.adopt((CompletableFuture)this.delegate.acceptEitherAsync((CompletionStage)other, (Consumer)action));
    }

    public DefaultConnectionFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return this.adopt((CompletableFuture)this.delegate.acceptEitherAsync((CompletionStage)other, (Consumer)action, executor));
    }

    public DefaultConnectionFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.adopt((CompletableFuture)this.delegate.runAfterEither((CompletionStage)other, action));
    }

    public DefaultConnectionFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.adopt((CompletableFuture)this.delegate.runAfterEitherAsync((CompletionStage)other, action));
    }

    public DefaultConnectionFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.adopt((CompletableFuture)this.delegate.runAfterEitherAsync((CompletionStage)other, action, executor));
    }

    @Override
    public <U> DefaultConnectionFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.adopt((CompletableFuture<U>)this.delegate.thenCompose(fn));
    }

    @Override
    public <U> DefaultConnectionFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.adopt((CompletableFuture<U>)this.delegate.thenComposeAsync(fn));
    }

    @Override
    public <U> DefaultConnectionFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.adopt((CompletableFuture<U>)this.delegate.thenComposeAsync(fn, executor));
    }

    @Override
    public DefaultConnectionFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return this.adopt((CompletableFuture)this.delegate.whenComplete(action));
    }

    @Override
    public DefaultConnectionFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return this.adopt((CompletableFuture)this.delegate.whenCompleteAsync(action));
    }

    @Override
    public DefaultConnectionFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return this.adopt((CompletableFuture)this.delegate.whenCompleteAsync(action, executor));
    }

    @Override
    public <U> DefaultConnectionFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.adopt((CompletableFuture<U>)this.delegate.handle(fn));
    }

    @Override
    public <U> DefaultConnectionFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.adopt((CompletableFuture<U>)this.delegate.handleAsync(fn));
    }

    @Override
    public <U> DefaultConnectionFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return this.adopt((CompletableFuture<U>)this.delegate.handleAsync(fn, executor));
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this.delegate.toCompletableFuture();
    }

    @Override
    public DefaultConnectionFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return this.adopt((CompletableFuture)this.delegate.exceptionally(fn));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.delegate.isCompletedExceptionally();
    }

    @Override
    public void obtrudeValue(T value) {
        this.delegate.obtrudeValue(value);
    }

    @Override
    public void obtrudeException(Throwable ex) {
        this.delegate.obtrudeException(ex);
    }

    @Override
    public int getNumberOfDependents() {
        return this.delegate.getNumberOfDependents();
    }
}

