/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisConnectionStateListener;
import com.lambdaworks.redis.protocol.RedisCommand;
import io.netty.util.internal.ConcurrentSet;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class ConnectionEvents {
    private final Set<RedisConnectionStateListener> listeners = new ConcurrentSet();

    void fireEventRedisConnected(RedisChannelHandler<?, ?> connection, SocketAddress socketAddress) {
        for (RedisConnectionStateListener listener : this.listeners) {
            listener.onRedisConnected(connection, socketAddress);
        }
    }

    void fireEventRedisDisconnected(RedisChannelHandler<?, ?> connection) {
        for (RedisConnectionStateListener listener : this.listeners) {
            listener.onRedisDisconnected(connection);
        }
    }

    void fireEventRedisExceptionCaught(RedisChannelHandler<?, ?> connection, Throwable cause) {
        for (RedisConnectionStateListener listener : this.listeners) {
            listener.onRedisExceptionCaught(connection, cause);
        }
    }

    public void addListener(RedisConnectionStateListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RedisConnectionStateListener listener) {
        this.listeners.remove(listener);
    }

    public static class Reconnect {
        private final int attempt;

        public Reconnect(int attempt) {
            this.attempt = attempt;
        }

        public int getAttempt() {
            return this.attempt;
        }
    }

    public static class PingBeforeActivate {
        private final RedisCommand<?, ?, ?> command;

        public PingBeforeActivate(RedisCommand<?, ?, ?> command) {
            this.command = command;
        }

        public RedisCommand<?, ?, ?> getCommand() {
            return this.command;
        }
    }

    public static class Activated {
    }

    public static class Close {
    }

    public static class PrepareClose {
        private CompletableFuture<Boolean> prepareCloseFuture = new CompletableFuture();

        public CompletableFuture<Boolean> getPrepareCloseFuture() {
            return this.prepareCloseFuture;
        }
    }
}

