/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.log4j;

import biz.paluch.logging.gelf.DynamicMdcMessageField;
import biz.paluch.logging.gelf.GelfUtil;
import biz.paluch.logging.gelf.LogEvent;
import biz.paluch.logging.gelf.LogMessageField;
import biz.paluch.logging.gelf.MdcMessageField;
import biz.paluch.logging.gelf.MessageField;
import biz.paluch.logging.gelf.Values;
import biz.paluch.logging.gelf.log4j.Log4jVersionChecker;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.MDC;
import org.apache.log4j.NDC;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

class Log4jLogEvent
implements LogEvent {
    private LoggingEvent loggingEvent;

    public Log4jLogEvent(LoggingEvent loggingEvent) {
        this.loggingEvent = loggingEvent;
    }

    @Override
    public String getMessage() {
        return this.loggingEvent.getRenderedMessage();
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public Throwable getThrowable() {
        ThrowableInformation ti = this.loggingEvent.getThrowableInformation();
        if (ti != null) {
            return ti.getThrowable();
        }
        return null;
    }

    @Override
    public long getLogTimestamp() {
        return Log4jVersionChecker.getTimeStamp(this.loggingEvent);
    }

    @Override
    public String getSyslogLevel() {
        return "" + this.levelToSyslogLevel(this.loggingEvent.getLevel());
    }

    private int levelToSyslogLevel(Level level) {
        if (level.toInt() <= Level.DEBUG.toInt()) {
            return 7;
        }
        if (level.toInt() <= Level.INFO.toInt()) {
            return 6;
        }
        if (level.toInt() <= Level.WARN.toInt()) {
            return 4;
        }
        if (level.toInt() <= Level.ERROR.toInt()) {
            return 3;
        }
        if (level.toInt() <= Level.FATAL.toInt()) {
            return 2;
        }
        if (level.toInt() > Level.FATAL.toInt()) {
            return 0;
        }
        return 7;
    }

    @Override
    public Values getValues(MessageField field) {
        if (field instanceof LogMessageField) {
            return new Values(field.getName(), this.getValue((LogMessageField)field));
        }
        if (field instanceof MdcMessageField) {
            return new Values(field.getName(), this.getValue((MdcMessageField)field));
        }
        if (field instanceof DynamicMdcMessageField) {
            return this.getMdcValues((DynamicMdcMessageField)field);
        }
        throw new UnsupportedOperationException("Cannot provide value for " + field);
    }

    public String getValue(LogMessageField field) {
        switch (field.getNamedLogField()) {
            case Severity: {
                return this.loggingEvent.getLevel().toString();
            }
            case ThreadName: {
                return this.loggingEvent.getThreadName();
            }
            case SourceClassName: {
                return this.getSourceClassName();
            }
            case SourceLineNumber: {
                return this.getSourceLineNumber();
            }
            case SourceMethodName: {
                return this.getSourceMethodName();
            }
            case SourceSimpleClassName: {
                String sourceClassName = this.getSourceClassName();
                if (sourceClassName == null) {
                    return null;
                }
                return GelfUtil.getSimpleClassName(sourceClassName);
            }
            case LoggerName: {
                return this.loggingEvent.getLoggerName();
            }
            case NDC: {
                String ndc = NDC.get();
                if (ndc != null && !"".equals(ndc)) {
                    return ndc;
                }
                return null;
            }
        }
        throw new UnsupportedOperationException("Cannot provide value for " + field);
    }

    private String getSourceMethodName() {
        String methodName = this.loggingEvent.getLocationInformation().getMethodName();
        if ("?".equals(methodName)) {
            return null;
        }
        return methodName;
    }

    private String getSourceLineNumber() {
        String lineNumber = this.loggingEvent.getLocationInformation().getLineNumber();
        if ("?".equals(lineNumber)) {
            return null;
        }
        return lineNumber;
    }

    private String getSourceClassName() {
        String className = this.loggingEvent.getLocationInformation().getClassName();
        if ("?".equals(className)) {
            return null;
        }
        return className;
    }

    private String getValue(MdcMessageField field) {
        return this.getMdcValue(field.getMdcName());
    }

    @Override
    public String getMdcValue(String mdcName) {
        Object value = MDC.get((String)mdcName);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    private Values getMdcValues(DynamicMdcMessageField field) {
        Values result = new Values();
        Set<String> mdcNames = this.getAllMdcNames();
        Set<String> matchingMdcNames = this.getMatchingMdcNames(field, mdcNames);
        for (String mdcName : matchingMdcNames) {
            String mdcValue = this.getMdcValue(mdcName);
            if (mdcName == null) continue;
            result.setValue(mdcName, mdcValue);
        }
        return result;
    }

    private Set<String> getAllMdcNames() {
        HashSet<String> mdcNames = new HashSet<String>();
        Hashtable context = MDC.getContext();
        if (context != null) {
            mdcNames.addAll(context.keySet());
        }
        return mdcNames;
    }

    private Set<String> getMatchingMdcNames(DynamicMdcMessageField field, Set<String> mdcNames) {
        HashSet<String> matchingMdcNames = new HashSet<String>();
        for (String mdcName : mdcNames) {
            if (!field.getPattern().matcher(mdcName).matches()) continue;
            matchingMdcNames.add(mdcName);
        }
        return matchingMdcNames;
    }

    @Override
    public Set<String> getMdcNames() {
        return this.getAllMdcNames();
    }
}

