/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern;

import biz.paluch.logging.gelf.intern.Charsets;
import biz.paluch.logging.gelf.intern.Closer;
import biz.paluch.logging.gelf.intern.JsonWriter;
import biz.paluch.logging.gelf.intern.OutputAccessor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class GelfMessage {
    public static final String FIELD_HOST = "host";
    public static final String FIELD_SHORT_MESSAGE = "short_message";
    public static final String FIELD_FULL_MESSAGE = "full_message";
    public static final String FIELD_TIMESTAMP = "timestamp";
    public static final String FIELD_LEVEL = "level";
    public static final String FIELD_FACILITY = "facility";
    public static final String ID_NAME = "id";
    public static final String FIELD_TYPE_DISCOVER = "discover";
    public static final String FIELD_TYPE_STRING = "String";
    public static final String FIELD_TYPE_LONG = "long";
    public static final String FIELD_TYPE_LONG2 = "Long";
    public static final String FIELD_TYPE_DOUBLE = "double";
    public static final String FIELD_TYPE_DOUBLE2 = "Double";
    public static final String FIELD_TYPE_DEFAULT = "discover";
    public static final String GELF_VERSION_1_0 = "1.0";
    public static final String GELF_VERSION_1_1 = "1.1";
    public static final String GELF_VERSION = "1.0";
    public static final String DEFAULT_FACILITY = "logstash-gelf";
    public static final int DEFAULT_MESSAGE_SIZE = 8192;
    public static final int DEFAUL_LEVEL = 7;
    private static final byte[] GELF_CHUNKED_ID = new byte[]{30, 15};
    private static final BigDecimal TIME_DIVISOR = new BigDecimal(1000);
    private static final byte[] NONE = GelfMessage.lastFourAsciiBytes("none");
    private String version = "1.0";
    private String host;
    private byte[] hostBytes = NONE;
    private String shortMessage;
    private String fullMessage;
    private long javaTimestamp;
    private String level;
    private String facility = "logstash-gelf";
    private Map<String, String> additonalFields = new HashMap<String, String>();
    private Map<String, String> additionalFieldTypes = new HashMap<String, String>();
    private int maximumMessageSize = 8192;

    public GelfMessage() {
    }

    public GelfMessage(String shortMessage, String fullMessage, long timestamp, String level) {
        this.shortMessage = shortMessage;
        this.fullMessage = fullMessage;
        this.javaTimestamp = timestamp;
        this.level = level;
    }

    public String toJson() {
        return this.toJson("_");
    }

    public String toJson(String additionalFieldPrefix) {
        return new String(this.toJsonByteArray(additionalFieldPrefix), Charsets.UTF8);
    }

    private byte[] toJsonByteArray(String additionalFieldPrefix) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.toJson(OutputAccessor.from(buffer), additionalFieldPrefix);
        return buffer.toByteArray();
    }

    public void toJson(ByteBuffer byteBuffer, String additionalFieldPrefix) {
        this.toJson(OutputAccessor.from(byteBuffer), additionalFieldPrefix);
    }

    protected void toJson(OutputAccessor out, String additionalFieldPrefix) {
        JsonWriter.writeObjectStart(out);
        boolean hasFields = GelfMessage.writeIfNotEmpty(out, false, FIELD_HOST, this.getHost());
        if (!GelfMessage.isEmpty(this.shortMessage)) {
            hasFields = GelfMessage.writeIfNotEmpty(out, hasFields, FIELD_SHORT_MESSAGE, this.getShortMessage());
        }
        hasFields = GelfMessage.writeIfNotEmpty(out, hasFields, FIELD_FULL_MESSAGE, this.getFullMessage());
        if (this.getJavaTimestamp() != 0L) {
            hasFields = GELF_VERSION_1_1.equals(this.version) ? GelfMessage.writeIfNotEmpty(out, hasFields, FIELD_TIMESTAMP, this.getTimestampAsBigDecimal().doubleValue()) : GelfMessage.writeIfNotEmpty(out, hasFields, FIELD_TIMESTAMP, this.getTimestampAsBigDecimal().toString());
        }
        if (!GelfMessage.isEmpty(this.getLevel())) {
            if (GELF_VERSION_1_1.equals(this.version)) {
                int level;
                try {
                    level = Integer.parseInt(this.getLevel());
                }
                catch (NumberFormatException ex) {
                    level = 7;
                }
                hasFields = GelfMessage.writeIfNotEmpty(out, hasFields, FIELD_LEVEL, level);
            } else {
                hasFields = GelfMessage.writeIfNotEmpty(out, hasFields, FIELD_LEVEL, this.getLevel());
            }
        }
        if (!GelfMessage.isEmpty(this.getFacility())) {
            hasFields = GelfMessage.writeIfNotEmpty(out, hasFields, FIELD_FACILITY, this.getFacility());
        }
        for (Map.Entry<String, String> additionalField : this.additonalFields.entrySet()) {
            Object result;
            if (ID_NAME.equals(additionalField.getKey()) || additionalField.getValue() == null) continue;
            String value = additionalField.getValue();
            String fieldType = this.additionalFieldTypes.get(additionalField.getKey());
            if (fieldType == null) {
                fieldType = "discover";
            }
            if ((result = this.getAdditionalFieldValue(value, fieldType)) == null) continue;
            hasFields = GelfMessage.writeIfNotEmpty(out, hasFields, additionalFieldPrefix + additionalField.getKey(), result);
        }
        JsonWriter.writeObjectEnd(out);
    }

    private static boolean writeIfNotEmpty(OutputAccessor out, boolean hasFields, String field, Object value) {
        if (value == null) {
            return hasFields;
        }
        if (value instanceof String) {
            if (GelfMessage.isEmpty((String)value)) {
                return hasFields;
            }
            if (hasFields) {
                JsonWriter.writeKeyValueSeparator(out);
            }
            JsonWriter.writeMapEntry(out, field, value);
            return true;
        }
        if (hasFields) {
            JsonWriter.writeKeyValueSeparator(out);
        }
        JsonWriter.writeMapEntry(out, field, value);
        return true;
    }

    private Object getAdditionalFieldValue(String value, String fieldType) {
        Object result;
        block13: {
            block12: {
                result = null;
                if (fieldType.equalsIgnoreCase("discover")) {
                    try {
                        try {
                            result = Long.parseLong(value);
                        }
                        catch (NumberFormatException ex) {
                            result = Double.parseDouble(value);
                        }
                    }
                    catch (NumberFormatException ex) {
                        result = value;
                    }
                }
                if (fieldType.equalsIgnoreCase(FIELD_TYPE_STRING)) {
                    result = value;
                }
                if (fieldType.equals(FIELD_TYPE_DOUBLE) || fieldType.equalsIgnoreCase(FIELD_TYPE_DOUBLE2)) {
                    try {
                        result = Double.parseDouble(value);
                    }
                    catch (NumberFormatException ex) {
                        if (!fieldType.equals(FIELD_TYPE_DOUBLE)) break block12;
                        result = 0.0;
                    }
                }
            }
            if (fieldType.equals(FIELD_TYPE_LONG) || fieldType.equalsIgnoreCase(FIELD_TYPE_LONG2)) {
                try {
                    result = (long)Double.parseDouble(value);
                }
                catch (NumberFormatException ex) {
                    if (!fieldType.equals(FIELD_TYPE_LONG)) break block13;
                    result = 0L;
                }
            }
        }
        return result;
    }

    public ByteBuffer[] toUDPBuffers() {
        byte[] messageBytes = this.gzipMessage(this.toJsonByteArray("_"));
        if (messageBytes.length > this.maximumMessageSize) {
            int datagrams_length = messageBytes.length / this.maximumMessageSize;
            if (messageBytes.length % this.maximumMessageSize != 0) {
                ++datagrams_length;
            }
            ByteBuffer targetBuffer = ByteBuffer.allocate(messageBytes.length + datagrams_length * 12);
            return this.sliceDatagrams(ByteBuffer.wrap(messageBytes), datagrams_length, targetBuffer);
        }
        ByteBuffer[] datagrams = new ByteBuffer[]{ByteBuffer.allocate(messageBytes.length)};
        datagrams[0].put(messageBytes);
        datagrams[0].flip();
        return datagrams;
    }

    public ByteBuffer[] toUDPBuffers(ByteBuffer buffer, ByteBuffer tempBuffer) {
        tempBuffer.put(this.gzipMessage(this.toJsonByteArray("_")));
        if (tempBuffer.position() > this.maximumMessageSize) {
            int diagrams_length = tempBuffer.position() / this.maximumMessageSize;
            if (tempBuffer.position() % this.maximumMessageSize != 0) {
                ++diagrams_length;
            }
            buffer.clear();
            return this.sliceDatagrams((ByteBuffer)tempBuffer.flip(), diagrams_length, buffer);
        }
        return new ByteBuffer[]{(ByteBuffer)tempBuffer.flip()};
    }

    public ByteBuffer toTCPBuffer() {
        byte[] messageBytes = this.toJsonByteArray("_");
        ByteBuffer buffer = ByteBuffer.allocate(messageBytes.length + 1);
        buffer.put(messageBytes);
        buffer.put((byte)0);
        buffer.flip();
        return buffer;
    }

    public ByteBuffer toTCPBuffer(ByteBuffer buffer) {
        this.toJson(buffer, "_");
        buffer.put((byte)0);
        buffer.flip();
        return buffer;
    }

    protected ByteBuffer[] sliceDatagrams(ByteBuffer source, int datagrams, ByteBuffer target) {
        int messageLength = source.limit();
        int millis = this.getCurrentMillis();
        ByteBuffer[] slices = new ByteBuffer[datagrams];
        for (int idx = 0; idx < datagrams; ++idx) {
            int start = target.position();
            target.put(GELF_CHUNKED_ID).putInt(millis).put(this.hostBytes).put((byte)idx).put((byte)datagrams);
            int from = idx * this.maximumMessageSize;
            int to = from + this.maximumMessageSize;
            if (to >= messageLength) {
                to = messageLength;
            }
            ByteBuffer duplicate = (ByteBuffer)source.duplicate().limit(to).position(from);
            target.put(duplicate);
            int end = target.position();
            slices[idx] = (ByteBuffer)target.duplicate().limit(end).position(start);
        }
        return slices;
    }

    public int getCurrentMillis() {
        return (int)System.currentTimeMillis();
    }

    private byte[] gzipMessage(byte[] message) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream stream = new GZIPOutputStream(bos);
            stream.write(message);
            stream.finish();
            Closer.close(stream);
            byte[] zipped = bos.toByteArray();
            Closer.close(bos);
            return zipped;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static byte[] lastFourAsciiBytes(String host) {
        String shortHost = host.length() >= 4 ? host.substring(host.length() - 4) : host;
        return Charsets.ascii(shortHost);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        if (host != null) {
            this.hostBytes = GelfMessage.lastFourAsciiBytes(host);
        }
    }

    public String getShortMessage() {
        return !GelfMessage.isEmpty(this.shortMessage) ? this.shortMessage : "<empty>";
    }

    public void setShortMessage(String shortMessage) {
        this.shortMessage = shortMessage;
    }

    public String getFullMessage() {
        return this.fullMessage;
    }

    public void setFullMessage(String fullMessage) {
        this.fullMessage = fullMessage;
    }

    public BigDecimal getTimestampAsBigDecimal() {
        return new BigDecimal(this.javaTimestamp).divide(TIME_DIVISOR);
    }

    public String getTimestamp() {
        return this.getTimestampAsBigDecimal().toPlainString();
    }

    public Long getJavaTimestamp() {
        return this.javaTimestamp;
    }

    public void setJavaTimestamp(long javaTimestamp) {
        this.javaTimestamp = javaTimestamp;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public Map<String, String> getAdditionalFieldTypes() {
        return this.additionalFieldTypes;
    }

    public void setAdditionalFieldTypes(Map<String, String> additionalFieldTypes) {
        this.additionalFieldTypes.putAll(additionalFieldTypes);
    }

    public GelfMessage addFields(Map<String, String> fields) {
        if (fields == null) {
            throw new IllegalArgumentException("fields is null");
        }
        this.getAdditonalFields().putAll(fields);
        return this;
    }

    public GelfMessage addField(String key, String value) {
        this.getAdditonalFields().put(key, value);
        return this;
    }

    public Map<String, String> getAdditonalFields() {
        return this.additonalFields;
    }

    public boolean isValid() {
        return this.isShortOrFullMessagesExists() && !GelfMessage.isEmpty(this.version) && !GelfMessage.isEmpty(this.host);
    }

    private boolean isShortOrFullMessagesExists() {
        return !GelfMessage.isEmpty(this.shortMessage) || !GelfMessage.isEmpty(this.fullMessage);
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    public int getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    public void setMaximumMessageSize(int maximumMessageSize) {
        this.maximumMessageSize = maximumMessageSize;
    }

    public String getField(String fieldName) {
        return this.getAdditonalFields().get(fieldName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GelfMessage)) {
            return false;
        }
        GelfMessage that = (GelfMessage)o;
        if (this.javaTimestamp != that.javaTimestamp) {
            return false;
        }
        if (this.maximumMessageSize != that.maximumMessageSize) {
            return false;
        }
        if (this.additonalFields != null ? !this.additonalFields.equals(that.additonalFields) : that.additonalFields != null) {
            return false;
        }
        if (this.facility != null ? !this.facility.equals(that.facility) : that.facility != null) {
            return false;
        }
        if (this.fullMessage != null ? !this.fullMessage.equals(that.fullMessage) : that.fullMessage != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (!Arrays.equals(this.hostBytes, that.hostBytes)) {
            return false;
        }
        if (this.level != null ? !this.level.equals(that.level) : that.level != null) {
            return false;
        }
        if (this.shortMessage != null ? !this.shortMessage.equals(that.shortMessage) : that.shortMessage != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.version != null ? this.version.hashCode() : 0;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + (this.hostBytes != null ? Arrays.hashCode(this.hostBytes) : 0);
        result = 31 * result + (this.shortMessage != null ? this.shortMessage.hashCode() : 0);
        result = 31 * result + (this.fullMessage != null ? this.fullMessage.hashCode() : 0);
        result = 31 * result + (int)(this.javaTimestamp ^ this.javaTimestamp >>> 32);
        result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
        result = 31 * result + (this.facility != null ? this.facility.hashCode() : 0);
        result = 31 * result + (this.additonalFields != null ? this.additonalFields.hashCode() : 0);
        result = 31 * result + this.maximumMessageSize;
        return result;
    }
}

