/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public class LineSeparatorBufferedReader
extends BufferedReader {
    private int markedPushBack = -1;
    private int pushBack = -1;
    private int markedEol;
    private int eol;

    public LineSeparatorBufferedReader(Reader in) {
        super(in);
    }

    public LineSeparatorBufferedReader(Reader in, int size) {
        super(in, size);
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        super.mark(readAheadLimit);
        this.markedPushBack = this.pushBack;
        this.markedEol = this.eol;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.pushBack = this.markedPushBack;
        this.eol = this.markedEol;
    }

    @Override
    public int read() throws IOException {
        this.lineSeparator();
        return this.read0();
    }

    private int read0() throws IOException {
        int c = this.pushBack;
        if (c != -1) {
            this.pushBack = -1;
            return c;
        }
        return super.read();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.lineSeparator();
        int c = this.pushBack;
        if (c != -1 && off >= 0 && off < cbuf.length && len > 0) {
            this.pushBack = -1;
            cbuf[off] = (char)c;
            return 1;
        }
        return super.read(cbuf, off, len);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        this.lineSeparator();
        int c = this.pushBack;
        if (c != -1 && target.remaining() > 0) {
            this.pushBack = -1;
            target.put((char)c);
            return 1;
        }
        return super.read(target);
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String readLine() throws IOException {
        int c = this.read0();
        if (c == -1) {
            this.eol = 0;
            return null;
        }
        StringBuilder sb = new StringBuilder(80);
        while (true) {
            if (c == -1) {
                this.eol = 0;
                return sb.toString();
            }
            if (c == 10) {
                if (this.eol != 13) {
                    this.eol = c;
                    return sb.toString();
                }
                this.eol = 0;
            } else {
                if (c == 13) {
                    this.eol = c;
                    return sb.toString();
                }
                sb.append((char)c);
            }
            c = this.read0();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        this.lineSeparator();
        if (this.pushBack != -1 && n > 0L) {
            this.pushBack = -1;
            return super.skip(n - 1L) + 1L;
        }
        return super.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        return this.pushBack != -1 || super.ready();
    }

    public String lineSeparator() throws IOException {
        int e = this.eol;
        if (e == 10) {
            this.eol = 0;
            return "\n";
        }
        if (e == 13) {
            this.eol = 0;
            int c = this.read0();
            if (c != 10) {
                this.pushBack = c;
                return "\r";
            }
            return "\r\n";
        }
        return "";
    }
}

