/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.servlets.datasource;

import be.orbinson.aem.dictionarytranslator.services.DictionaryService;
import be.orbinson.aem.dictionarytranslator.services.impl.DictionaryImpl;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import java.io.IOException;
import java.text.Collator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.iterators.TransformIterator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"aem-dictionary-translator/datasource/dictionary-language"}, methods={"GET"})
public class LanguageDatasource
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LanguageDatasource.class);
    @Reference
    transient DictionaryService dictionaryService;

    public static Map<Locale, String> getAllAvailableLanguages(SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        options.setForceResourceType("cq/gui/components/common/datasources/languages");
        request.getRequestDispatcher(request.getResource(), options).include((ServletRequest)request, (ServletResponse)response);
        DataSource dataSource = (DataSource)request.getAttribute(DataSource.class.getName());
        List resources = IteratorUtils.toList((Iterator)new TransformIterator(dataSource.iterator(), r -> ValueTextResource.fromResource(request.getLocale(), r)));
        return LanguageDatasource.toLanguageMap(resources);
    }

    private static Map<Locale, String> toLanguageMap(List<ValueTextResource> resources) {
        return resources.stream().filter(r -> !"rep:policy".equals(r.getValue())).collect(Collectors.toMap(r -> DictionaryImpl.toLocale(r.getValue()), r -> r.getText() + " (" + r.getValue() + ")", (oldValue, newValue) -> {
            LOG.warn("Duplicate language/country code: {}", oldValue);
            return oldValue;
        }));
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        Predicate<Locale> languageFilter;
        String dictionaryPath = request.getRequestPathInfo().getSuffix();
        Map<Locale, String> languageMap = LanguageDatasource.getAllAvailableLanguages(request, response);
        Set<Locale> dictionaryLanguages = this.dictionaryService.getDictionaries(request.getResourceResolver(), dictionaryPath).stream().map(d -> d.getLanguage()).collect(Collectors.toSet());
        Config dsCfg = new Config(request.getResource().getChild("datasource"));
        if (((Boolean)dsCfg.get("hideNonDictionaryLanguages", (Object)false)).booleanValue()) {
            languageFilter = dictionaryLanguages::contains;
            dictionaryLanguages.forEach(l -> languageMap.putIfAbsent((Locale)l, l.toLanguageTag()));
        } else {
            languageFilter = l -> !dictionaryLanguages.contains(l);
        }
        boolean emitTextFieldResources = (Boolean)dsCfg.get("emitTextFieldResources", (Object)false);
        List resourceList = languageMap.entrySet().stream().filter(e -> languageFilter.test((Locale)e.getKey())).map(e -> {
            if (emitTextFieldResources) {
                return TextFieldResource.create(request.getLocale(), request.getResourceResolver(), ((Locale)e.getKey()).toLanguageTag(), (String)e.getValue());
            }
            return ValueTextResource.create(request.getLocale(), request.getResourceResolver(), ((Locale)e.getKey()).toLanguageTag(), (String)e.getValue());
        }).sorted().collect(Collectors.toList());
        SimpleDataSource dataSource = new SimpleDataSource((Iterator)new TransformIterator(resourceList.iterator(), r -> r));
        request.setAttribute(DataSource.class.getName(), (Object)dataSource);
    }

    private static class ValueTextResource
    extends OrderedValueMapResource {
        private ValueTextResource(Locale locale, ResourceResolver resolver, ValueMap valueMap) {
            super(locale, resolver, "nt:unstructured", valueMap);
        }

        public static ValueTextResource fromResource(Locale locale, Resource resource) {
            return new ValueTextResource(locale, resource.getResourceResolver(), resource.getValueMap());
        }

        public static ValueTextResource create(Locale locale, ResourceResolver resolver, String value, String text) {
            ValueMapDecorator valueMap = new ValueMapDecorator(Map.of("value", value, "text", text));
            return new ValueTextResource(locale, resolver, (ValueMap)valueMap);
        }

        public String getText() {
            return (String)this.getValueMap().get("text", String.class);
        }

        public String getValue() {
            return (String)this.getValueMap().get("value", String.class);
        }

        @Override
        String getLabel() {
            return this.getText();
        }
    }

    private static class TextFieldResource
    extends OrderedValueMapResource {
        private TextFieldResource(Locale locale, ResourceResolver resolver, ValueMap valueMap) {
            super(locale, resolver, "granite/ui/components/coral/foundation/form/textfield", valueMap);
        }

        public static TextFieldResource create(Locale locale, ResourceResolver resolver, String value, String text) {
            ValueMapDecorator valueMap = new ValueMapDecorator(Map.of("fieldLabel", text, "name", value));
            return new TextFieldResource(locale, resolver, (ValueMap)valueMap);
        }

        @Override
        String getLabel() {
            return (String)this.getValueMap().get("fieldLabel", String.class);
        }
    }

    private static abstract class OrderedValueMapResource
    extends ValueMapResource
    implements Comparable<OrderedValueMapResource> {
        private final Collator collator;

        protected OrderedValueMapResource(Locale locale, ResourceResolver resourceResolver, String resourceType, ValueMap vm) {
            super(resourceResolver, "", resourceType, vm);
            this.collator = Collator.getInstance(locale);
        }

        abstract String getLabel();

        @Override
        public int compareTo(OrderedValueMapResource o) {
            return this.collator.compare(this.getLabel(), o.getLabel());
        }

        public boolean equals(Object obj) {
            return obj instanceof OrderedValueMapResource && this.collator.equals(((OrderedValueMapResource)obj).collator);
        }
    }
}

