/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.servlets.datasource;

import be.orbinson.aem.dictionarytranslator.services.impl.CombiningMessageEntryResourceProvider;
import be.orbinson.aem.dictionarytranslator.servlets.datasource.LanguageDatasource;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.EmptyDataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import com.day.cq.i18n.I18n;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"aem-dictionary-translator/datasource/combining-message-entry-for-dialog"}, methods={"GET"})
public class CombiningMessageEntryDatasourceForDialog
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    public static final String FIELD_LABEL = "fieldLabel";
    private static final Logger LOG = LoggerFactory.getLogger(CombiningMessageEntryDatasourceForDialog.class);

    private static Resource createTextFieldResource(ResourceResolver resourceResolver, String label, String name, String value) {
        return CombiningMessageEntryDatasourceForDialog.createTextFieldResource(resourceResolver, label, name, value, false, false);
    }

    private static Resource createTextFieldResource(ResourceResolver resourceResolver, String label, String name, String value, boolean required, boolean disabled) {
        return CombiningMessageEntryDatasourceForDialog.createTextFieldResource(resourceResolver, "", label, name, value, required, disabled);
    }

    private static Resource createTextFieldResource(ResourceResolver resourceResolver, String path, String label, String name, String value, boolean required, boolean disabled) {
        ValueMapDecorator valueMap = new ValueMapDecorator(Map.of(FIELD_LABEL, label, "name", name, "value", value, "disabled", disabled, "required", required));
        return new ValueMapResource(resourceResolver, path, "granite/ui/components/coral/foundation/form/textfield", (ValueMap)valueMap);
    }

    private static Resource createHiddenFieldResource(ResourceResolver resourceResolver, String key, String value) {
        ValueMapDecorator valueMap = new ValueMapDecorator(Map.of(FIELD_LABEL, key, "name", key, "value", value));
        return new ValueMapResource(resourceResolver, "", "granite/ui/components/coral/foundation/form/hidden", (ValueMap)valueMap);
    }

    private static Resource createAlertResource(ResourceResolver resourceResolver, String path, String title, String text, String variant) {
        ValueMapDecorator valueMap = new ValueMapDecorator(Map.of("jcr:title", title, "text", text, "variant", variant));
        return new ValueMapResource(resourceResolver, path, "granite/ui/components/coral/foundation/alert", (ValueMap)valueMap);
    }

    private static Resource createFieldSetResource(ResourceResolver resourceResolver, String path, Collection<Resource> childResources) {
        ValueMapResource items = new ValueMapResource(resourceResolver, path + "/items", "nt:unstructured", null, childResources);
        return new ValueMapResource(resourceResolver, path, "granite/ui/components/coral/foundation/form/fieldset", null, Collections.singleton(items));
    }

    private static Resource addValidationMessagesResource(I18n i18n, ResourceResolver resourceResolver, Map<Locale, String> languageMap, CombiningMessageEntryResourceProvider.ValidationMessage ... validationMessages) {
        if (validationMessages == null || validationMessages.length == 0) {
            return null;
        }
        ArrayList<Resource> validationResources = new ArrayList<Resource>();
        int index = 0;
        String fieldSetPath = "/dialog/validation";
        for (CombiningMessageEntryResourceProvider.ValidationMessage validationMessage : validationMessages) {
            String textFieldPath = fieldSetPath + "/items/item" + index++;
            String label = i18n.get("Language") + " " + languageMap.getOrDefault(validationMessage.getLanguage(), validationMessage.getLanguage().toLanguageTag());
            String text = i18n.get(validationMessage.getI18nKey(), null, (Object[])validationMessage.getArguments());
            validationResources.add(CombiningMessageEntryDatasourceForDialog.createAlertResource(resourceResolver, textFieldPath, label, text, validationMessage.getSeverity().name().toLowerCase(Locale.ENGLISH)));
        }
        return CombiningMessageEntryDatasourceForDialog.createFieldSetResource(resourceResolver, fieldSetPath, validationResources);
    }

    private static void sortResourcesByProperty(String propertyName, Locale locale, List<Resource> resources) {
        Collator collator = Collator.getInstance(locale);
        resources.sort((o1, o2) -> {
            ValueMap properties1 = o1.getValueMap();
            ValueMap properties2 = o2.getValueMap();
            return collator.compare((String)properties1.get(propertyName, (Object)""), (String)properties2.get(propertyName, (Object)""));
        });
    }

    private static void createCombiningMessageEntryDataSource(I18n i18n, Locale locale, Map<Locale, String> languageMap, ResourceResolver resourceResolver, String combiningMessageEntryPath, List<Resource> resourceList) {
        Resource combiningMessageEntryResource = resourceResolver.getResource(combiningMessageEntryPath);
        if (combiningMessageEntryResource != null) {
            ValueMap properties = combiningMessageEntryResource.getValueMap();
            Locale[] languages = (Locale[])properties.get("languages", Locale[].class);
            String key = (String)properties.get("key", String.class);
            if (languages != null) {
                for (Locale language : languages) {
                    String message = (String)properties.get(language.toLanguageTag(), (Object)"");
                    String label = languageMap.getOrDefault(language, language.toLanguageTag());
                    resourceList.add(CombiningMessageEntryDatasourceForDialog.createTextFieldResource(resourceResolver, label, language.toLanguageTag(), message));
                }
                CombiningMessageEntryDatasourceForDialog.sortResourcesByProperty(FIELD_LABEL, locale, resourceList);
            }
            resourceList.add(0, CombiningMessageEntryDatasourceForDialog.createTextFieldResource(resourceResolver, "Key", key, key, false, true));
            resourceList.add(1, CombiningMessageEntryDatasourceForDialog.createHiddenFieldResource(resourceResolver, "key", key));
            Resource validationContainer = CombiningMessageEntryDatasourceForDialog.addValidationMessagesResource(i18n, resourceResolver, languageMap, (CombiningMessageEntryResourceProvider.ValidationMessage[])properties.get("validationMessages", CombiningMessageEntryResourceProvider.ValidationMessage[].class));
            if (validationContainer != null) {
                resourceList.add(0, validationContainer);
            }
        }
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        DataSource dataSource;
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        ResourceResolver resourceResolver = request.getResourceResolver();
        String combiningMessageEntryPath = request.getParameter("item");
        if (combiningMessageEntryPath != null) {
            CombiningMessageEntryDatasourceForDialog.createCombiningMessageEntryDataSource(new I18n((HttpServletRequest)request), request.getLocale(), LanguageDatasource.getAllAvailableLanguages(request, response), resourceResolver, combiningMessageEntryPath, resourceList);
            dataSource = new SimpleDataSource(resourceList.iterator());
        } else {
            LOG.error("No item parameter found in request");
            dataSource = EmptyDataSource.instance();
        }
        request.setAttribute(DataSource.class.getName(), (Object)dataSource);
    }
}

