/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.servlets.datasource;

import be.orbinson.aem.dictionarytranslator.exception.DictionaryException;
import be.orbinson.aem.dictionarytranslator.services.Dictionary;
import be.orbinson.aem.dictionarytranslator.services.DictionaryService;
import be.orbinson.aem.dictionarytranslator.services.impl.CombiningMessageEntryResourceProvider;
import be.orbinson.aem.dictionarytranslator.servlets.datasource.LanguageDatasource;
import be.orbinson.aem.dictionarytranslator.servlets.datasource.SortedAndPaginatedDataSource;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"aem-dictionary-translator/datasource/combining-message-entries-for-table"}, methods={"GET"})
public class CombiningMessageEntriesDatasourceForTable
extends SortedAndPaginatedDataSource {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CombiningMessageEntriesDatasourceForTable.class);
    private final DictionaryService dictionaryService;
    private final CombiningMessageEntryResourceProvider combiningMessageEntryResourceProvider;

    @Activate
    public CombiningMessageEntriesDatasourceForTable(@Reference DictionaryService dictionaryService, @Reference CombiningMessageEntryResourceProvider combiningMessageEntryResourceProvider, @Reference ExpressionResolver resolver) {
        super(resolver);
        this.dictionaryService = dictionaryService;
        this.combiningMessageEntryResourceProvider = combiningMessageEntryResourceProvider;
    }

    private void setColumnsDataSource(ResourceResolver resourceResolver, Collection<Resource> resourceList, Collection<Locale> languages, Map<Locale, String> languageMap) {
        resourceList.add((Resource)CombiningMessageEntriesDatasourceForTable.getColumn(resourceResolver, "select", true, Optional.empty()));
        resourceList.add((Resource)CombiningMessageEntriesDatasourceForTable.getColumn(resourceResolver, "jcr:title", "Key", Optional.of("Key")));
        if (this.combiningMessageEntryResourceProvider.isValidationEnabled()) {
            resourceList.add((Resource)CombiningMessageEntriesDatasourceForTable.getColumn(resourceResolver, "jcr:title", "Validation", Optional.of("Validation")));
        }
        languages.forEach(language -> {
            String title = languageMap.getOrDefault(language, language.toLanguageTag());
            resourceList.add((Resource)CombiningMessageEntriesDatasourceForTable.getColumn(resourceResolver, "jcr:title", title, Optional.of(language.toLanguageTag())));
        });
    }

    @NotNull
    static ValueMapResource getColumn(ResourceResolver resourceResolver, String key, Object value, Optional<String> sortName) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(key, value);
        if (sortName.isPresent()) {
            properties.put("sortable", true);
            properties.put("name", sortName.get());
        }
        ValueMapDecorator valueMap = new ValueMapDecorator(properties);
        return new ValueMapResource(resourceResolver, "", "", (ValueMap)valueMap);
    }

    private static void setDataSource(ResourceResolver resourceResolver, Collection<Resource> resourceList, String dictionaryPath, Collection<String> keys) throws DictionaryException {
        for (String key : keys) {
            String path = CombiningMessageEntryResourceProvider.createPath(dictionaryPath, key);
            Resource keyResource = resourceResolver.getResource(path);
            if (keyResource != null) {
                resourceList.add(keyResource);
                continue;
            }
            throw new IllegalStateException("Could not get resource for path: '" + path + "'.");
        }
    }

    private void createDictionaryDataSource(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceResolver resourceResolver, String dictionaryPath, Collection<Resource> resourceList) throws DictionaryException, ServletException, IOException {
        Collection<Dictionary> dictionaries = this.dictionaryService.getDictionaries(resourceResolver, dictionaryPath);
        if ("columnsdatasource".equals(request.getResource().getName())) {
            this.setColumnsDataSource(resourceResolver, resourceList, dictionaries.stream().map(Dictionary::getLanguage).collect(Collectors.toList()), LanguageDatasource.getAllAvailableLanguages(request, response));
        } else {
            Collection keys = dictionaries.stream().flatMap(d -> {
                try {
                    return d.getEntries().keySet().stream();
                }
                catch (DictionaryException e) {
                    LOG.warn("Unable to get entries for dictionary {}, skipping it", (Object)d.getPath(), (Object)e);
                    return Stream.empty();
                }
            }).distinct().sorted().collect(Collectors.toList());
            CombiningMessageEntriesDatasourceForTable.setDataSource(resourceResolver, resourceList, dictionaryPath, keys);
        }
    }

    @Override
    public Function<Resource, Comparable<?>> getResourceValueForSortName(String sortName) {
        switch (sortName) {
            case "Key": {
                return resource -> (Comparable)resource.getValueMap().get("key", String.class);
            }
            case "Validation": {
                return resource -> {
                    SortedSet validationMessages = (SortedSet)resource.getValueMap().get("validationMessages", SortedSet.class);
                    if (validationMessages != null && !validationMessages.isEmpty()) {
                        return ((CombiningMessageEntryResourceProvider.ValidationMessage)validationMessages.first()).getSeverity().name().toLowerCase(Locale.ENGLISH);
                    }
                    return "";
                };
            }
        }
        return resource -> (Comparable)resource.getValueMap().get(sortName, String.class);
    }

    @Override
    protected void populateResources(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceResolver resolver, Collection<Resource> resources) throws DictionaryException, ServletException, IOException {
        String dictionaryPath = request.getRequestPathInfo().getSuffix();
        if (dictionaryPath == null) {
            throw new IllegalArgumentException("No dictionary path provided in request: " + request.getRequestPathInfo().getSuffix());
        }
        this.createDictionaryDataSource(request, response, resolver, request.getRequestPathInfo().getSuffix(), resources);
    }
}

