/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.servlets.action;

import be.orbinson.aem.dictionarytranslator.exception.DictionaryException;
import be.orbinson.aem.dictionarytranslator.services.DictionaryService;
import be.orbinson.aem.dictionarytranslator.servlets.action.AbstractDictionaryServlet;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.Replicator;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.apache.sling.servlets.post.HtmlResponse;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceSuperType="granite/ui/components/coral/foundation/form", resourceTypes={"aem-dictionary-translator/servlet/action/delete-language"}, methods={"POST"})
public class DeleteLanguageServlet
extends AbstractDictionaryServlet {
    public static final String LANGUAGE_PARAM = "language";
    public static final String DICTIONARY_PARAM = "dictionary";
    @Reference
    private transient DictionaryService dictionaryService;
    @Reference
    private Replicator replicator;

    public void doPost(SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        String language = this.getMandatoryParameter(request, LANGUAGE_PARAM, false);
        String dictionary = this.getMandatoryParameter(request, DICTIONARY_PARAM, false);
        ResourceResolver resourceResolver = request.getResourceResolver();
        try {
            this.dictionaryService.deleteDictionary(this.replicator, resourceResolver, dictionary, Locale.forLanguageTag(language));
            resourceResolver.commit();
        }
        catch (DictionaryException | ReplicationException | PersistenceException e) {
            HtmlResponse htmlResponse = new HtmlResponse();
            htmlResponse.setStatus(400, String.format("Unable to delete language '%s': %s", language, e.getMessage()));
            htmlResponse.send((HttpServletResponse)response, true);
        }
    }
}

