/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.servlets.action;

import be.orbinson.aem.dictionarytranslator.exception.DictionaryException;
import be.orbinson.aem.dictionarytranslator.services.DictionaryService;
import be.orbinson.aem.dictionarytranslator.servlets.action.AbstractDictionaryServlet;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.Replicator;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.apache.sling.servlets.post.HtmlResponse;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceSuperType="granite/ui/components/coral/foundation/form", resourceTypes={"aem-dictionary-translator/servlet/action/delete-dictionary"}, methods={"POST"})
public class DeleteDictionaryServlet
extends AbstractDictionaryServlet {
    public static final String DICTIONARIES_PARAM = "item";
    @Reference
    private transient DictionaryService dictionaryService;
    @Reference
    private Replicator replicator;

    protected void doPost(SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        Collection<String> dictionaries = this.getMandatoryParameters(request, DICTIONARIES_PARAM, false);
        ResourceResolver resourceResolver = request.getResourceResolver();
        for (String dictionaryPath : dictionaries) {
            try {
                this.dictionaryService.deleteDictionaries(this.replicator, resourceResolver, dictionaryPath);
            }
            catch (DictionaryException | ReplicationException | PersistenceException e) {
                HtmlResponse htmlResponse = new HtmlResponse();
                htmlResponse.setStatus(400, String.format("Unable to delete dictionary '%s': %s", dictionaryPath, e.getMessage()));
                htmlResponse.send((HttpServletResponse)response, true);
                return;
            }
        }
        resourceResolver.commit();
    }
}

