/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.servlets.action;

import be.orbinson.aem.dictionarytranslator.exception.DictionaryException;
import be.orbinson.aem.dictionarytranslator.services.DictionaryService;
import be.orbinson.aem.dictionarytranslator.servlets.action.AbstractDictionaryServlet;
import com.day.cq.commons.jcr.JcrUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.apache.sling.servlets.post.HtmlResponse;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceSuperType="granite/ui/components/coral/foundation/form", resourceTypes={"aem-dictionary-translator/servlet/action/create-dictionary"}, methods={"POST"})
public class CreateDictionaryServlet
extends AbstractDictionaryServlet {
    private static final Logger LOG = LoggerFactory.getLogger(CreateDictionaryServlet.class);
    @Reference
    private transient DictionaryService dictionaryService;

    protected void doPost(SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        Object path = this.getMandatoryParameter(request, "path", false);
        String name = this.getMandatoryParameter(request, "name", false);
        path = (String)path + "/" + JcrUtil.escapeIllegalJcrChars((String)name);
        Collection<Locale> languages = this.getMandatoryParameters(request, "language", false, Locale::forLanguageTag);
        Collection<String> basenames = this.getOptionalParameters(request, "basename", true);
        ResourceResolver resourceResolver = request.getResourceResolver();
        try {
            LOG.debug("Create dictionary '{}'", (Object)name);
            this.dictionaryService.createDictionaries(resourceResolver, (String)path, languages, basenames);
            resourceResolver.commit();
        }
        catch (DictionaryException | PersistenceException e) {
            HtmlResponse htmlResponse = new HtmlResponse();
            htmlResponse.setStatus(500, String.format("Unable to create dictionary: %s", e.getMessage()));
            htmlResponse.send((HttpServletResponse)response, true);
        }
    }
}

