/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.services.impl;

import be.orbinson.aem.dictionarytranslator.exception.DictionaryException;
import be.orbinson.aem.dictionarytranslator.services.Dictionary;
import be.orbinson.aem.dictionarytranslator.services.DictionaryService;
import be.orbinson.aem.dictionarytranslator.services.impl.JsonFileDictionary;
import be.orbinson.aem.dictionarytranslator.services.impl.SlingMessageDictionaryImpl;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.Replicator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.jcr.Session;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"resource.paths=/", "resource.change.types=ADDED", "resource.change.types=REMOVED", "resource.change.types=CHANGED"})
public class DictionaryServiceImpl
implements DictionaryService,
ResourceChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(DictionaryServiceImpl.class);
    static final String QUERY_LANGUAGE_ROOTS = "//element(*,mix:language)[@jcr:language]";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private final boolean allowEmptyQueryResults;
    private final Map<String, SortedMap<Locale, Dictionary>> dictionaryMap = new HashMap<String, SortedMap<Locale, Dictionary>>();

    public DictionaryServiceImpl() {
        this(false);
    }

    public DictionaryServiceImpl(boolean allowEmptyQueryResults) {
        this.allowEmptyQueryResults = allowEmptyQueryResults;
    }

    @Override
    public Collection<Dictionary> getAllDictionaries(ResourceResolver resourceResolver) {
        Iterator iterator = resourceResolver.findResources(QUERY_LANGUAGE_ROOTS, "xpath");
        if (!this.allowEmptyQueryResults && !iterator.hasNext()) {
            throw new IllegalStateException("The query '//element(*,mix:language)[@jcr:language]' returned no results. This either means the according search index is corrupt/non-existing or the underlying resource resolver does not support queries  (when executed from tests)!");
        }
        iterator.forEachRemaining(resource -> {
            if (resource == null) {
                throw new IllegalStateException("Resource is null, this should not happen when using the query '//element(*,mix:language)[@jcr:language]'.");
            }
            SortedMap dictionaries = this.dictionaryMap.computeIfAbsent(resource.getParent().getPath(), k -> new TreeMap(new LocaleComparator()));
            Dictionary dictionary = this.getLanguageDictionary((Resource)resource);
            dictionaries.computeIfAbsent(dictionary.getLanguage(), k -> {
                LOG.debug("Creating dictionary for path '{}'", (Object)resource.getPath());
                return dictionary;
            });
        });
        return this.dictionaryMap.values().stream().flatMap(x -> x.values().stream()).collect(Collectors.toList());
    }

    @Override
    public Map<String, SortedMap<Locale, Dictionary>> getAllDictionariesByParentPath(ResourceResolver resourceResolver) {
        this.getAllDictionaries(resourceResolver);
        return this.dictionaryMap;
    }

    @Override
    public Collection<Dictionary> getDictionaries(ResourceResolver resourceResolver, String parentPath) {
        return this.getDictionariesByLanguage(resourceResolver, parentPath).values();
    }

    @Override
    public SortedMap<Locale, Dictionary> getDictionariesByLanguage(ResourceResolver resourceResolver, String parentPath) {
        SortedMap<Locale, Dictionary> dictionaries = this.internalGetDictionaries(parentPath);
        if (dictionaries.isEmpty()) {
            this.getAllDictionaries(resourceResolver);
            dictionaries = this.internalGetDictionaries(parentPath);
        }
        return dictionaries;
    }

    @Override
    public Optional<Dictionary> getDictionary(ResourceResolver resourceResolver, String parentPath, Locale language) {
        Optional<Dictionary> dictionary = this.internalGetDictionary(parentPath, language);
        if (dictionary.isEmpty()) {
            this.getAllDictionaries(resourceResolver);
            dictionary = this.internalGetDictionary(parentPath, language);
            if (dictionary.isEmpty()) {
                SortedMap dictionaries = this.dictionaryMap.computeIfAbsent(parentPath, k -> new TreeMap(new LocaleComparator()));
                dictionaries.put(language, null);
            }
        }
        return dictionary;
    }

    private Optional<Dictionary> internalGetDictionary(String parentPath, Locale language) {
        SortedMap<Locale, Dictionary> dictionaries = this.dictionaryMap.get(parentPath);
        if (dictionaries == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((Dictionary)dictionaries.get(language));
    }

    private SortedMap<Locale, Dictionary> internalGetDictionaries(String parentPath) {
        return this.dictionaryMap.getOrDefault(parentPath, Collections.emptySortedMap()).entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, () -> new TreeMap(new LocaleComparator())));
    }

    protected ResourceResolver createSystemReadResolver() {
        try {
            return this.resourceResolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "dictionary-service"));
        }
        catch (LoginException e) {
            throw new RuntimeException("Unable to create system read resolver", e);
        }
    }

    private Dictionary getLanguageDictionary(Resource resource) {
        if (JsonFileDictionary.isCompliant(resource)) {
            return new JsonFileDictionary(resource, this::createSystemReadResolver);
        }
        return new SlingMessageDictionaryImpl(resource, this::createSystemReadResolver);
    }

    @Override
    public void createDictionary(ResourceResolver resourceResolver, String parentPath, Locale language, Collection<String> baseNames) throws PersistenceException, DictionaryException {
        if (parentPath == null || parentPath.isEmpty()) {
            throw new IllegalArgumentException("Parent path must not be null or empty");
        }
        Resource parentResource = resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            throw new DictionaryException("Parent resource not found at path: " + parentPath);
        }
        Optional<Dictionary> oldDictionary = this.getDictionary(resourceResolver, parentPath, language);
        if (oldDictionary.isPresent()) {
            throw new DictionaryException("Dictionary for language '" + language.toLanguageTag() + "' already exists at path: " + oldDictionary.get().getPath());
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("sling:resourceType", "sling:Folder");
        properties.put("jcr:language", language.toLanguageTag().toLowerCase(Locale.ROOT));
        properties.put("jcr:mixinTypes", "mix:language");
        if (!baseNames.isEmpty()) {
            properties.put("sling:basename", baseNames.toArray(new String[0]));
        } else {
            properties.put("sling:basename", parentResource.getPath());
        }
        LOG.debug("Add dictionary with with properties '{}' to parent resource {}", properties, (Object)parentResource.getPath());
        resourceResolver.create(parentResource, language.toLanguageTag().toLowerCase(Locale.ROOT), properties);
    }

    @Override
    public void createDictionaries(ResourceResolver resourceResolver, String parentPath, Collection<Locale> languages, Collection<String> basenames) throws PersistenceException, DictionaryException {
        LOG.debug("Create dictionaries below '{}'", (Object)parentPath);
        Resource containerResource = ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)parentPath, (String)"sling:Folder", (String)"sling:Folder", (boolean)false);
        for (Locale language : languages) {
            this.createDictionary(resourceResolver, containerResource.getPath(), language, basenames);
        }
    }

    @Override
    public void deleteDictionaries(Replicator replicator, ResourceResolver resourceResolver, String parentPath) throws DictionaryException, ReplicationException, PersistenceException {
        LOG.debug("Delete dictionaries below '{}'", (Object)parentPath);
        Resource dictionaryResource = resourceResolver.getResource(parentPath);
        if (dictionaryResource == null) {
            throw new DictionaryException("Resource at '" + parentPath + "' not found");
        }
        replicator.replicate((Session)resourceResolver.adaptTo(Session.class), ReplicationActionType.DEACTIVATE, dictionaryResource.getPath());
        resourceResolver.delete(dictionaryResource);
    }

    @Override
    public void deleteDictionary(Replicator replicator, ResourceResolver resourceResolver, String parentPath, Locale language) throws DictionaryException, ReplicationException, PersistenceException {
        Dictionary dictionary = this.getDictionary(resourceResolver, parentPath, language).orElseThrow(() -> new DictionaryException("Dictionary not found for parent path '" + parentPath + "' and language '" + String.valueOf(language) + "'"));
        Resource dictionaryResource = resourceResolver.getResource(dictionary.getPath());
        LOG.debug("Delete language '{}' from '{}'", (Object)language, (Object)dictionaryResource.getPath());
        replicator.replicate((Session)resourceResolver.adaptTo(Session.class), ReplicationActionType.DEACTIVATE, dictionaryResource.getPath());
        resourceResolver.delete(dictionaryResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(@NotNull List<ResourceChange> changes) {
        for (ResourceChange change : changes) {
            DictionaryServiceImpl dictionaryServiceImpl = this;
            synchronized (dictionaryServiceImpl) {
                this.dictionaryMap.keySet().removeIf(path -> {
                    if (change.getPath().startsWith((String)path)) {
                        LOG.debug("Invalidating dictionary cache below path '{}'", path);
                        return true;
                    }
                    return false;
                });
            }
        }
    }

    @Override
    public Optional<Dictionary> getConflictingDictionary(ResourceResolver resourceResolver, Dictionary dictionary, String key) {
        return this.getAllDictionaries(resourceResolver).stream().filter(d -> !d.getPath().equals(dictionary.getPath())).filter(d -> d.getLanguage().equals(dictionary.getLanguage())).filter(d -> d.getOrdinal() <= dictionary.getOrdinal()).filter(d -> {
            try {
                return d.getEntries().containsKey(key);
            }
            catch (DictionaryException e) {
                return false;
            }
        }).findFirst();
    }

    private static final class LocaleComparator
    implements Comparator<Locale> {
        private LocaleComparator() {
        }

        @Override
        public int compare(Locale o1, Locale o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.toLanguageTag().compareTo(o2.toLanguageTag());
        }
    }
}

