/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.services.impl;

import be.orbinson.aem.dictionarytranslator.exception.DictionaryException;
import be.orbinson.aem.dictionarytranslator.services.Dictionary;
import be.orbinson.aem.dictionarytranslator.services.DictionaryService;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;
import org.apache.commons.lang3.text.translate.UnicodeUnescaper;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResourceProvider.class, CombiningMessageEntryResourceProvider.class}, property={"provider.root=/mnt/dictionary"})
@Designate(ocd=Config.class)
public class CombiningMessageEntryResourceProvider
extends ResourceProvider<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(CombiningMessageEntryResourceProvider.class);
    public static final String ROOT = "/mnt/dictionary";
    public static final String RESOURCE_TYPE = "aem-dictionary-translator/components/combining-message-entry";
    public static final String KEY = "key";
    public static final String DICTIONARY_PATH = "dictionaryPath";
    public static final String LANGUAGES = "languages";
    public static final String MESSAGE_ENTRY_PATHS = "messageEntryPaths";
    public static final String VALIDATION_MESSAGES = "validationMessages";
    private final DictionaryService dictionaryService;
    private final Config config;

    @Activate
    public CombiningMessageEntryResourceProvider(@Reference DictionaryService dictionaryService, Config config) {
        this.dictionaryService = dictionaryService;
        this.config = config;
    }

    public boolean isValidationEnabled() {
        return this.config.enableValidation();
    }

    static OverlapType checkBasenameOverlap(Set<String> baseNames, Set<String> conflictingDictionaryBaseNames) {
        if (conflictingDictionaryBaseNames == null && baseNames == null) {
            return OverlapType.FULL;
        }
        if (Objects.equals(conflictingDictionaryBaseNames, baseNames)) {
            return OverlapType.FULL;
        }
        if (conflictingDictionaryBaseNames == null || baseNames == null) {
            return OverlapType.POTENTIAL;
        }
        if (baseNames.stream().anyMatch(conflictingDictionaryBaseNames::contains)) {
            return OverlapType.PARTIAL;
        }
        return OverlapType.NONE;
    }

    @Nullable
    public Resource getResource(@NotNull ResolveContext<Object> ctx, @NotNull String path, @NotNull ResourceContext resourceContext, @Nullable Resource parent) {
        ResourceResolver resourceResolver = ctx.getResourceResolver();
        if (!path.startsWith(ROOT) || ROOT.equals(path)) {
            return null;
        }
        String key = CombiningMessageEntryResourceProvider.extractKeyFromPath(path);
        String dictionaryPath = CombiningMessageEntryResourceProvider.getDictionaryPath(path);
        LinkedHashMap<Locale, Dictionary.Message> messagePerLanguage = new LinkedHashMap<Locale, Dictionary.Message>();
        boolean isEditable = true;
        TreeSet validationMessages = new TreeSet();
        Collection<Dictionary> dictionaries = this.dictionaryService.getDictionaries(resourceResolver, dictionaryPath);
        for (Dictionary dictionary : dictionaries) {
            try {
                Dictionary.Message message = dictionary.getEntries().get(key);
                if (message != null && this.config.enableValidation()) {
                    this.validateItem(resourceResolver, dictionary, key, message.getText()).ifPresent(validationMessages::add);
                }
                if (isEditable) {
                    isEditable = dictionary.isEditable(resourceResolver);
                }
                messagePerLanguage.put(dictionary.getLanguage(), message);
            }
            catch (DictionaryException e) {
                LOG.warn("Error retrieving message entries for dictionary at '" + dictionaryPath + "', skipping it", (Throwable)e);
            }
        }
        if (messagePerLanguage.isEmpty()) {
            return null;
        }
        return new ValueMapResource(resourceResolver, path, RESOURCE_TYPE, (ValueMap)new ValueMapDecorator(CombiningMessageEntryResourceProvider.createResourceProperties(path, isEditable, messagePerLanguage, this.config.enableValidation() ? Optional.of(validationMessages) : Optional.empty())));
    }

    private Optional<ValidationMessage> validateItem(ResourceResolver resourceResolver, Dictionary dictionary, String key, String message) {
        ValidationMessage validationMessage;
        Dictionary conflictingDictionary = this.dictionaryService.getConflictingDictionary(resourceResolver, dictionary, key).orElse(null);
        if (conflictingDictionary != null) {
            String otherMessage;
            try {
                otherMessage = conflictingDictionary.getEntries().get(key).getText();
            }
            catch (DictionaryException e) {
                throw new IllegalStateException("Unable to get message entries for in dictionary '" + conflictingDictionary.getPath() + "'", e);
            }
            if (Objects.equals(otherMessage, message)) {
                validationMessage = new ValidationMessage(ValidationMessage.Severity.INFO, dictionary.getLanguage(), "Conflicting dictionary at \"{0}\" for language {1}, it has the same message though.", conflictingDictionary.getPath(), dictionary.getLanguage().toLanguageTag());
            } else {
                Set<String> conflictingDictionaryBasenames = conflictingDictionary.getBaseNames();
                switch (CombiningMessageEntryResourceProvider.checkBasenameOverlap(dictionary.getBaseNames(), conflictingDictionaryBasenames)) {
                    case PARTIAL: {
                        validationMessage = new ValidationMessage(ValidationMessage.Severity.WARNING, dictionary.getLanguage(), "Conflicting dictionary at \"{0}\" for language {1} with another translation and partially overlapping basenames {2}.", conflictingDictionary.getPath(), dictionary.getLanguage().toLanguageTag(), String.join((CharSequence)", ", conflictingDictionaryBasenames));
                        break;
                    }
                    case FULL: {
                        validationMessage = new ValidationMessage(ValidationMessage.Severity.ERROR, dictionary.getLanguage(), "Conflicting dictionary at \"{0}\" for language {1} with another translation for same basenames.", conflictingDictionary.getPath(), dictionary.getLanguage().toLanguageTag());
                        break;
                    }
                    case POTENTIAL: {
                        validationMessage = new ValidationMessage(ValidationMessage.Severity.WARNING, dictionary.getLanguage(), "Potential conflicting dictionary at \"{0}\" for language {1} with another translation and potentially overlapping basenames (one side is null).", conflictingDictionary.getPath(), dictionary.getLanguage().toLanguageTag());
                        break;
                    }
                    default: {
                        validationMessage = null;
                    }
                }
            }
        } else {
            validationMessage = null;
        }
        return Optional.ofNullable(validationMessage);
    }

    static String extractKeyFromPath(@NotNull String path) {
        return new UnicodeUnescaper().translate((CharSequence)Text.getName((String)path));
    }

    public static String createPath(String dictionaryPath, String key) {
        if (!dictionaryPath.startsWith("/")) {
            throw new IllegalArgumentException("dictionaryPath must start with a slash (i.e. must be absolute)");
        }
        Object translator = key.chars().allMatch(c -> c == 46) ? JavaUnicodeEscaper.between((int)46, (int)46) : new AggregateTranslator(new CharSequenceTranslator[]{JavaUnicodeEscaper.between((int)37, (int)37), JavaUnicodeEscaper.between((int)47, (int)47)});
        return ROOT + dictionaryPath + "/" + translator.translate((CharSequence)key);
    }

    @NotNull
    public static Map<String, Object> createResourceProperties(@NotNull String path, boolean isEditable, @NotNull Map<Locale, Dictionary.Message> messagePerLanguage, Optional<SortedSet<ValidationMessage>> validationMessages) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(KEY, CombiningMessageEntryResourceProvider.extractKeyFromPath(path));
        properties.put("path", path);
        properties.put("editable", isEditable);
        properties.put(DICTIONARY_PATH, CombiningMessageEntryResourceProvider.getDictionaryPath(path));
        properties.put(LANGUAGES, messagePerLanguage.keySet().stream().map(Locale::toLanguageTag).toArray(String[]::new));
        ArrayList messageEntryPaths = new ArrayList();
        for (Map.Entry<Locale, Dictionary.Message> messageEntryPerLanguageEntry : messagePerLanguage.entrySet()) {
            String text;
            Dictionary.Message message = messageEntryPerLanguageEntry.getValue();
            if (message == null) {
                text = "";
            } else {
                text = message.getText();
                message.getResourcePath().ifPresent(messageEntryPaths::add);
            }
            properties.put(messageEntryPerLanguageEntry.getKey().toLanguageTag(), text);
        }
        properties.put(MESSAGE_ENTRY_PATHS, messageEntryPaths);
        validationMessages.ifPresent(messages -> properties.put(VALIDATION_MESSAGES, messages));
        return properties;
    }

    @NotNull
    public static String getDictionaryPath(@NotNull String path) {
        return Text.getRelativeParent((String)path, (int)1).replaceFirst(ROOT, "");
    }

    @Nullable
    public Iterator<Resource> listChildren(@NotNull ResolveContext<Object> ctx, @NotNull Resource parent) {
        return Collections.emptyIterator();
    }

    public static final class ValidationMessage
    implements Comparable<ValidationMessage> {
        private final Locale language;
        private final String i18nKey;
        private final String[] arguments;
        private final Severity severity;

        public ValidationMessage(Severity severity, Locale language, String i18nKey, String ... arguments) {
            this.severity = severity;
            this.language = language;
            this.i18nKey = i18nKey;
            this.arguments = arguments;
        }

        public Locale getLanguage() {
            return this.language;
        }

        public String getI18nKey() {
            return this.i18nKey;
        }

        public String[] getArguments() {
            return this.arguments;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        @Override
        public int compareTo(ValidationMessage o) {
            int result = this.severity.compareTo(o.severity);
            if (result == 0) {
                result = 1;
            }
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.arguments);
            result = 31 * result + Objects.hash(new Object[]{this.i18nKey, this.language, this.severity});
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValidationMessage other = (ValidationMessage)obj;
            return Arrays.equals(this.arguments, other.arguments) && Objects.equals(this.i18nKey, other.i18nKey) && Objects.equals(this.language, other.language) && this.severity == other.severity;
        }

        public static enum Severity {
            ERROR("error"),
            WARNING("warning"),
            INFO("info");

            private final String label;

            private Severity(String label) {
                this.label = label;
            }

            public String toString() {
                return this.label;
            }
        }
    }

    static enum OverlapType {
        NONE,
        PARTIAL,
        FULL,
        POTENTIAL;

    }

    @ObjectClassDefinition(name="Orbinson AEM Dictionary Translator - Combining Message Entry Resource Provider", description="Configures aspects which affect the maintenance UI of individual dictionaries.")
    public static @interface Config {
        @AttributeDefinition(name="Enable validation", description="Exposes information on conflicting items. Enabling this may have a negative impact on performance.")
        public boolean enableValidation() default false;
    }
}

