/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.xml;

import aws.smithy.kotlin.runtime.content.BigDecimal;
import aws.smithy.kotlin.runtime.content.BigInteger;
import aws.smithy.kotlin.runtime.content.Document;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.PrimitiveDeserializer;
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor;
import aws.smithy.kotlin.runtime.serde.xml.XmlFieldTraitsKt;
import aws.smithy.kotlin.runtime.serde.xml.XmlStreamReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlStreamReaderKt;
import aws.smithy.kotlin.runtime.serde.xml.XmlToken;
import aws.smithy.kotlin.runtime.text.encoding.Base64Kt;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nJ'\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u000fH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\n\u0010&\u001a\u0004\u0018\u00010'H\u0016J\b\u0010(\u001a\u00020\tH\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Laws/smithy/kotlin/runtime/serde/xml/XmlPrimitiveDeserializer;", "Laws/smithy/kotlin/runtime/serde/PrimitiveDeserializer;", "reader", "Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader;", "fieldDescriptor", "Laws/smithy/kotlin/runtime/serde/SdkFieldDescriptor;", "<init>", "(Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader;Laws/smithy/kotlin/runtime/serde/SdkFieldDescriptor;)V", "input", "", "([BLaws/smithy/kotlin/runtime/serde/SdkFieldDescriptor;)V", "deserializeValue", "T", "transform", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "deserializeByte", "", "deserializeInt", "", "deserializeShort", "", "deserializeLong", "", "deserializeFloat", "", "deserializeDouble", "", "deserializeBigInteger", "Laws/smithy/kotlin/runtime/content/BigInteger;", "deserializeBigDecimal", "Laws/smithy/kotlin/runtime/content/BigDecimal;", "deserializeString", "deserializeBoolean", "", "deserializeDocument", "Laws/smithy/kotlin/runtime/content/Document;", "deserializeNull", "", "deserializeByteArray", "deserializeInstant", "Laws/smithy/kotlin/runtime/time/Instant;", "format", "Laws/smithy/kotlin/runtime/time/TimestampFormat;", "serde-xml"})
@SourceDebugExtension(value={"SMAP\nXmlPrimitiveDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlPrimitiveDeserializer.kt\naws/smithy/kotlin/runtime/serde/xml/XmlPrimitiveDeserializer\n+ 2 XmlStreamReader.kt\naws/smithy/kotlin/runtime/serde/xml/XmlStreamReaderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 XmlStreamReader.kt\naws/smithy/kotlin/runtime/serde/xml/XmlStreamReaderKt$seek$1\n*L\n1#1,85:1\n122#2,13:86\n122#2,13:99\n122#2,13:113\n76#2,6:126\n82#2,4:133\n1#3:112\n77#4:132\n*S KotlinDebug\n*F\n+ 1 XmlPrimitiveDeserializer.kt\naws/smithy/kotlin/runtime/serde/xml/XmlPrimitiveDeserializer\n*L\n26#1:86,13\n33#1:99,13\n37#1:113,13\n70#1:126,6\n70#1:133,4\n70#1:132\n*E\n"})
public final class XmlPrimitiveDeserializer
implements PrimitiveDeserializer {
    @NotNull
    private final XmlStreamReader reader;
    @NotNull
    private final SdkFieldDescriptor fieldDescriptor;

    public XmlPrimitiveDeserializer(@NotNull XmlStreamReader reader, @NotNull SdkFieldDescriptor fieldDescriptor) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)fieldDescriptor, (String)"fieldDescriptor");
        this.reader = reader;
        this.fieldDescriptor = fieldDescriptor;
    }

    public XmlPrimitiveDeserializer(@NotNull byte[] input, @NotNull SdkFieldDescriptor fieldDescriptor) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)fieldDescriptor, (String)"fieldDescriptor");
        this(XmlStreamReaderKt.xmlStreamReader(input), fieldDescriptor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final <T> T deserializeValue(Function1<? super String, ? extends T> transform) {
        XmlToken token$iv;
        Object object;
        boolean $i$f$requireToken;
        XmlToken token$iv$iv;
        XmlToken token$iv2;
        boolean $i$f$takeNextAs;
        XmlStreamReader $this$takeNextAs$iv;
        if (XmlStreamReader.peek$default(this.reader, 0, 1, null) instanceof XmlToken.BeginElement) {
            $this$takeNextAs$iv = this.reader;
            $i$f$takeNextAs = false;
            XmlToken xmlToken = $this$takeNextAs$iv.nextToken();
            if (xmlToken == null) {
                throw new DeserializationException("Expected " + Reflection.getOrCreateKotlinClass(XmlToken.BeginElement.class) + " but instead found null");
            }
            token$iv$iv = token$iv2 = xmlToken;
            $i$f$requireToken = false;
            if (token$iv$iv.getClass() != XmlToken.BeginElement.class) {
                throw new DeserializationException("Expected " + Reflection.getOrCreateKotlinClass(XmlToken.BeginElement.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv$iv.getClass()) + " (" + token$iv$iv + ')');
            }
            XmlToken xmlToken2 = token$iv2;
            if (xmlToken2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.xml.XmlToken.BeginElement");
            }
            XmlToken.BeginElement wrapperToken = (XmlToken.BeginElement)((XmlToken)((XmlToken.BeginElement)xmlToken2));
            if (!Intrinsics.areEqual((Object)wrapperToken.getName().getLocal(), (Object)XmlFieldTraitsKt.generalName(this.fieldDescriptor))) {
                return this.deserializeValue(transform);
            }
        }
        $this$takeNextAs$iv = this.reader;
        $i$f$takeNextAs = false;
        XmlToken xmlToken = $this$takeNextAs$iv.nextToken();
        if (xmlToken == null) {
            throw new DeserializationException("Expected " + Reflection.getOrCreateKotlinClass(XmlToken.Text.class) + " but instead found null");
        }
        token$iv$iv = token$iv2 = xmlToken;
        $i$f$requireToken = false;
        if (token$iv$iv.getClass() != XmlToken.Text.class) {
            throw new DeserializationException("Expected " + Reflection.getOrCreateKotlinClass(XmlToken.Text.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv$iv.getClass()) + " (" + token$iv$iv + ')');
        }
        XmlToken xmlToken3 = token$iv2;
        if (xmlToken3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.xml.XmlToken.Text");
        }
        XmlToken.Text token = (XmlToken.Text)((XmlToken)((XmlToken.Text)xmlToken3));
        String string = token.getValue();
        if (string == null) throw new DeserializationException(token + " specifies nonexistent or invalid value.");
        String it = string;
        boolean bl = false;
        Object object2 = transform.invoke((Object)it);
        if (object2 == null) throw new DeserializationException(token + " specifies nonexistent or invalid value.");
        Object it2 = object = object2;
        boolean bl2 = false;
        XmlStreamReader $this$takeNextAs$iv2 = this.reader;
        boolean $i$f$takeNextAs2 = false;
        XmlToken xmlToken4 = $this$takeNextAs$iv2.nextToken();
        if (xmlToken4 == null) {
            throw new DeserializationException("Expected " + Reflection.getOrCreateKotlinClass(XmlToken.EndElement.class) + " but instead found null");
        }
        XmlToken token$iv$iv2 = token$iv = xmlToken4;
        boolean $i$f$requireToken2 = false;
        if (token$iv$iv2.getClass() != XmlToken.EndElement.class) {
            throw new DeserializationException("Expected " + Reflection.getOrCreateKotlinClass(XmlToken.EndElement.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv$iv2.getClass()) + " (" + token$iv$iv2 + ')');
        }
        XmlToken xmlToken5 = token$iv;
        if (xmlToken5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.xml.XmlToken.EndElement");
        }
        XmlToken cfr_ignored_0 = (XmlToken.EndElement)xmlToken5;
        return (T)object;
    }

    public byte deserializeByte() {
        return ((Number)this.deserializeValue(XmlPrimitiveDeserializer::deserializeByte$lambda$2)).byteValue();
    }

    public int deserializeInt() {
        return ((Number)this.deserializeValue(XmlPrimitiveDeserializer::deserializeInt$lambda$3)).intValue();
    }

    public short deserializeShort() {
        return ((Number)this.deserializeValue(XmlPrimitiveDeserializer::deserializeShort$lambda$4)).shortValue();
    }

    public long deserializeLong() {
        return ((Number)this.deserializeValue(XmlPrimitiveDeserializer::deserializeLong$lambda$5)).longValue();
    }

    public float deserializeFloat() {
        return ((Number)this.deserializeValue(XmlPrimitiveDeserializer::deserializeFloat$lambda$6)).floatValue();
    }

    public double deserializeDouble() {
        return ((Number)this.deserializeValue(XmlPrimitiveDeserializer::deserializeDouble$lambda$7)).doubleValue();
    }

    @NotNull
    public BigInteger deserializeBigInteger() {
        return (BigInteger)this.deserializeValue(arg_0 -> XmlPrimitiveDeserializer.deserializeBigInteger$lambda$10(this, arg_0));
    }

    @NotNull
    public BigDecimal deserializeBigDecimal() {
        return (BigDecimal)this.deserializeValue(arg_0 -> XmlPrimitiveDeserializer.deserializeBigDecimal$lambda$13(this, arg_0));
    }

    @NotNull
    public String deserializeString() {
        return (String)this.deserializeValue(XmlPrimitiveDeserializer::deserializeString$lambda$14);
    }

    public boolean deserializeBoolean() {
        return (Boolean)this.deserializeValue(XmlPrimitiveDeserializer::deserializeBoolean$lambda$15);
    }

    @NotNull
    public Document deserializeDocument() {
        throw new DeserializationException("cannot deserialize unsupported Document type in xml");
    }

    @Nullable
    public Void deserializeNull() {
        boolean foundMatch$iv;
        if (this.reader.nextToken() == null) {
            throw new DeserializationException("Unexpected end of stream");
        }
        XmlStreamReader $this$seek_u24default$iv = this.reader;
        boolean $i$f$seek = false;
        XmlToken token$iv = $this$seek_u24default$iv.getLastToken();
        do {
            boolean bl;
            if (token$iv instanceof XmlToken.EndElement) {
                XmlToken xmlToken = token$iv;
                boolean bl2 = false;
                XmlToken it = xmlToken;
                bl = true;
            } else {
                bl = foundMatch$iv = false;
            }
            if (foundMatch$iv) continue;
            token$iv = $this$seek_u24default$iv.nextToken();
        } while (token$iv != null && !foundMatch$iv);
        XmlToken cfr_ignored_0 = (XmlToken.EndElement)token$iv;
        if (this.reader.nextToken() == null) {
            throw new DeserializationException("Unexpected end of stream");
        }
        return null;
    }

    @NotNull
    public byte[] deserializeByteArray() {
        return Base64Kt.decodeBase64Bytes((String)this.deserializeString());
    }

    @NotNull
    public Instant deserializeInstant(@NotNull TimestampFormat format) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                String it = this.deserializeString();
                boolean bl = false;
                instant = Instant.Companion.fromEpochSeconds(it);
                break;
            }
            case 2: {
                String it = this.deserializeString();
                boolean bl = false;
                instant = Instant.Companion.fromIso8601(it);
                break;
            }
            case 3: {
                String it = this.deserializeString();
                boolean bl = false;
                instant = Instant.Companion.fromRfc5322(it);
                break;
            }
            default: {
                throw new DeserializationException("unknown timestamp format: " + format);
            }
        }
        return instant;
    }

    private static final byte deserializeByte$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Integer n = StringsKt.toIntOrNull((String)it);
        if (n == null) {
            throw new DeserializationException("Unable to deserialize " + it + " as Byte");
        }
        return (byte)n.intValue();
    }

    private static final int deserializeInt$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Integer n = StringsKt.toIntOrNull((String)it);
        if (n == null) {
            throw new DeserializationException("Unable to deserialize " + it + " as Int");
        }
        return n;
    }

    private static final short deserializeShort$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Integer n = StringsKt.toIntOrNull((String)it);
        if (n == null) {
            throw new DeserializationException("Unable to deserialize " + it + " as Short");
        }
        return (short)n.intValue();
    }

    private static final long deserializeLong$lambda$5(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Long l = StringsKt.toLongOrNull((String)it);
        if (l == null) {
            throw new DeserializationException("Unable to deserialize " + it + " as Long");
        }
        return l;
    }

    private static final float deserializeFloat$lambda$6(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Float f = StringsKt.toFloatOrNull((String)it);
        if (f == null) {
            throw new DeserializationException("Unable to deserialize " + it + " as Float");
        }
        return f.floatValue();
    }

    private static final double deserializeDouble$lambda$7(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Double d = StringsKt.toDoubleOrNull((String)it);
        if (d == null) {
            throw new DeserializationException("Unable to deserialize " + it + " as Double");
        }
        return d;
    }

    private static final BigInteger deserializeBigInteger$lambda$10(XmlPrimitiveDeserializer this$0, String it) {
        Object $this$deserializeBigInteger_u24lambda_u2410_u24lambda_u248;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = this$0;
        try {
            $this$deserializeBigInteger_u24lambda_u2410_u24lambda_u248 = object;
            boolean bl = false;
            $this$deserializeBigInteger_u24lambda_u2410_u24lambda_u248 = Result.constructor-impl((Object)new BigInteger(it));
        }
        catch (Throwable bl) {
            $this$deserializeBigInteger_u24lambda_u2410_u24lambda_u248 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$deserializeBigInteger_u24lambda_u2410_u24lambda_u248;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it2 = throwable;
            boolean bl = false;
            throw new DeserializationException("Unable to deserialize " + it2 + " as BigInteger");
        }
        return (BigInteger)object;
    }

    private static final BigDecimal deserializeBigDecimal$lambda$13(XmlPrimitiveDeserializer this$0, String it) {
        Object $this$deserializeBigDecimal_u24lambda_u2413_u24lambda_u2411;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = this$0;
        try {
            $this$deserializeBigDecimal_u24lambda_u2413_u24lambda_u2411 = object;
            boolean bl = false;
            $this$deserializeBigDecimal_u24lambda_u2413_u24lambda_u2411 = Result.constructor-impl((Object)new BigDecimal(it));
        }
        catch (Throwable bl) {
            $this$deserializeBigDecimal_u24lambda_u2413_u24lambda_u2411 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$deserializeBigDecimal_u24lambda_u2413_u24lambda_u2411;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it2 = throwable;
            boolean bl = false;
            throw new DeserializationException("Unable to deserialize " + it2 + " as BigDecimal");
        }
        return (BigDecimal)object;
    }

    private static final String deserializeString$lambda$14(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final boolean deserializeBoolean$lambda$15(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Boolean.parseBoolean(it);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TimestampFormat.values().length];
            try {
                nArray[TimestampFormat.EPOCH_SECONDS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormat.ISO_8601.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormat.RFC_5322.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

