/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.xml;

import aws.smithy.kotlin.runtime.collections.StackKt;
import aws.smithy.kotlin.runtime.content.BigDecimal;
import aws.smithy.kotlin.runtime.content.BigInteger;
import aws.smithy.kotlin.runtime.content.Document;
import aws.smithy.kotlin.runtime.serde.FieldTrait;
import aws.smithy.kotlin.runtime.serde.ListSerializer;
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor;
import aws.smithy.kotlin.runtime.serde.SdkSerializable;
import aws.smithy.kotlin.runtime.serde.SerializationException;
import aws.smithy.kotlin.runtime.serde.Serializer;
import aws.smithy.kotlin.runtime.serde.xml.Flattened;
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName;
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionValueNamespace;
import aws.smithy.kotlin.runtime.serde.xml.XmlFieldTraitsKt;
import aws.smithy.kotlin.runtime.serde.xml.XmlSerializer;
import aws.smithy.kotlin.runtime.serde.xml.XmlSerializerKt;
import aws.smithy.kotlin.runtime.serde.xml.XmlStreamWriter;
import aws.smithy.kotlin.runtime.text.encoding.Base64Kt;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u000bH\u0016J\u0012\u0010)\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010*H\u0016J\u0018\u0010+\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u000202H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00063"}, d2={"Laws/smithy/kotlin/runtime/serde/xml/XmlListSerializer;", "Laws/smithy/kotlin/runtime/serde/ListSerializer;", "descriptor", "Laws/smithy/kotlin/runtime/serde/SdkFieldDescriptor;", "xmlWriter", "Laws/smithy/kotlin/runtime/serde/xml/XmlStreamWriter;", "xmlSerializer", "Laws/smithy/kotlin/runtime/serde/xml/XmlSerializer;", "<init>", "(Laws/smithy/kotlin/runtime/serde/SdkFieldDescriptor;Laws/smithy/kotlin/runtime/serde/xml/XmlStreamWriter;Laws/smithy/kotlin/runtime/serde/xml/XmlSerializer;)V", "endList", "", "memberTagName", "", "getMemberTagName", "()Ljava/lang/String;", "serializeBoolean", "value", "", "serializeByte", "", "serializeShort", "", "serializeChar", "", "serializeInt", "", "serializeLong", "", "serializeFloat", "", "serializeDouble", "", "serializeBigInteger", "Laws/smithy/kotlin/runtime/content/BigInteger;", "serializeBigDecimal", "Laws/smithy/kotlin/runtime/content/BigDecimal;", "serializeString", "serializeSdkSerializable", "Laws/smithy/kotlin/runtime/serde/SdkSerializable;", "serializeNull", "serializeDocument", "Laws/smithy/kotlin/runtime/content/Document;", "serializeInstant", "Laws/smithy/kotlin/runtime/time/Instant;", "format", "Laws/smithy/kotlin/runtime/time/TimestampFormat;", "serializeByteArray", "", "serializePrimitive", "", "serde-xml"})
@SourceDebugExtension(value={"SMAP\nXmlSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlSerializer.kt\naws/smithy/kotlin/runtime/serde/xml/XmlListSerializer\n+ 2 SdkFieldDescriptor.kt\naws/smithy/kotlin/runtime/serde/SdkFieldDescriptorKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,433:1\n103#2:434\n103#2:438\n87#2:442\n89#2:444\n87#2:445\n89#2:447\n87#2:448\n89#2:450\n87#2:451\n89#2:453\n1761#3,3:435\n1761#3,3:439\n1#4:443\n1#4:446\n1#4:449\n1#4:452\n*S KotlinDebug\n*F\n+ 1 XmlSerializer.kt\naws/smithy/kotlin/runtime/serde/xml/XmlListSerializer\n*L\n347#1:434\n354#1:438\n355#1:442\n355#1:444\n382#1:445\n382#1:447\n390#1:448\n390#1:450\n403#1:451\n403#1:453\n347#1:435,3\n354#1:439,3\n355#1:443\n382#1:446\n390#1:449\n403#1:452\n*E\n"})
final class XmlListSerializer
implements ListSerializer {
    @NotNull
    private final SdkFieldDescriptor descriptor;
    @NotNull
    private final XmlStreamWriter xmlWriter;
    @NotNull
    private final XmlSerializer xmlSerializer;

    public XmlListSerializer(@NotNull SdkFieldDescriptor descriptor, @NotNull XmlStreamWriter xmlWriter, @NotNull XmlSerializer xmlSerializer) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)xmlWriter, (String)"xmlWriter");
        Intrinsics.checkNotNullParameter((Object)xmlSerializer, (String)"xmlSerializer");
        this.descriptor = descriptor;
        this.xmlWriter = xmlWriter;
        this.xmlSerializer = xmlSerializer;
    }

    public void endList() {
        boolean bl;
        block4: {
            SdkFieldDescriptor $this$hasTrait$iv = this.descriptor;
            boolean $i$f$hasTrait = false;
            Iterable $this$any$iv$iv = $this$hasTrait$iv.getTraits();
            boolean $i$f$any = false;
            if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv$iv : $this$any$iv$iv) {
                    FieldTrait it$iv = (FieldTrait)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it$iv instanceof Flattened)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (!bl) {
            XmlStreamWriter.endTag$default(this.xmlWriter, XmlFieldTraitsKt.getSerialName(this.descriptor).getName(), null, 2, null);
        }
    }

    private final String getMemberTagName() {
        Object object;
        boolean bl;
        block8: {
            SdkFieldDescriptor $this$hasTrait$iv = this.descriptor;
            boolean $i$f$hasTrait = false;
            Iterable $this$any$iv$iv = $this$hasTrait$iv.getTraits();
            boolean $i$f$any = false;
            if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv$iv : $this$any$iv$iv) {
                    FieldTrait it$iv = (FieldTrait)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it$iv instanceof Flattened)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            object = XmlFieldTraitsKt.getSerialName(this.descriptor).getName();
        } else {
            FieldTrait x$iv;
            FieldTrait fieldTrait;
            Iterator iterator;
            block9: {
                SdkFieldDescriptor $this$findTrait$iv = this.descriptor;
                boolean $i$f$findTrait = false;
                for (Iterator iterator2 : (Iterable)$this$findTrait$iv.getTraits()) {
                    FieldTrait it$iv = (FieldTrait)iterator2;
                    boolean bl3 = false;
                    if (!(it$iv.getClass() == XmlCollectionName.class)) continue;
                    iterator = iterator2;
                    break block9;
                }
                iterator = null;
            }
            if (!((fieldTrait = (x$iv = (FieldTrait)iterator)) instanceof XmlCollectionName)) {
                fieldTrait = null;
            }
            if ((object = (XmlCollectionName)((FieldTrait)((XmlCollectionName)fieldTrait))) == null || (object = ((XmlCollectionName)object).getElement()) == null) {
                object = XmlCollectionName.Companion.getDefault().getElement();
            }
        }
        return object;
    }

    public void serializeBoolean(boolean value) {
        this.serializePrimitive(value);
    }

    public void serializeByte(byte value) {
        this.serializePrimitive(value);
    }

    public void serializeShort(short value) {
        this.serializePrimitive(value);
    }

    public void serializeChar(char value) {
        this.serializePrimitive(Character.valueOf(value));
    }

    public void serializeInt(int value) {
        this.serializePrimitive(value);
    }

    public void serializeLong(long value) {
        this.serializePrimitive(value);
    }

    public void serializeFloat(float value) {
        this.serializePrimitive(Float.valueOf(value));
    }

    public void serializeDouble(double value) {
        this.serializePrimitive(value);
    }

    public void serializeBigInteger(@NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.serializePrimitive(value);
    }

    public void serializeBigDecimal(@NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.serializePrimitive(value.toPlainString());
    }

    public void serializeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.serializePrimitive(value);
    }

    public void serializeSdkSerializable(@NotNull SdkSerializable value) {
        FieldTrait x$iv;
        FieldTrait fieldTrait;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            StackKt.push(this.xmlSerializer.getParentDescriptorStack$serde_xml(), (Object)this.descriptor);
            SdkFieldDescriptor $this$findTrait$iv = this.descriptor;
            boolean $i$f$findTrait = false;
            for (Object t : (Iterable)$this$findTrait$iv.getTraits()) {
                FieldTrait it$iv = (FieldTrait)t;
                boolean bl = false;
                if (!(it$iv.getClass() == XmlCollectionValueNamespace.class)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if (!((fieldTrait = (x$iv = (FieldTrait)v0)) instanceof XmlCollectionValueNamespace)) {
            fieldTrait = null;
        }
        XmlCollectionValueNamespace ns = (XmlCollectionValueNamespace)((FieldTrait)((XmlCollectionValueNamespace)fieldTrait));
        XmlSerializerKt.access$writeTag(this.xmlWriter, this.getMemberTagName(), ns, arg_0 -> XmlListSerializer.serializeSdkSerializable$lambda$0(value, this, arg_0));
        StackKt.pop(this.xmlSerializer.getParentDescriptorStack$serde_xml());
    }

    public void serializeNull() {
        FieldTrait x$iv;
        FieldTrait fieldTrait;
        Object v0;
        block2: {
            SdkFieldDescriptor $this$findTrait$iv = this.descriptor;
            boolean $i$f$findTrait = false;
            for (Object t : (Iterable)$this$findTrait$iv.getTraits()) {
                FieldTrait it$iv = (FieldTrait)t;
                boolean bl = false;
                if (!(it$iv.getClass() == XmlCollectionValueNamespace.class)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if (!((fieldTrait = (x$iv = (FieldTrait)v0)) instanceof XmlCollectionValueNamespace)) {
            fieldTrait = null;
        }
        XmlCollectionValueNamespace ns = (XmlCollectionValueNamespace)((FieldTrait)((XmlCollectionValueNamespace)fieldTrait));
        XmlSerializerKt.writeTag$default(this.xmlWriter, this.getMemberTagName(), ns, null, 4, null);
    }

    public void serializeDocument(@Nullable Document value) {
        throw new SerializationException("document values not supported by xml serializer");
    }

    public void serializeInstant(@NotNull Instant value, @NotNull TimestampFormat format) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.serializeString(value.format(format));
    }

    public void serializeByteArray(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.serializeString(Base64Kt.encodeBase64String((byte[])value));
    }

    private final void serializePrimitive(Object value) {
        FieldTrait x$iv;
        FieldTrait fieldTrait;
        Object v0;
        block2: {
            SdkFieldDescriptor $this$findTrait$iv = this.descriptor;
            boolean $i$f$findTrait = false;
            for (Object t : (Iterable)$this$findTrait$iv.getTraits()) {
                FieldTrait it$iv = (FieldTrait)t;
                boolean bl = false;
                if (!(it$iv.getClass() == XmlCollectionValueNamespace.class)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if (!((fieldTrait = (x$iv = (FieldTrait)v0)) instanceof XmlCollectionValueNamespace)) {
            fieldTrait = null;
        }
        XmlCollectionValueNamespace ns = (XmlCollectionValueNamespace)((FieldTrait)((XmlCollectionValueNamespace)fieldTrait));
        XmlSerializerKt.access$writeTag(this.xmlWriter, this.getMemberTagName(), ns, arg_0 -> XmlListSerializer.serializePrimitive$lambda$1(value, arg_0));
    }

    private static final Unit serializeSdkSerializable$lambda$0(SdkSerializable $value, XmlListSerializer this$0, XmlStreamWriter $this$writeTag) {
        Intrinsics.checkNotNullParameter((Object)$this$writeTag, (String)"$this$writeTag");
        $value.serialize((Serializer)this$0.xmlSerializer);
        return Unit.INSTANCE;
    }

    private static final Unit serializePrimitive$lambda$1(Object $value, XmlStreamWriter $this$writeTag) {
        Intrinsics.checkNotNullParameter((Object)$this$writeTag, (String)"$this$writeTag");
        $this$writeTag.text($value.toString());
        return Unit.INSTANCE;
    }
}

