/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.json;

import aws.smithy.kotlin.runtime.collections.StackKt;
import aws.smithy.kotlin.runtime.content.BigDecimal;
import aws.smithy.kotlin.runtime.content.BigInteger;
import aws.smithy.kotlin.runtime.serde.json.JsonEncoderKt;
import aws.smithy.kotlin.runtime.serde.json.JsonStreamWriter;
import aws.smithy.kotlin.runtime.serde.json.LexerState;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u000e\n\u0002\u0010\u0004\n\u0002\u0010\u0005\n\u0002\u0010\t\n\u0002\u0010\n\n\u0002\u0010\u0007\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J)\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001e\"\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u0014H\u0002J\b\u0010!\u001a\u00020\u0014H\u0002J\b\u0010\"\u001a\u00020\u0014H\u0002J\b\u0010#\u001a\u00020\u0014H\u0002J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u001aH\u0002J\b\u0010&\u001a\u00020\u0014H\u0016J\u0018\u0010'\u001a\u00020\u0014*\u00060\u0007j\u0002`\b2\u0006\u0010%\u001a\u00020\u001aH\u0002J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u001aH\u0016J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u001aH\u0016J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u0003H\u0016J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010%\u001a\u00020-H\u0002J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010%\u001a\u00020-H\u0016J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010%\u001a\u00020.H\u0016J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010%\u001a\u00020/H\u0016J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010%\u001a\u000200H\u0016J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0012H\u0016J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010%\u001a\u000201H\u0016J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010%\u001a\u000202H\u0016J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010%\u001a\u000203H\u0016J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010%\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Laws/smithy/kotlin/runtime/serde/json/JsonEncoder;", "Laws/smithy/kotlin/runtime/serde/json/JsonStreamWriter;", "pretty", "", "<init>", "(Z)V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "bytes", "", "getBytes", "()[B", "state", "", "Laws/smithy/kotlin/runtime/serde/json/LexerState;", "Laws/smithy/kotlin/runtime/collections/ListStack;", "depth", "", "beginObject", "", "endObject", "beginArray", "endArray", "openStructure", "token", "", "nextState", "closeStructure", "allowedStates", "", "(Ljava/lang/String;[Laws/smithy/kotlin/runtime/serde/json/LexerState;)V", "writeIndent", "writeNewline", "writeComma", "writeColon", "encodeValue", "value", "writeNull", "appendQuoted", "writeName", "name", "writeValue", "bool", "writeNumber", "", "", "", "", "", "", "Laws/smithy/kotlin/runtime/content/BigInteger;", "Laws/smithy/kotlin/runtime/content/BigDecimal;", "writeRawValue", "serde-json"})
@SourceDebugExtension(value={"SMAP\nJsonEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonEncoder.kt\naws/smithy/kotlin/runtime/serde/json/JsonEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1#2:162\n*E\n"})
public final class JsonEncoder
implements JsonStreamWriter {
    private final boolean pretty;
    @NotNull
    private final StringBuilder buffer;
    @NotNull
    private final List<LexerState> state;
    private int depth;

    public JsonEncoder(boolean pretty) {
        this.pretty = pretty;
        this.buffer = new StringBuilder();
        LexerState[] lexerStateArray = new LexerState[]{LexerState.Initial};
        this.state = CollectionsKt.mutableListOf((Object[])lexerStateArray);
    }

    public /* synthetic */ JsonEncoder(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        String string = this.buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.encodeToByteArray((String)string);
    }

    @Override
    public void beginObject() {
        this.openStructure("{", LexerState.ObjectFirstKeyOrEnd);
    }

    @Override
    public void endObject() {
        LexerState[] lexerStateArray = new LexerState[]{LexerState.ObjectFirstKeyOrEnd, LexerState.ObjectNextKeyOrEnd};
        this.closeStructure("}", lexerStateArray);
    }

    @Override
    public void beginArray() {
        this.openStructure("[", LexerState.ArrayFirstValueOrEnd);
    }

    @Override
    public void endArray() {
        LexerState[] lexerStateArray = new LexerState[]{LexerState.ArrayFirstValueOrEnd, LexerState.ArrayNextValueOrEnd};
        this.closeStructure("]", lexerStateArray);
    }

    private final void openStructure(String token, LexerState nextState) {
        this.encodeValue(token);
        this.writeNewline();
        int n = this.depth;
        this.depth = n + 1;
        StackKt.push(this.state, (Object)((Object)nextState));
    }

    private final void closeStructure(String token, LexerState ... allowedStates) {
        this.writeNewline();
        int n = this.depth;
        this.depth = n + -1;
        this.writeIndent();
        this.buffer.append(token);
        LexerState last = (LexerState)((Object)StackKt.pop(this.state));
        if (!ArraysKt.contains((Object[])allowedStates, (Object)((Object)last))) {
            boolean bl = false;
            String string = "Invalid JSON encoder state " + (Object)((Object)last) + "; expected one of " + ArraysKt.joinToString$default((Object[])allowedStates, null, null, null, (int)0, null, null, (int)63, null);
            throw new IllegalStateException(string.toString());
        }
    }

    private final void writeIndent() {
        if (this.pretty && this.depth > 0) {
            String indent = StringsKt.repeat((CharSequence)" ", (int)(this.depth * 4));
            this.buffer.append(indent);
        }
    }

    private final void writeNewline() {
        if (this.pretty) {
            this.buffer.append('\n');
        }
    }

    private final void writeComma() {
        this.buffer.append(",");
        this.writeNewline();
    }

    private final void writeColon() {
        this.buffer.append(":");
        if (this.pretty) {
            this.buffer.append(" ");
        }
    }

    private final void encodeValue(String value) {
        switch (WhenMappings.$EnumSwitchMapping$0[((LexerState)((Object)StackKt.top(this.state))).ordinal()]) {
            case 1: {
                StackKt.replaceTop(this.state, (Object)((Object)LexerState.ArrayNextValueOrEnd));
                this.writeIndent();
                break;
            }
            case 2: {
                this.writeComma();
                this.writeIndent();
                break;
            }
            case 3: {
                this.writeColon();
                StackKt.replaceTop(this.state, (Object)((Object)LexerState.ObjectNextKeyOrEnd));
            }
        }
        this.buffer.append(value);
    }

    @Override
    public void writeNull() {
        this.encodeValue("null");
    }

    private final void appendQuoted(StringBuilder $this$appendQuoted, String value) {
        $this$appendQuoted.append("\"");
        $this$appendQuoted.append(value);
        $this$appendQuoted.append("\"");
    }

    @Override
    public void writeName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (StackKt.top(this.state) == LexerState.ObjectNextKeyOrEnd) {
            this.writeComma();
        }
        this.writeIndent();
        this.appendQuoted(this.buffer, JsonEncoderKt.escape(name));
        StackKt.replaceTop(this.state, (Object)((Object)LexerState.ObjectFieldValue));
    }

    @Override
    public void writeValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encodeValue('\"' + JsonEncoderKt.escape(value) + '\"');
    }

    @Override
    public void writeValue(boolean bool) {
        this.encodeValue(String.valueOf(bool));
    }

    private final void writeNumber(Number value) {
        this.encodeValue(value.toString());
    }

    @Override
    public void writeValue(@NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writeNumber(value);
    }

    @Override
    public void writeValue(byte value) {
        this.writeNumber(value);
    }

    @Override
    public void writeValue(long value) {
        this.writeNumber(value);
    }

    @Override
    public void writeValue(short value) {
        this.writeNumber(value);
    }

    @Override
    public void writeValue(int value) {
        this.writeNumber(value);
    }

    @Override
    public void writeValue(float value) {
        this.writeNumber(Float.valueOf(value));
    }

    @Override
    public void writeValue(double value) {
        this.writeNumber(value);
    }

    @Override
    public void writeValue(@NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writeNumber((Number)value);
    }

    @Override
    public void writeValue(@NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encodeValue(value.toPlainString());
    }

    @Override
    public void writeRawValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encodeValue(value);
    }

    public JsonEncoder() {
        this(false, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LexerState.values().length];
            try {
                nArray[LexerState.ArrayFirstValueOrEnd.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.ArrayNextValueOrEnd.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.ObjectFieldValue.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

