/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.formurl;

import aws.smithy.kotlin.runtime.content.BigDecimal;
import aws.smithy.kotlin.runtime.content.BigInteger;
import aws.smithy.kotlin.runtime.content.Document;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkBufferedSink;
import aws.smithy.kotlin.runtime.serde.ListSerializer;
import aws.smithy.kotlin.runtime.serde.MapSerializer;
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor;
import aws.smithy.kotlin.runtime.serde.SdkSerializable;
import aws.smithy.kotlin.runtime.serde.SerializationException;
import aws.smithy.kotlin.runtime.serde.Serializer;
import aws.smithy.kotlin.runtime.serde.StructSerializer;
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlListSerializer;
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlMapSerializer;
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializerKt;
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlStructSerializer;
import aws.smithy.kotlin.runtime.text.encoding.Base64Kt;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J!\u0010\u0016\u001a\u00020\u00172\u0017\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00170\u0019\u00a2\u0006\u0002\b\u001aH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\u0018\u00101\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0015H\u0016J\u0010\u00106\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u000207H\u0016J\b\u00108\u001a\u00020\u0017H\u0016J\u0012\u00109\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010:H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006;"}, d2={"Laws/smithy/kotlin/runtime/serde/formurl/FormUrlSerializer;", "Laws/smithy/kotlin/runtime/serde/Serializer;", "buffer", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "prefix", "", "<init>", "(Laws/smithy/kotlin/runtime/io/SdkBuffer;Ljava/lang/String;)V", "getBuffer", "()Laws/smithy/kotlin/runtime/io/SdkBuffer;", "getPrefix", "()Ljava/lang/String;", "beginStruct", "Laws/smithy/kotlin/runtime/serde/StructSerializer;", "descriptor", "Laws/smithy/kotlin/runtime/serde/SdkFieldDescriptor;", "beginList", "Laws/smithy/kotlin/runtime/serde/ListSerializer;", "beginMap", "Laws/smithy/kotlin/runtime/serde/MapSerializer;", "toByteArray", "", "write", "", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "value", "serializeBoolean", "", "serializeByte", "", "serializeChar", "", "serializeShort", "", "serializeInt", "", "serializeLong", "", "serializeFloat", "", "serializeDouble", "", "serializeBigInteger", "Laws/smithy/kotlin/runtime/content/BigInteger;", "serializeBigDecimal", "Laws/smithy/kotlin/runtime/content/BigDecimal;", "serializeString", "serializeInstant", "Laws/smithy/kotlin/runtime/time/Instant;", "format", "Laws/smithy/kotlin/runtime/time/TimestampFormat;", "serializeByteArray", "serializeSdkSerializable", "Laws/smithy/kotlin/runtime/serde/SdkSerializable;", "serializeNull", "serializeDocument", "Laws/smithy/kotlin/runtime/content/Document;", "serde-form-url"})
final class FormUrlSerializer
implements Serializer {
    @NotNull
    private final SdkBuffer buffer;
    @NotNull
    private final String prefix;

    public FormUrlSerializer(@NotNull SdkBuffer buffer, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.buffer = buffer;
        this.prefix = prefix;
    }

    public /* synthetic */ FormUrlSerializer(SdkBuffer sdkBuffer, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(sdkBuffer, string);
    }

    @NotNull
    public final SdkBuffer getBuffer() {
        return this.buffer;
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public StructSerializer beginStruct(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return new FormUrlStructSerializer(this, descriptor, this.prefix);
    }

    @NotNull
    public ListSerializer beginList(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return new FormUrlListSerializer(this, descriptor);
    }

    @NotNull
    public MapSerializer beginMap(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return new FormUrlMapSerializer(this, descriptor);
    }

    @NotNull
    public byte[] toByteArray() {
        return this.buffer.readByteArray();
    }

    private final void write(Function1<? super SdkBuffer, Unit> block) {
        SdkBuffer sdkBuffer = this.buffer;
        block.invoke((Object)sdkBuffer);
    }

    private final void write(String value) {
        this.write((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlSerializer.write$lambda$0(value, arg_0)));
    }

    public void serializeBoolean(boolean value) {
        this.write(String.valueOf(value));
    }

    public void serializeByte(byte value) {
        this.write((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlSerializer.serializeByte$lambda$1(value, arg_0)));
    }

    public void serializeChar(char value) {
        this.write(String.valueOf(value));
    }

    public void serializeShort(short value) {
        this.write((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlSerializer.serializeShort$lambda$2(value, arg_0)));
    }

    public void serializeInt(int value) {
        this.write((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlSerializer.serializeInt$lambda$3(value, arg_0)));
    }

    public void serializeLong(long value) {
        this.write((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlSerializer.serializeLong$lambda$4(value, arg_0)));
    }

    public void serializeFloat(float value) {
        this.write((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlSerializer.serializeFloat$lambda$5(value, arg_0)));
    }

    public void serializeDouble(double value) {
        this.write((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlSerializer.serializeDouble$lambda$6(value, arg_0)));
    }

    public void serializeBigInteger(@NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.write((Function1<? super SdkBuffer, Unit>)((Function1)arg_0 -> FormUrlSerializer.serializeBigInteger$lambda$7(value, arg_0)));
    }

    public void serializeBigDecimal(@NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.write(value.toPlainString());
    }

    public void serializeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.write(value);
    }

    public void serializeInstant(@NotNull Instant value, @NotNull TimestampFormat format) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.serializeString(value.format(format));
    }

    public void serializeByteArray(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.serializeString(Base64Kt.encodeBase64String((byte[])value));
    }

    public void serializeSdkSerializable(@NotNull SdkSerializable value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        value.serialize((Serializer)this);
    }

    public void serializeNull() {
        throw new SerializationException("null values not supported by form-url serializer");
    }

    public void serializeDocument(@Nullable Document value) {
        throw new SerializationException("document values not supported by form-url serializer");
    }

    private static final Unit write$lambda$0(String $value, SdkBuffer $this$write) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        SdkBufferedSink.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)$this$write), (String)FormUrlSerializerKt.access$encode($value), (int)0, (int)0, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit serializeByte$lambda$1(byte $value, SdkBuffer $this$write) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        FormUrlSerializerKt.access$commonWriteNumber($this$write, $value);
        return Unit.INSTANCE;
    }

    private static final Unit serializeShort$lambda$2(short $value, SdkBuffer $this$write) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        FormUrlSerializerKt.access$commonWriteNumber($this$write, $value);
        return Unit.INSTANCE;
    }

    private static final Unit serializeInt$lambda$3(int $value, SdkBuffer $this$write) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        FormUrlSerializerKt.access$commonWriteNumber($this$write, $value);
        return Unit.INSTANCE;
    }

    private static final Unit serializeLong$lambda$4(long $value, SdkBuffer $this$write) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        FormUrlSerializerKt.access$commonWriteNumber($this$write, $value);
        return Unit.INSTANCE;
    }

    private static final Unit serializeFloat$lambda$5(float $value, SdkBuffer $this$write) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        FormUrlSerializerKt.access$commonWriteNumber($this$write, Float.valueOf($value));
        return Unit.INSTANCE;
    }

    private static final Unit serializeDouble$lambda$6(double $value, SdkBuffer $this$write) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        FormUrlSerializerKt.access$commonWriteNumber($this$write, $value);
        return Unit.INSTANCE;
    }

    private static final Unit serializeBigInteger$lambda$7(BigInteger $value, SdkBuffer $this$write) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        FormUrlSerializerKt.access$commonWriteNumber($this$write, (Number)$value);
        return Unit.INSTANCE;
    }
}

