/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.io.internal;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkSink;
import aws.smithy.kotlin.runtime.io.internal.ConvertKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;

@InternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH&\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\tH\u0096\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\tH\u0096\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Laws/smithy/kotlin/runtime/io/internal/SdkSinkObserver;", "Laws/smithy/kotlin/runtime/io/SdkSink;", "delegate", "<init>", "(Laws/smithy/kotlin/runtime/io/SdkSink;)V", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "source", "", "byteCount", "", "write", "(Laws/smithy/kotlin/runtime/io/SdkBuffer;J)V", "", "data", "", "offset", "length", "observe", "([BII)V", "close", "()V", "flush", "Laws/smithy/kotlin/runtime/io/SdkSink;", "Lokio/Buffer$UnsafeCursor;", "cursor", "Lokio/Buffer$UnsafeCursor;", "runtime-core"})
public abstract class SdkSinkObserver
implements SdkSink {
    @NotNull
    private final SdkSink delegate;
    @NotNull
    private final Buffer.UnsafeCursor cursor;

    public SdkSinkObserver(@NotNull SdkSink delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.cursor = new Buffer.UnsafeCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull SdkBuffer source, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Buffer okioBuffer = ConvertKt.toOkio(source);
        okioBuffer.readUnsafe(this.cursor);
        try {
            int toObserve;
            int length = this.cursor.seek(0L);
            for (long remaining = byteCount; length > 0 && remaining > 0L; remaining -= (long)toObserve) {
                byte[] data;
                toObserve = Math.min(length, (int)remaining);
                if (this.cursor.data == null) {
                    byte[] cfr_ignored_0 = this.cursor.data;
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                this.observe(data, this.cursor.start, toObserve);
                length = this.cursor.next();
            }
        }
        finally {
            this.cursor.close();
        }
        this.delegate.write(source, byteCount);
    }

    public abstract void observe(@NotNull byte[] var1, int var2, int var3);

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

