/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.io;

import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkBufferedSink;
import aws.smithy.kotlin.runtime.io.SdkSource;
import aws.smithy.kotlin.runtime.io.internal.ConvertKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0014\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0014J\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010 \u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010%\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b%\u0010$J\u0017\u0010&\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b(\u0010'J\u0017\u0010)\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010+\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b+\u0010*J\u000f\u0010,\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010.\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b.\u0010-J\u000f\u0010/\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b/\u0010-R\u001a\u0010\u0003\u001a\u00020\u00028\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0003\u00100\u001a\u0004\b1\u00102R\u0014\u00105\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u00066"}, d2={"Laws/smithy/kotlin/runtime/io/AbstractBufferedSinkAdapter;", "Laws/smithy/kotlin/runtime/io/SdkBufferedSink;", "Lokio/BufferedSink;", "delegate", "<init>", "(Lokio/BufferedSink;)V", "", "toString", "()Ljava/lang/String;", "", "source", "", "offset", "limit", "", "write", "([BII)V", "Laws/smithy/kotlin/runtime/io/SdkSource;", "", "byteCount", "(Laws/smithy/kotlin/runtime/io/SdkSource;J)V", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "(Laws/smithy/kotlin/runtime/io/SdkBuffer;J)V", "writeAll", "(Laws/smithy/kotlin/runtime/io/SdkSource;)J", "string", "start", "endExclusive", "writeUtf8", "(Ljava/lang/String;II)V", "", "x", "writeByte", "(B)V", "", "writeShort", "(S)V", "writeShortLe", "writeInt", "(I)V", "writeIntLe", "writeLong", "(J)V", "writeLongLe", "flush", "()V", "emit", "close", "Lokio/BufferedSink;", "getDelegate", "()Lokio/BufferedSink;", "getBuffer", "()Laws/smithy/kotlin/runtime/io/SdkBuffer;", "buffer", "runtime-core"})
public abstract class AbstractBufferedSinkAdapter
implements SdkBufferedSink {
    @NotNull
    private final BufferedSink delegate;

    public AbstractBufferedSinkAdapter(@NotNull BufferedSink delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    @NotNull
    protected final BufferedSink getDelegate() {
        return this.delegate;
    }

    @NotNull
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    @NotNull
    public SdkBuffer getBuffer() {
        return ConvertKt.toSdk(this.delegate.getBuffer());
    }

    @Override
    public void write(@NotNull byte[] source, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.delegate.write(source, offset, limit);
    }

    @Override
    public void write(@NotNull SdkSource source, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.delegate.write(ConvertKt.toOkio(source), byteCount);
    }

    @Override
    public void write(@NotNull SdkBuffer source, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.delegate.write(ConvertKt.toOkio(source), byteCount);
    }

    @Override
    public long writeAll(@NotNull SdkSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.delegate.writeAll(ConvertKt.toOkio(source));
    }

    @Override
    public void writeUtf8(@NotNull String string, int start, int endExclusive) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.delegate.writeUtf8(string, start, endExclusive);
    }

    @Override
    public void writeByte(byte x) {
        this.delegate.writeByte((int)x);
    }

    @Override
    public void writeShort(short x) {
        this.delegate.writeShort((int)x);
    }

    @Override
    public void writeShortLe(short x) {
        this.delegate.writeShortLe((int)x);
    }

    @Override
    public void writeInt(int x) {
        this.delegate.writeInt(x);
    }

    @Override
    public void writeIntLe(int x) {
        this.delegate.writeIntLe(x);
    }

    @Override
    public void writeLong(long x) {
        this.delegate.writeLong(x);
    }

    @Override
    public void writeLongLe(long x) {
        this.delegate.writeLongLe(x);
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public void emit() {
        this.delegate.emit();
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

