/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.hashing;

import aws.smithy.kotlin.runtime.ClientException;
import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.businessmetrics.BusinessMetric;
import aws.smithy.kotlin.runtime.businessmetrics.SmithyBusinessMetric;
import aws.smithy.kotlin.runtime.hashing.Crc32;
import aws.smithy.kotlin.runtime.hashing.Crc32c;
import aws.smithy.kotlin.runtime.hashing.HashFunction;
import aws.smithy.kotlin.runtime.hashing.Md5;
import aws.smithy.kotlin.runtime.hashing.Sha1;
import aws.smithy.kotlin.runtime.hashing.Sha256;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001f\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001b\u0010\u0004\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0006\u001a%\u0010\u0004\u001a\u00020\u0002*\u00020\u00022\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u00000\u0007j\u0002`\bH\u0007\u00a2\u0006\u0004\b\u0004\u0010\n\u001a\u0015\u0010\f\u001a\u0004\u0018\u00010\u0000*\u00020\u000bH\u0007\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0013\u0010\u000e\u001a\u00020\u0000*\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u000e\u0010\r\u001a\u0013\u0010\u000f\u001a\u00020\u000b*\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0013\u0010\u000f\u001a\u00020\u000b*\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0011\u001a\u0013\u0010\u0013\u001a\u00020\u0012*\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014\"\u001e\u0010\u0016\u001a\u00020\u0015*\u00020\u00008FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017*\u001c\b\u0007\u0010\u001b\"\b\u0012\u0004\u0012\u00020\u00000\u00072\b\u0012\u0004\u0012\u00020\u00000\u0007B\u0002\b\u001a\u00a8\u0006\u001c"}, d2={"Laws/smithy/kotlin/runtime/hashing/HashFunction;", "fn", "", "input", "hash", "(Laws/smithy/kotlin/runtime/hashing/HashFunction;[B)[B", "([BLaws/smithy/kotlin/runtime/hashing/HashFunction;)[B", "Lkotlin/Function0;", "Laws/smithy/kotlin/runtime/hashing/HashSupplier;", "hashSupplier", "([BLkotlin/jvm/functions/Function0;)[B", "", "toHashFunction", "(Ljava/lang/String;)Laws/smithy/kotlin/runtime/hashing/HashFunction;", "toHashFunctionOrThrow", "resolveChecksumAlgorithmHeaderName", "(Ljava/lang/String;)Ljava/lang/String;", "(Laws/smithy/kotlin/runtime/hashing/HashFunction;)Ljava/lang/String;", "Laws/smithy/kotlin/runtime/businessmetrics/BusinessMetric;", "toBusinessMetric", "(Laws/smithy/kotlin/runtime/hashing/HashFunction;)Laws/smithy/kotlin/runtime/businessmetrics/BusinessMetric;", "", "isSupportedForFlexibleChecksums", "(Laws/smithy/kotlin/runtime/hashing/HashFunction;)Z", "isSupportedForFlexibleChecksums$annotations", "(Laws/smithy/kotlin/runtime/hashing/HashFunction;)V", "Laws/smithy/kotlin/runtime/InternalApi;", "HashSupplier", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nHashFunction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HashFunction.kt\naws/smithy/kotlin/runtime/hashing/HashFunctionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
public final class HashFunctionKt {
    @NotNull
    public static final byte[] hash(@NotNull HashFunction fn, @NotNull byte[] input) {
        HashFunction hashFunction;
        Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        HashFunction $this$hash_u24lambda_u240 = hashFunction = fn;
        boolean bl = false;
        HashFunction.update$default($this$hash_u24lambda_u240, input, 0, 0, 6, null);
        return hashFunction.digest();
    }

    @InternalApi
    @NotNull
    public static final byte[] hash(@NotNull byte[] $this$hash, @NotNull HashFunction fn) {
        Intrinsics.checkNotNullParameter((Object)$this$hash, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
        return HashFunctionKt.hash(fn, $this$hash);
    }

    @InternalApi
    @NotNull
    public static final byte[] hash(@NotNull byte[] $this$hash, @NotNull Function0<? extends HashFunction> hashSupplier) {
        Intrinsics.checkNotNullParameter((Object)$this$hash, (String)"<this>");
        Intrinsics.checkNotNullParameter(hashSupplier, (String)"hashSupplier");
        return HashFunctionKt.hash((HashFunction)hashSupplier.invoke(), $this$hash);
    }

    @InternalApi
    @Nullable
    public static final HashFunction toHashFunction(@NotNull String $this$toHashFunction) {
        HashFunction hashFunction;
        Intrinsics.checkNotNullParameter((Object)$this$toHashFunction, (String)"<this>");
        String string = $this$toHashFunction.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        switch (string) {
            case "crc32": {
                hashFunction = new Crc32();
                break;
            }
            case "crc32c": {
                hashFunction = new Crc32c();
                break;
            }
            case "sha1": {
                hashFunction = new Sha1();
                break;
            }
            case "sha256": {
                hashFunction = new Sha256();
                break;
            }
            case "md5": {
                hashFunction = new Md5();
                break;
            }
            default: {
                hashFunction = null;
            }
        }
        return hashFunction;
    }

    @InternalApi
    @NotNull
    public static final HashFunction toHashFunctionOrThrow(@NotNull String $this$toHashFunctionOrThrow) {
        Intrinsics.checkNotNullParameter((Object)$this$toHashFunctionOrThrow, (String)"<this>");
        HashFunction hashFunction = HashFunctionKt.toHashFunction($this$toHashFunctionOrThrow);
        if (hashFunction == null) {
            throw new ClientException("Checksum algorithm is not supported: " + $this$toHashFunctionOrThrow);
        }
        return hashFunction;
    }

    public static final boolean isSupportedForFlexibleChecksums(@NotNull HashFunction $this$isSupportedForFlexibleChecksums) {
        Intrinsics.checkNotNullParameter((Object)$this$isSupportedForFlexibleChecksums, (String)"<this>");
        HashFunction hashFunction = $this$isSupportedForFlexibleChecksums;
        return hashFunction instanceof Crc32 || hashFunction instanceof Crc32c || hashFunction instanceof Sha1 || hashFunction instanceof Sha256;
    }

    @InternalApi
    public static /* synthetic */ void isSupportedForFlexibleChecksums$annotations(HashFunction hashFunction) {
    }

    @InternalApi
    @NotNull
    public static final String resolveChecksumAlgorithmHeaderName(@NotNull String $this$resolveChecksumAlgorithmHeaderName) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveChecksumAlgorithmHeaderName, (String)"<this>");
        return HashFunctionKt.resolveChecksumAlgorithmHeaderName(HashFunctionKt.toHashFunctionOrThrow($this$resolveChecksumAlgorithmHeaderName));
    }

    @InternalApi
    @NotNull
    public static final String resolveChecksumAlgorithmHeaderName(@NotNull HashFunction $this$resolveChecksumAlgorithmHeaderName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$resolveChecksumAlgorithmHeaderName, (String)"<this>");
        String prefix = "x-amz-checksum-";
        HashFunction hashFunction = $this$resolveChecksumAlgorithmHeaderName;
        if (hashFunction instanceof Crc32) {
            string = prefix + "crc32";
        } else if (hashFunction instanceof Crc32c) {
            string = prefix + "crc32c";
        } else if (hashFunction instanceof Sha1) {
            string = prefix + "sha1";
        } else if (hashFunction instanceof Sha256) {
            string = prefix + "sha256";
        } else if (hashFunction instanceof Md5) {
            string = "Content-MD5";
        } else {
            throw new ClientException("Checksum algorithm is not supported: " + Reflection.getOrCreateKotlinClass($this$resolveChecksumAlgorithmHeaderName.getClass()).getSimpleName());
        }
        return string;
    }

    @InternalApi
    @NotNull
    public static final BusinessMetric toBusinessMetric(@NotNull HashFunction $this$toBusinessMetric) {
        BusinessMetric businessMetric;
        Intrinsics.checkNotNullParameter((Object)$this$toBusinessMetric, (String)"<this>");
        HashFunction hashFunction = $this$toBusinessMetric;
        if (hashFunction instanceof Crc32) {
            businessMetric = SmithyBusinessMetric.FLEXIBLE_CHECKSUMS_REQ_CRC32;
        } else if (hashFunction instanceof Crc32c) {
            businessMetric = SmithyBusinessMetric.FLEXIBLE_CHECKSUMS_REQ_CRC32C;
        } else if (hashFunction instanceof Sha1) {
            businessMetric = SmithyBusinessMetric.FLEXIBLE_CHECKSUMS_REQ_SHA1;
        } else if (hashFunction instanceof Sha256) {
            businessMetric = SmithyBusinessMetric.FLEXIBLE_CHECKSUMS_REQ_SHA256;
        } else {
            throw new IllegalStateException("Checksum was calculated using an unsupported hash function: " + Reflection.getOrCreateKotlinClass($this$toBusinessMetric.getClass()).getSimpleName());
        }
        return businessMetric;
    }

    @InternalApi
    public static /* synthetic */ void HashSupplier$annotations() {
    }
}

