/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.content;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0010\u000f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u0015J\u001a\u0010\"\u001a\u00020!2\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0096\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0018\u0010$\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b$\u0010%J\u0018\u0010&\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b&\u0010%J\u0018\u0010'\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b'\u0010(J\r\u0010)\u001a\u00020\u0007\u00a2\u0006\u0004\b)\u0010*R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010+\u001a\u0004\b,\u0010\u001dR\u0014\u0010.\u001a\u00020-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/\u00a8\u00060"}, d2={"Laws/smithy/kotlin/runtime/content/BigInteger;", "", "", "", "value", "<init>", "(Ljava/lang/String;)V", "", "bytes", "([B)V", "", "toByte", "()B", "", "toLong", "()J", "", "toShort", "()S", "", "toInt", "()I", "", "toFloat", "()F", "", "toDouble", "()D", "toString", "()Ljava/lang/String;", "hashCode", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "plus", "(Laws/smithy/kotlin/runtime/content/BigInteger;)Laws/smithy/kotlin/runtime/content/BigInteger;", "minus", "compareTo", "(Laws/smithy/kotlin/runtime/content/BigInteger;)I", "toByteArray", "()[B", "Ljava/lang/String;", "getValue", "Ljava/math/BigInteger;", "delegate", "Ljava/math/BigInteger;", "runtime-core"})
public final class BigInteger
extends Number
implements Comparable<BigInteger> {
    @NotNull
    private final String value;
    @NotNull
    private final java.math.BigInteger delegate;

    public BigInteger(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        this.delegate = new java.math.BigInteger(this.value);
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    public BigInteger(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        String string = new java.math.BigInteger(bytes).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this(string);
    }

    public byte toByte() {
        return this.delegate.byteValue();
    }

    public long toLong() {
        return this.delegate.longValue();
    }

    public short toShort() {
        return this.delegate.shortValue();
    }

    public int toInt() {
        return this.delegate.intValue();
    }

    public float toFloat() {
        return this.delegate.floatValue();
    }

    public double toDouble() {
        return this.delegate.doubleValue();
    }

    @NotNull
    public String toString() {
        String string = this.delegate.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof BigInteger && Intrinsics.areEqual((Object)this.delegate, (Object)((BigInteger)other).delegate);
    }

    @NotNull
    public final BigInteger plus(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        java.math.BigInteger bigInteger = this.delegate.add(other.delegate);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"add(...)");
        String string = bigInteger.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new BigInteger(string);
    }

    @NotNull
    public final BigInteger minus(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        java.math.BigInteger bigInteger = this.delegate.subtract(other.delegate);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"subtract(...)");
        String string = bigInteger.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new BigInteger(string);
    }

    @Override
    public int compareTo(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.delegate.compareTo(other.delegate);
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] byArray = this.delegate.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }
}

