/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.collections;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.collections.CaseInsensitiveMap;
import aws.smithy.kotlin.runtime.collections.ValuesMap;
import aws.smithy.kotlin.runtime.collections.ValuesMapImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010&\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\n\n\u0002\u0010%\n\u0002\b\u0004\b\u0017\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u000e\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000e\u0010\u0011J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J%\u0010\u0018\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\u00170\u0012\u00a2\u0006\u0004\b\u0018\u0010\u0014J \u0010\u001a\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u001a\u0010\u001d\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0004\b\u001f\u0010\u001bJ\u001b\u0010\"\u001a\u00020\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000 \u00a2\u0006\u0004\b\"\u0010#J\u001b\u0010$\u001a\u00020\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000 \u00a2\u0006\u0004\b$\u0010#J#\u0010\"\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\t2\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000%\u00a2\u0006\u0004\b\"\u0010'J#\u0010$\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\t2\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000%\u00a2\u0006\u0004\b$\u0010'J\u001d\u0010)\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010(2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b)\u0010\rJ\r\u0010*\u001a\u00020\u0019\u00a2\u0006\u0004\b*\u0010+J\u001d\u0010)\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0004\b)\u0010\u0011J\r\u0010,\u001a\u00020\u0019\u00a2\u0006\u0004\b,\u0010+J\u0015\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0016\u00a2\u0006\u0004\b-\u0010.J%\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000(2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b/\u00100R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u00101\u001a\u0004\b2\u0010\u0016R,\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000(038\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b&\u00104\u001a\u0004\b5\u00106\u00a8\u00067"}, d2={"Laws/smithy/kotlin/runtime/collections/ValuesMapBuilder;", "T", "", "", "caseInsensitiveName", "", "size", "<init>", "(ZI)V", "", "name", "", "getAll", "(Ljava/lang/String;)Ljava/util/List;", "contains", "(Ljava/lang/String;)Z", "value", "(Ljava/lang/String;Ljava/lang/Object;)Z", "", "names", "()Ljava/util/Set;", "isEmpty", "()Z", "", "entries", "", "set", "(Ljava/lang/String;Ljava/lang/Object;)V", "setMissing", "get", "(Ljava/lang/String;)Ljava/lang/Object;", "append", "Laws/smithy/kotlin/runtime/collections/ValuesMap;", "valuesMap", "appendAll", "(Laws/smithy/kotlin/runtime/collections/ValuesMap;)V", "appendMissing", "", "values", "(Ljava/lang/String;Ljava/lang/Iterable;)V", "", "remove", "removeKeysWithNoEntries", "()V", "clear", "build", "()Laws/smithy/kotlin/runtime/collections/ValuesMap;", "ensureListForKey", "(Ljava/lang/String;I)Ljava/util/List;", "Z", "getCaseInsensitiveName", "", "Ljava/util/Map;", "getValues", "()Ljava/util/Map;", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nValuesMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValuesMap.kt\naws/smithy/kotlin/runtime/collections/ValuesMapBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1869#2,2:180\n774#2:182\n865#2,2:183\n536#3:185\n521#3,6:186\n1#4:192\n*S KotlinDebug\n*F\n+ 1 ValuesMap.kt\naws/smithy/kotlin/runtime/collections/ValuesMapBuilder\n*L\n150#1:180,2\n159#1:182\n159#1:183,2\n165#1:185\n165#1:186,6\n*E\n"})
public class ValuesMapBuilder<T> {
    private final boolean caseInsensitiveName;
    @NotNull
    private final Map<String, List<T>> values;

    public ValuesMapBuilder(boolean caseInsensitiveName, int size) {
        this.caseInsensitiveName = caseInsensitiveName;
        this.values = this.caseInsensitiveName ? (Map)new CaseInsensitiveMap() : (Map)new LinkedHashMap(size);
    }

    public /* synthetic */ ValuesMapBuilder(boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            n = 8;
        }
        this(bl, n);
    }

    public final boolean getCaseInsensitiveName() {
        return this.caseInsensitiveName;
    }

    @NotNull
    protected final Map<String, List<T>> getValues() {
        return this.values;
    }

    @Nullable
    public final List<T> getAll(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.values.get(name);
    }

    public final boolean contains(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.values.containsKey(name);
    }

    public final boolean contains(@NotNull String name, T value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List<T> list = this.values.get(name);
        return list != null ? list.contains(value) : false;
    }

    @NotNull
    public final Set<String> names() {
        return this.values.keySet();
    }

    public final boolean isEmpty() {
        return this.values.isEmpty();
    }

    @NotNull
    public final Set<Map.Entry<String, List<T>>> entries() {
        return this.values.entrySet();
    }

    public final void set(@NotNull String name, T value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List<T> list = this.ensureListForKey(name, 1);
        list.clear();
        list.add(value);
    }

    public final void setMissing(@NotNull String name, T value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.values.containsKey(name)) {
            this.set(name, value);
        }
    }

    @Nullable
    public final T get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List<T> list = this.getAll(name);
        return (T)(list != null ? CollectionsKt.firstOrNull(list) : null);
    }

    public final void append(@NotNull String name, T value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.ensureListForKey(name, 1).add(value);
    }

    public final void appendAll(@NotNull ValuesMap<T> valuesMap) {
        Intrinsics.checkNotNullParameter(valuesMap, (String)"valuesMap");
        valuesMap.forEach((arg_0, arg_1) -> ValuesMapBuilder.appendAll$lambda$0(this, arg_0, arg_1));
    }

    public final void appendMissing(@NotNull ValuesMap<T> valuesMap) {
        Intrinsics.checkNotNullParameter(valuesMap, (String)"valuesMap");
        valuesMap.forEach((arg_0, arg_1) -> ValuesMapBuilder.appendMissing$lambda$1(this, arg_0, arg_1));
    }

    public final void appendAll(@NotNull String name, @NotNull Iterable<? extends T> values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Collection collection = values instanceof Collection ? (Collection)values : null;
        List<T> list = this.ensureListForKey(name, collection != null ? collection.size() : 2);
        boolean bl = false;
        Iterable<T> $this$forEach$iv = values;
        boolean $i$f$forEach = false;
        Iterator<T> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            T element$iv;
            T value = element$iv = iterator2.next();
            boolean bl2 = false;
            list.add(value);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void appendMissing(@NotNull String name, @NotNull Iterable<? extends T> values) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Collection<Object> collection = this.values.get(name);
        if (collection == null || (collection = CollectionsKt.toSet((Iterable)collection)) == null) {
            collection = SetsKt.emptySet();
        }
        Collection<Object> existing = collection;
        Iterable<? extends T> iterable = values;
        String string = name;
        ValuesMapBuilder valuesMapBuilder = this;
        boolean $i$f$filter = false;
        void var6_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(!existing.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        valuesMapBuilder.appendAll(string, list);
    }

    @Nullable
    public final List<T> remove(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.values.remove(name);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeKeysWithNoEntries() {
        void $this$filterTo$iv$iv;
        Map<String, List<T>> $this$filter$iv = this.values;
        boolean $i$f$filter = false;
        Map<String, List<T>> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!((List)it.getValue()).isEmpty()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Iterator iterator3 = destination$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            String k = (String)iterator3.next().getKey();
            this.remove(k);
        }
    }

    public final boolean remove(@NotNull String name, T value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List<T> list = this.values.get(name);
        return list != null ? list.remove(value) : false;
    }

    public final void clear() {
        this.values.clear();
    }

    @NotNull
    public ValuesMap<T> build() {
        return new ValuesMapImpl<T>(this.caseInsensitiveName, this.values);
    }

    private final List<T> ensureListForKey(String name, int size) {
        List list = this.values.get(name);
        if (list == null) {
            ArrayList arrayList;
            ArrayList it = arrayList = new ArrayList(size);
            boolean bl = false;
            this.values.put(name, it);
            list = arrayList;
        }
        return list;
    }

    private static final Unit appendAll$lambda$0(ValuesMapBuilder this$0, String name, List values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this$0.appendAll(name, values);
        return Unit.INSTANCE;
    }

    private static final Unit appendMissing$lambda$1(ValuesMapBuilder this$0, String name, List values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this$0.appendMissing(name, values);
        return Unit.INSTANCE;
    }

    public ValuesMapBuilder() {
        this(false, 0, 3, null);
    }
}

