/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.okhttp;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.http.engine.ProxyConfig;
import aws.smithy.kotlin.runtime.http.engine.ProxySelector;
import aws.smithy.kotlin.runtime.net.Host;
import aws.smithy.kotlin.runtime.net.Scheme;
import aws.smithy.kotlin.runtime.net.url.Url;
import aws.smithy.kotlin.runtime.net.url.UserInfo;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Authenticator;
import okhttp3.Challenge;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Laws/smithy/kotlin/runtime/http/engine/okhttp/OkHttpProxyAuthenticator;", "Lokhttp3/Authenticator;", "selector", "Laws/smithy/kotlin/runtime/http/engine/ProxySelector;", "<init>", "(Laws/smithy/kotlin/runtime/http/engine/ProxySelector;)V", "authenticate", "Lokhttp3/Request;", "route", "Lokhttp3/Route;", "response", "Lokhttp3/Response;", "http-client-engine-okhttp"})
@SourceDebugExtension(value={"SMAP\nOkHttpUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpUtils.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/OkHttpProxyAuthenticator\n+ 2 Url.kt\naws/smithy/kotlin/runtime/net/url/Url$Companion\n*L\n1#1,265:1\n39#2:266\n*S KotlinDebug\n*F\n+ 1 OkHttpUtils.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/OkHttpProxyAuthenticator\n*L\n133#1:266\n*E\n"})
public final class OkHttpProxyAuthenticator
implements Authenticator {
    @NotNull
    private final ProxySelector selector;

    public OkHttpProxyAuthenticator(@NotNull ProxySelector selector) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        this.selector = selector;
    }

    @Nullable
    public Request authenticate(@Nullable Route route, @NotNull Response response) {
        Url.Builder builder;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (response.request().header("Proxy-Authorization") != null) {
            return null;
        }
        HttpUrl it = response.request().url();
        boolean bl = false;
        Url.Companion this_$iv = Url.Companion;
        boolean $i$f$invoke = false;
        Url.Builder $this$authenticate_u24lambda_u241_u24lambda_u240 = builder = new Url.Builder();
        boolean bl2 = false;
        $this$authenticate_u24lambda_u241_u24lambda_u240.setScheme(new Scheme(it.scheme(), it.port()));
        $this$authenticate_u24lambda_u241_u24lambda_u240.setHost(Host.Companion.parse(it.host()));
        $this$authenticate_u24lambda_u241_u24lambda_u240.setPort(Integer.valueOf(it.port()));
        Url url = builder.build();
        ProxyConfig proxyConfig = this.selector.select(url);
        UserInfo userInfo = proxyConfig instanceof ProxyConfig.Http ? ((ProxyConfig.Http)proxyConfig).getUrl().getUserInfo() : null;
        if (userInfo == null) {
            return null;
        }
        UserInfo userInfo2 = userInfo;
        for (Challenge challenge : response.challenges()) {
            String string = challenge.scheme().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (!Intrinsics.areEqual((Object)string, (Object)"okhttp-preemptive") && !Intrinsics.areEqual((Object)challenge.scheme(), (Object)"Basic")) continue;
            return response.request().newBuilder().header("Proxy-Authorization", Credentials.basic$default((String)userInfo2.getUserName().getDecoded(), (String)userInfo2.getPassword().getDecoded(), null, (int)4, null)).build();
        }
        return null;
    }
}

