/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.okhttp;

import aws.smithy.kotlin.runtime.http.engine.okhttp.SdkRequestTag;
import aws.smithy.kotlin.runtime.telemetry.logging.CoroutineContextLogExtKt;
import aws.smithy.kotlin.runtime.telemetry.logging.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.internal._UtilCommonKt;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u001e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010\u001aR\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Laws/smithy/kotlin/runtime/http/engine/okhttp/ConnectionMonitoringEventListener;", "Lokhttp3/EventListener;", "Ljava/io/Closeable;", "Laws/smithy/kotlin/runtime/io/Closeable;", "pollInterval", "Lkotlin/time/Duration;", "<init>", "(JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "monitorScope", "Lkotlinx/coroutines/CoroutineScope;", "monitors", "Ljava/util/concurrent/ConcurrentHashMap;", "Lokhttp3/Connection;", "Lkotlinx/coroutines/Job;", "close", "", "callContext", "Lkotlin/coroutines/CoroutineContext;", "Lokhttp3/Call;", "connectionAcquired", "call", "connection", "connectionReleased", "doMonitor", "conn", "(Lokhttp3/Connection;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "http-client-engine-okhttp"})
@SourceDebugExtension(value={"SMAP\nConnectionMonitoringEventListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionMonitoringEventListener.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/ConnectionMonitoringEventListener\n+ 2 CoroutineContextLogExt.kt\naws/smithy/kotlin/runtime/telemetry/logging/CoroutineContextLogExtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,137:1\n258#2:138\n259#2:140\n258#2:145\n259#2:147\n258#2:148\n259#2:150\n1#3:139\n1#3:146\n1#3:149\n24#4:141\n63#4,3:142\n*S KotlinDebug\n*F\n+ 1 ConnectionMonitoringEventListener.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/ConnectionMonitoringEventListener\n*L\n58#1:138\n58#1:140\n81#1:145\n81#1:147\n90#1:148\n90#1:150\n58#1:139\n81#1:146\n90#1:149\n62#1:141\n62#1:142,3\n*E\n"})
public final class ConnectionMonitoringEventListener
extends EventListener
implements Closeable {
    private final long pollInterval;
    @NotNull
    private final CoroutineScope monitorScope;
    @NotNull
    private final ConcurrentHashMap<Connection, Job> monitors;

    private ConnectionMonitoringEventListener(long pollInterval) {
        this.pollInterval = pollInterval;
        this.monitorScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.monitors = new ConcurrentHashMap();
    }

    @Override
    public void close() {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ConnectionMonitoringEventListener this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$runBlocking;
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineContext.Element element = ConnectionMonitoringEventListener.access$getMonitorScope$p(this.this$0).getCoroutineContext().get((CoroutineContext.Key)Job.Key);
                        if (element == null) {
                            boolean bl = false;
                            String string = "Connection idle monitor scope cannot be cancelled because it does not have a job: " + $this$runBlocking;
                            throw new IllegalArgumentException(string.toString());
                        }
                        Job monitorJob = (Job)element;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$runBlocking);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)monitorJob);
                        this.label = 1;
                        Object object2 = JobKt.cancelAndJoin((Job)monitorJob, (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Job monitorJob = (Job)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final CoroutineContext callContext(Call $this$callContext) {
        CoroutineContext coroutineContext;
        SdkRequestTag sdkRequestTag = (SdkRequestTag)$this$callContext.request().tag(SdkRequestTag.class);
        return sdkRequestTag != null && (coroutineContext = sdkRequestTag.getCallContext()) != null ? coroutineContext : (CoroutineContext)Dispatchers.getIO();
    }

    public void connectionAcquired(@NotNull Call call, @NotNull Connection connection) {
        block1: {
            CoroutineContext context;
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            super.connectionAcquired(call, connection);
            Job job = this.monitors.remove(connection);
            if (job == null) break block1;
            Job monitor2 = job;
            boolean bl = false;
            CoroutineContext $this$logger$iv = context = this.callContext(call);
            boolean $i$f$logger = false;
            String string = Reflection.getOrCreateKotlinClass(ConnectionMonitoringEventListener.class).getQualifiedName();
            if (string == null) {
                boolean $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22 = false;
                String $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22 = "logger<T> cannot be used on an anonymous object";
                throw new IllegalArgumentException($i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22.toString());
            }
            String sourceComponent$iv = string;
            Logger logger = CoroutineContextLogExtKt.logger((CoroutineContext)$this$logger$iv, (String)sourceComponent$iv);
            Logger.trace$default((Logger)logger, null, () -> ConnectionMonitoringEventListener.connectionAcquired$lambda$3$lambda$0(connection), (int)1, null);
            boolean $i$f$measureTime = false;
            TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
            boolean bl2 = false;
            BuildersKt.runBlocking((CoroutineContext)context, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(monitor2, null){
                int label;
                final /* synthetic */ Job $monitor;
                {
                    this.$monitor = $monitor;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = JobKt.cancelAndJoin((Job)this.$monitor, (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            long cancelTime2 = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
            Logger.trace$default((Logger)logger, null, () -> ConnectionMonitoringEventListener.connectionAcquired$lambda$3$lambda$2(connection, cancelTime2), (int)1, null);
        }
    }

    public void connectionReleased(@NotNull Call call, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        super.connectionReleased(call, connection);
        int connId = System.identityHashCode(connection);
        CoroutineContext callContext = this.callContext(call);
        Job monitor2 = BuildersKt.launch$default((CoroutineScope)this.monitorScope, (CoroutineContext)((CoroutineContext)new CoroutineName("okhttp-conn-monitor-for-" + connId)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, connection, callContext, null){
            int label;
            final /* synthetic */ ConnectionMonitoringEventListener this$0;
            final /* synthetic */ Connection $connection;
            final /* synthetic */ CoroutineContext $callContext;
            {
                this.this$0 = $receiver;
                this.$connection = $connection;
                this.$callContext = $callContext;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = ConnectionMonitoringEventListener.access$doMonitor(this.this$0, this.$connection, this.$callContext, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        CoroutineContext $this$logger$iv = callContext;
        boolean $i$f$logger = false;
        String string = Reflection.getOrCreateKotlinClass(ConnectionMonitoringEventListener.class).getQualifiedName();
        if (string == null) {
            boolean bl = false;
            String string2 = "logger<T> cannot be used on an anonymous object";
            throw new IllegalArgumentException(string2.toString());
        }
        String sourceComponent$iv = string;
        Logger.trace$default((Logger)CoroutineContextLogExtKt.logger((CoroutineContext)$this$logger$iv, (String)sourceComponent$iv), null, () -> ConnectionMonitoringEventListener.connectionReleased$lambda$4(monitor2, connection), (int)1, null);
        ((Map)this.monitors).put(connection, monitor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object doMonitor(Connection conn, CoroutineContext callContext, Continuation<? super Unit> $completion) {
        Source $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22323232322;
        CoroutineContext $this$logger$iv = callContext;
        boolean $i$f$logger = false;
        String string = Reflection.getOrCreateKotlinClass(ConnectionMonitoringEventListener.class).getQualifiedName();
        if (string == null) {
            boolean $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22323232322 = false;
            String $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22323232322 = "logger<T> cannot be used on an anonymous object";
            throw new IllegalArgumentException($i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22323232322.toString());
        }
        String sourceComponent$iv = string;
        Logger logger = CoroutineContextLogExtKt.logger((CoroutineContext)$this$logger$iv, (String)sourceComponent$iv);
        Socket socket = conn.socket();
        try {
            $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22323232322 = Okio.source((Socket)socket);
        }
        catch (SocketException socketException) {
            Logger.trace$default((Logger)logger, null, () -> ConnectionMonitoringEventListener.doMonitor$lambda$5(conn), (int)1, null);
            return Unit.INSTANCE;
        }
        BufferedSource source = Okio.buffer((Source)$i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22323232322).peek();
        Logger.trace$default((Logger)logger, null, () -> ConnectionMonitoringEventListener.doMonitor$lambda$6(conn), (int)1, null);
        boolean resetTimeout = true;
        int oldTimeout = socket.getSoTimeout();
        socket.setSoTimeout((int)Duration.getInWholeMilliseconds-impl((long)this.pollInterval));
        while (JobKt.isActive((CoroutineContext)$completion.getContext())) {
            try {
                Logger.trace$default((Logger)logger, null, () -> ConnectionMonitoringEventListener.doMonitor$lambda$7(conn), (int)1, null);
                source.readByte();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                Logger.trace$default((Logger)logger, null, () -> ConnectionMonitoringEventListener.doMonitor$lambda$8(conn), (int)1, null);
            }
            catch (IOException iOException) {
                Logger.trace$default((Logger)logger, null, () -> ConnectionMonitoringEventListener.doMonitor$lambda$9(conn), (int)1, null);
                _UtilCommonKt.closeQuietly((Closeable)socket);
                resetTimeout = false;
                return Unit.INSTANCE;
            }
        }
        Logger.trace$default((Logger)logger, null, ConnectionMonitoringEventListener::doMonitor$lambda$10, (int)1, null);
        Logger.trace$default((Logger)logger, null, ConnectionMonitoringEventListener::doMonitor$lambda$12, (int)1, null);
        try {
            conn.socket().setSoTimeout(oldTimeout);
            Logger.trace$default((Logger)logger, null, ConnectionMonitoringEventListener::doMonitor$lambda$13, (int)1, null);
            return Unit.INSTANCE;
        }
        catch (Throwable e) {
            logger.warn(e, () -> ConnectionMonitoringEventListener.doMonitor$lambda$14(conn));
            return Unit.INSTANCE;
        }
        catch (Throwable e) {
            try {
                logger.warn(e, () -> ConnectionMonitoringEventListener.doMonitor$lambda$11(conn));
                return Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (resetTimeout) {
                    Logger.trace$default((Logger)logger, null, ConnectionMonitoringEventListener::doMonitor$lambda$12, (int)1, null);
                    try {
                        conn.socket().setSoTimeout(oldTimeout);
                        Logger.trace$default((Logger)logger, null, ConnectionMonitoringEventListener::doMonitor$lambda$13, (int)1, null);
                    }
                    catch (Throwable e2) {
                        logger.warn(e2, () -> ConnectionMonitoringEventListener.doMonitor$lambda$14(conn));
                    }
                }
            }
        }
    }

    private static final String connectionAcquired$lambda$3$lambda$0(Connection $connection) {
        return "Cancel monitoring for " + $connection;
    }

    private static final String connectionAcquired$lambda$3$lambda$2(Connection $connection, long $cancelTime) {
        return "Monitoring canceled for " + $connection + " in " + Duration.toString-impl((long)$cancelTime);
    }

    private static final String connectionReleased$lambda$4(Job $monitor, Connection $connection) {
        return "Launched coroutine " + $monitor + " to monitor " + $connection;
    }

    private static final String doMonitor$lambda$5(Connection $conn) {
        return "Socket for " + $conn + " closed before monitoring started. Skipping polling loop.";
    }

    private static final String doMonitor$lambda$6(Connection $conn) {
        return "Commence socket monitoring for " + $conn;
    }

    private static final String doMonitor$lambda$7(Connection $conn) {
        return "Polling socket for " + $conn;
    }

    private static final String doMonitor$lambda$8(Connection $conn) {
        return "Socket still alive for " + $conn;
    }

    private static final String doMonitor$lambda$9(Connection $conn) {
        return "Socket closed remotely for " + $conn;
    }

    private static final String doMonitor$lambda$10() {
        return "Monitoring coroutine has been cancelled. Ending polling loop.";
    }

    private static final String doMonitor$lambda$11(Connection $conn) {
        return "Failed to poll " + $conn + ". Ending polling loop. Connection may be unstable now.";
    }

    private static final String doMonitor$lambda$12() {
        return "Attempting to reset soTimeout...";
    }

    private static final String doMonitor$lambda$13() {
        return "soTimeout reset.";
    }

    private static final String doMonitor$lambda$14(Connection $conn) {
        return "Failed to reset socket timeout on " + $conn + ". Connection may be unstable now.";
    }

    public /* synthetic */ ConnectionMonitoringEventListener(long pollInterval, DefaultConstructorMarker $constructor_marker) {
        this(pollInterval);
    }

    public static final /* synthetic */ CoroutineScope access$getMonitorScope$p(ConnectionMonitoringEventListener $this) {
        return $this.monitorScope;
    }

    public static final /* synthetic */ Object access$doMonitor(ConnectionMonitoringEventListener $this, Connection conn, CoroutineContext callContext, Continuation $completion) {
        return $this.doMonitor(conn, callContext, (Continuation<? super Unit>)$completion);
    }
}

