/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.awsprotocol.eventstream;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.HeaderValue;
import aws.smithy.kotlin.runtime.io.SdkBufferedSink;
import aws.smithy.kotlin.runtime.io.SdkBufferedSource;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Laws/smithy/kotlin/runtime/awsprotocol/eventstream/Header;", "", "name", "", "value", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue;", "<init>", "(Ljava/lang/String;Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue;)V", "getName", "()Ljava/lang/String;", "getValue", "()Laws/smithy/kotlin/runtime/awsprotocol/eventstream/HeaderValue;", "encode", "", "dest", "Laws/smithy/kotlin/runtime/io/SdkBufferedSink;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "aws-event-stream"})
@SourceDebugExtension(value={"SMAP\nHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Header.kt\naws/smithy/kotlin/runtime/awsprotocol/eventstream/Header\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class Header {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final HeaderValue value;

    public Header(@NotNull String name, @NotNull HeaderValue value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.name = name;
        this.value = value;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final HeaderValue getValue() {
        return this.value;
    }

    public final void encode(@NotNull SdkBufferedSink dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        byte[] bytes = StringsKt.encodeToByteArray((String)this.name);
        if (!(bytes.length < 255)) {
            boolean bl = false;
            String string = "Header name too long";
            throw new IllegalStateException(string.toString());
        }
        dest.writeByte((byte)bytes.length);
        SdkBufferedSink.write$default((SdkBufferedSink)dest, (byte[])bytes, (int)0, (int)0, (int)6, null);
        this.value.encode(dest);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final HeaderValue component2() {
        return this.value;
    }

    @NotNull
    public final Header copy(@NotNull String name, @NotNull HeaderValue value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new Header(name, value);
    }

    public static /* synthetic */ Header copy$default(Header header, String string, HeaderValue headerValue, int n, Object object) {
        if ((n & 1) != 0) {
            string = header.name;
        }
        if ((n & 2) != 0) {
            headerValue = header.value;
        }
        return header.copy(string, headerValue);
    }

    @NotNull
    public String toString() {
        return "Header(name=" + this.name + ", value=" + this.value + ')';
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.value.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Header)) {
            return false;
        }
        Header header = (Header)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)header.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.value, (Object)header.value);
    }

    @InternalApi
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Laws/smithy/kotlin/runtime/awsprotocol/eventstream/Header$Companion;", "", "<init>", "()V", "decode", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/Header;", "source", "Laws/smithy/kotlin/runtime/io/SdkBufferedSource;", "aws-event-stream"})
    @SourceDebugExtension(value={"SMAP\nHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Header.kt\naws/smithy/kotlin/runtime/awsprotocol/eventstream/Header$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Header decode(@NotNull SdkBufferedSource source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!source.request(2L)) {
                boolean $i$a$-check-Header$Companion$decode$42 = false;
                String $i$a$-check-Header$Companion$decode$42 = "Invalid frame header; require at least 2 bytes";
                throw new IllegalStateException($i$a$-check-Header$Companion$decode$42.toString());
            }
            byte nameLen = source.readByte();
            if (!(nameLen > 0)) {
                boolean $i$a$-check-Header$Companion$decode$52 = false;
                String $i$a$-check-Header$Companion$decode$52 = "Invalid header name length: " + nameLen;
                throw new IllegalStateException($i$a$-check-Header$Companion$decode$52.toString());
            }
            if (!source.request((long)nameLen)) {
                boolean $i$a$-check-Header$Companion$decode$62 = false;
                String $i$a$-check-Header$Companion$decode$62 = "Not enough bytes to read header name; needed: " + nameLen + "; remaining: " + source.getBuffer().getSize();
                throw new IllegalStateException($i$a$-check-Header$Companion$decode$62.toString());
            }
            String name = source.readUtf8((long)nameLen);
            HeaderValue value = HeaderValue.Companion.decode(source);
            return new Header(name, value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

