/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.maven;

import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.core.pactbroker.PublishConfiguration;
import au.com.dius.pact.core.pactbroker.RequestFailedException;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.provider.maven.PactBaseMojo;
import au.com.dius.pact.provider.maven.PactPublishMojo;
import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Ok;
import com.github.michaelbull.result.Result;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u0010\u001a\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0006\"\u0004\b\r\u0010\bR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lau/com/dius/pact/provider/maven/PactPublishMojo;", "Lau/com/dius/pact/provider/maven/PactBaseMojo;", "()V", "branchName", "", "getBranchName", "()Ljava/lang/String;", "setBranchName", "(Ljava/lang/String;)V", "brokerClient", "Lau/com/dius/pact/core/pactbroker/PactBrokerClient;", "buildUrl", "getBuildUrl", "setBuildUrl", "excludes", "", "pactDirectory", "projectVersion", "skipPactPublish", "", "tags", "trimSnapshot", "calculateTags", "", "execute", "", "pactFileIsExcluded", "exclusions", "Lkotlin/text/Regex;", "pactFile", "Ljava/io/File;", "maven"})
@Mojo(name="publish")
public class PactPublishMojo
extends PactBaseMojo {
    @Parameter(defaultValue="false")
    private boolean skipPactPublish;
    @Parameter(required=true, defaultValue="${project.version}", property="pact.projectVersion")
    private String projectVersion;
    @Parameter(defaultValue="false", property="pact.trimSnapshot")
    private boolean trimSnapshot;
    @Parameter(defaultValue="${project.build.directory}/pacts", property="pact.pactDirectory")
    private String pactDirectory;
    private PactBrokerClient brokerClient;
    @Parameter
    private List<String> tags;
    @Parameter
    private List<String> excludes;
    @Parameter
    @Nullable
    private String branchName;
    @Parameter
    @Nullable
    private String buildUrl;

    @Nullable
    public final String getBranchName() {
        return this.branchName;
    }

    public final void setBranchName(@Nullable String string) {
        this.branchName = string;
    }

    @Nullable
    public final String getBuildUrl() {
        return this.buildUrl;
    }

    public final void setBuildUrl(@Nullable String string) {
        this.buildUrl = string;
    }

    /*
     * WARNING - void declaration
     */
    public void execute() {
        String string;
        Object object;
        if (this.skipPactPublish) {
            String string2 = "'skipPactPublish' is set to true, skipping uploading of pacts";
            boolean bl = false;
            System.out.println((Object)string2);
            return;
        }
        CharSequence charSequence = this.getPactBrokerUrl();
        boolean bl = false;
        boolean bl2 = false;
        if ((charSequence == null || charSequence.length() == 0) && this.brokerClient == null) {
            throw (Throwable)new MojoExecutionException("pactBrokerUrl is required");
        }
        String snapShotDefinitionString = "-SNAPSHOT";
        if (this.trimSnapshot) {
            String string3 = this.projectVersion;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
            }
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)snapShotDefinitionString, (boolean)false, (int)2, null)) {
                Regex snapshotRegex = new Regex(".*(" + snapShotDefinitionString + ')');
                String string4 = this.projectVersion;
                if (string4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
                }
                String string5 = string4;
                String string6 = this.projectVersion;
                if (string6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
                }
                MatchResult matchResult = Regex.find$default((Regex)snapshotRegex, (CharSequence)string6, (int)0, (int)2, null);
                if (matchResult == null) {
                    Intrinsics.throwNpe();
                }
                MatchGroup matchGroup = matchResult.getGroups().get(1);
                if (matchGroup == null) {
                    Intrinsics.throwNpe();
                }
                IntRange intRange = matchGroup.getRange();
                object = this;
                boolean bl3 = false;
                String string7 = string5;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                ((PactPublishMojo)((Object)object)).projectVersion = string = ((Object)StringsKt.removeRange((CharSequence)string7, (IntRange)intRange)).toString();
            }
        }
        if (this.brokerClient == null) {
            String string8 = this.getPactBrokerUrl();
            if (string8 == null) {
                Intrinsics.throwNpe();
            }
            this.brokerClient = new PactBrokerClient(string8, this.brokerClientOptions(), this.brokerClientConfig());
        }
        String string9 = this.pactDirectory;
        if (string9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pactDirectory");
        }
        File pactDirectory = new File(string9);
        List<String> tagsToPublish = this.calculateTags();
        String string10 = this.projectVersion;
        if (string10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
        }
        PublishConfiguration publishConfiguration = new PublishConfiguration(string10, tagsToPublish, this.branchName, this.buildUrl);
        if (!pactDirectory.exists()) {
            String string11 = "Pact directory " + pactDirectory + " does not exist, skipping uploading of pacts";
            boolean bl4 = false;
            System.out.println((Object)string11);
        } else {
            String it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.excludes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string12 = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl52 = false;
                string = new Regex(it);
                object.add(string);
            }
            List excludedList = (List)destination$iv$iv;
            boolean anyFailed = false;
            Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)pactDirectory)), (Function1)execute.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Result result;
                boolean bl52;
                File pactFile = (File)element$iv;
                boolean bl6 = false;
                if (this.pactFileIsExcluded(excludedList, pactFile)) {
                    it = "Not publishing '" + pactFile.getName() + "' as it matches an item in the excluded list";
                    boolean bl52 = false;
                    System.out.println((Object)it);
                    continue;
                }
                if (KotlinLanguageSupportKt.isNotEmpty(tagsToPublish)) {
                    it = "Publishing '" + pactFile.getName() + "' with tags '" + CollectionsKt.joinToString$default((Iterable)tagsToPublish, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "' ... ";
                    bl52 = false;
                    System.out.println((Object)it);
                } else {
                    it = "Publishing '" + pactFile.getName() + "' ... ";
                    bl52 = false;
                    System.out.println((Object)it);
                }
                PactBrokerClient pactBrokerClient = this.brokerClient;
                if (pactBrokerClient == null) {
                    Intrinsics.throwNpe();
                }
                if ((result = pactBrokerClient.uploadPactFile(pactFile, publishConfiguration)) instanceof Ok) {
                    String bl52 = "OK";
                    boolean bl7 = false;
                    System.out.println((Object)bl52);
                    continue;
                }
                if (!(result instanceof Err)) continue;
                Exception error = (Exception)((Err)result).getError();
                String string13 = "Failed - " + ((Exception)((Err)result).getError()).getMessage();
                boolean bl8 = false;
                System.out.println((Object)string13);
                if (error instanceof RequestFailedException && KotlinLanguageSupportKt.isNotEmpty((String)((RequestFailedException)error).getBody())) {
                    string13 = ((RequestFailedException)error).getBody();
                    bl8 = false;
                    System.out.println((Object)string13);
                }
                anyFailed = true;
            }
            if (anyFailed) {
                throw (Throwable)new MojoExecutionException("One or more of the pact files were rejected by the pact broker");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> calculateTags() {
        List list;
        String property = System.getProperty("pact.consumer.tags");
        if (KotlinLanguageSupportKt.isNotEmpty((String)property)) {
            void $this$mapTo$iv$iv;
            String string = property;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property");
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)string, (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var11_11 = it;
                boolean bl2 = false;
                void v1 = var11_11;
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string3 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString();
                collection.add(string3);
            }
            list = (List)destination$iv$iv;
        } else {
            list = this.tags;
        }
        return list;
    }

    private final boolean pactFileIsExcluded(List<Regex> exclusions, File pactFile) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = exclusions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex it = (Regex)element$iv;
                    boolean bl2 = false;
                    if (!it.matches((CharSequence)FilesKt.getNameWithoutExtension((File)pactFile))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public PactPublishMojo() {
        List list;
        PactPublishMojo pactPublishMojo = this;
        boolean bl = false;
        pactPublishMojo.tags = list = (List)new ArrayList();
        pactPublishMojo = this;
        bl = false;
        pactPublishMojo.excludes = list = (List)new ArrayList();
    }
}

