/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.dsl.BodyBuilder;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.HttpPartBuilder;
import au.com.dius.pact.core.model.HttpResponse;
import au.com.dius.pact.core.model.IHttpPart;
import au.com.dius.pact.core.model.matchingrules.HttpStatus;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.MatchingRuleCategory;
import au.com.dius.pact.core.model.matchingrules.RegexMatcher;
import au.com.dius.pact.core.model.matchingrules.RuleLogic;
import au.com.dius.pact.core.model.matchingrules.StatusCodeMatcher;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0005\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\nH\u0016J\u001a\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\fH\u0016J\u001a\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0018\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\u0000J\u0018\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J9\u0010\u0017\u001a\u00020\u00002*\u0010\u0018\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00160\u001a0\u0019\"\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00160\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ1\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0019\"\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001c\u0010\u0017\u001a\u00020\u00002\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00160\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u0000J\u001e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\fJ\u0006\u0010$\u001a\u00020\u0000J\u0006\u0010%\u001a\u00020\u0000J\u0006\u0010&\u001a\u00020\u0000J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(J\u0014\u0010)\u001a\u00020\u00002\f\u0010)\u001a\b\u0012\u0004\u0012\u00020(0*J\u0006\u0010+\u001a\u00020\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lau/com/dius/pact/consumer/dsl/HttpResponseBuilder;", "Lau/com/dius/pact/consumer/dsl/HttpPartBuilder;", "response", "Lau/com/dius/pact/core/model/HttpResponse;", "(Lau/com/dius/pact/core/model/HttpResponse;)V", "body", "builder", "Lau/com/dius/pact/consumer/dsl/BodyBuilder;", "dslPart", "Lau/com/dius/pact/consumer/dsl/DslPart;", "", "contentTypeString", "", "bodyMatchingContentType", "contentType", "exampleContents", "build", "clientErrorStatus", "errorStatus", "header", "key", "value", "", "headers", "nameValuePairs", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)Lau/com/dius/pact/consumer/dsl/HttpResponseBuilder;", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lau/com/dius/pact/consumer/dsl/HttpResponseBuilder;", "values", "", "informationStatus", "matchSetCookie", "cookie", "regex", "example", "nonErrorStatus", "redirectStatus", "serverErrorStatus", "status", "", "statusCodes", "", "successStatus", "consumer"})
public class HttpResponseBuilder
extends HttpPartBuilder {
    @NotNull
    private final HttpResponse response;

    public HttpResponseBuilder(@NotNull HttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        super((IHttpPart)response);
        this.response = response;
    }

    @NotNull
    public final HttpResponse build() {
        return this.response;
    }

    @Override
    @NotNull
    public HttpResponseBuilder header(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        HttpPartBuilder httpPartBuilder = super.header(key, value);
        Intrinsics.checkNotNull((Object)httpPartBuilder, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.HttpResponseBuilder");
        return (HttpResponseBuilder)httpPartBuilder;
    }

    @Override
    @NotNull
    public HttpResponseBuilder headers(@NotNull String key, @NotNull String value, String ... nameValuePairs) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)nameValuePairs, (String)"nameValuePairs");
        HttpPartBuilder httpPartBuilder = super.headers(key, value, nameValuePairs);
        Intrinsics.checkNotNull((Object)httpPartBuilder, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.HttpResponseBuilder");
        return (HttpResponseBuilder)httpPartBuilder;
    }

    @Override
    @NotNull
    public HttpResponseBuilder headers(Pair<String, ? extends Object> ... nameValuePairs) {
        Intrinsics.checkNotNullParameter(nameValuePairs, (String)"nameValuePairs");
        HttpPartBuilder httpPartBuilder = super.headers(nameValuePairs);
        Intrinsics.checkNotNull((Object)httpPartBuilder, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.HttpResponseBuilder");
        return (HttpResponseBuilder)httpPartBuilder;
    }

    @Override
    @NotNull
    public HttpResponseBuilder headers(@NotNull Map<String, ? extends Object> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        HttpPartBuilder httpPartBuilder = super.headers(values);
        Intrinsics.checkNotNull((Object)httpPartBuilder, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.HttpResponseBuilder");
        return (HttpResponseBuilder)httpPartBuilder;
    }

    @NotNull
    public final HttpResponseBuilder matchSetCookie(@NotNull String cookie, @NotNull String regex, @NotNull String example) {
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        MatchingRuleCategory headerCategory = this.response.getMatchingRules().addCategory("header");
        if (headerCategory.numRules("set-cookie") > 0) {
            MatchingRuleCategory.addRule$default((MatchingRuleCategory)headerCategory, (String)"set-cookie", (MatchingRule)((MatchingRule)new RegexMatcher(Pattern.quote(cookie + "=") + regex, null, 2, null)), null, (int)4, null);
        } else {
            headerCategory.setRule("set-cookie", (MatchingRule)new RegexMatcher(Pattern.quote(cookie + "=") + regex, null, 2, null), RuleLogic.OR);
        }
        if (this.response.getHeaders().containsKey("set-cookie")) {
            Map map = this.response.getHeaders();
            Object v = this.response.getHeaders().get("set-cookie");
            Intrinsics.checkNotNull(v);
            map.put("set-cookie", CollectionsKt.plus((Collection)((Collection)v), (Object)(cookie + "=" + example)));
        } else {
            this.response.getHeaders().put("set-cookie", CollectionsKt.listOf((Object)(cookie + "=" + example)));
        }
        return this;
    }

    @NotNull
    public final HttpResponseBuilder status(int status) {
        this.response.setStatus(status);
        return this;
    }

    @NotNull
    public final HttpResponseBuilder informationStatus() {
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.response.getMatchingRules().addCategory("status"), (MatchingRule)((MatchingRule)new StatusCodeMatcher(HttpStatus.Information, null, 2, null)), null, (int)2, null);
        this.response.setStatus(100);
        return this;
    }

    @NotNull
    public final HttpResponseBuilder successStatus() {
        StatusCodeMatcher matcher = new StatusCodeMatcher(HttpStatus.Success, null, 2, null);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.response.getMatchingRules().addCategory("status"), (MatchingRule)((MatchingRule)matcher), null, (int)2, null);
        this.response.setStatus(200);
        return this;
    }

    @NotNull
    public final HttpResponseBuilder redirectStatus() {
        StatusCodeMatcher matcher = new StatusCodeMatcher(HttpStatus.Redirect, null, 2, null);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.response.getMatchingRules().addCategory("status"), (MatchingRule)((MatchingRule)matcher), null, (int)2, null);
        this.response.setStatus(300);
        return this;
    }

    @NotNull
    public final HttpResponseBuilder clientErrorStatus() {
        StatusCodeMatcher matcher = new StatusCodeMatcher(HttpStatus.ClientError, null, 2, null);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.response.getMatchingRules().addCategory("status"), (MatchingRule)((MatchingRule)matcher), null, (int)2, null);
        this.response.setStatus(400);
        return this;
    }

    @NotNull
    public final HttpResponseBuilder serverErrorStatus() {
        StatusCodeMatcher matcher = new StatusCodeMatcher(HttpStatus.ServerError, null, 2, null);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.response.getMatchingRules().addCategory("status"), (MatchingRule)((MatchingRule)matcher), null, (int)2, null);
        this.response.setStatus(500);
        return this;
    }

    @NotNull
    public final HttpResponseBuilder nonErrorStatus() {
        StatusCodeMatcher matcher = new StatusCodeMatcher(HttpStatus.NonError, null, 2, null);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.response.getMatchingRules().addCategory("status"), (MatchingRule)((MatchingRule)matcher), null, (int)2, null);
        this.response.setStatus(200);
        return this;
    }

    @NotNull
    public final HttpResponseBuilder errorStatus() {
        StatusCodeMatcher matcher = new StatusCodeMatcher(HttpStatus.Error, null, 2, null);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.response.getMatchingRules().addCategory("status"), (MatchingRule)((MatchingRule)matcher), null, (int)2, null);
        this.response.setStatus(400);
        return this;
    }

    @NotNull
    public final HttpResponseBuilder statusCodes(@NotNull List<Integer> statusCodes) {
        Intrinsics.checkNotNullParameter(statusCodes, (String)"statusCodes");
        StatusCodeMatcher matcher = new StatusCodeMatcher(HttpStatus.StatusCodes, statusCodes);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.response.getMatchingRules().addCategory("status"), (MatchingRule)((MatchingRule)matcher), null, (int)2, null);
        this.response.setStatus(((Number)CollectionsKt.first(statusCodes)).intValue());
        return this;
    }

    @Override
    @NotNull
    public HttpResponseBuilder body(@NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        HttpPartBuilder httpPartBuilder = super.body(body);
        Intrinsics.checkNotNull((Object)httpPartBuilder, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.HttpResponseBuilder");
        return (HttpResponseBuilder)httpPartBuilder;
    }

    @Override
    @NotNull
    public HttpResponseBuilder body(@NotNull String body, @Nullable String contentTypeString) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        HttpPartBuilder httpPartBuilder = super.body(body, contentTypeString);
        Intrinsics.checkNotNull((Object)httpPartBuilder, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.HttpResponseBuilder");
        return (HttpResponseBuilder)httpPartBuilder;
    }

    @Override
    @NotNull
    public HttpResponseBuilder body(@NotNull byte[] body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        HttpPartBuilder httpPartBuilder = super.body(body);
        Intrinsics.checkNotNull((Object)httpPartBuilder, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.HttpResponseBuilder");
        return (HttpResponseBuilder)httpPartBuilder;
    }

    @Override
    @NotNull
    public HttpResponseBuilder body(@NotNull byte[] body, @Nullable String contentTypeString) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        HttpPartBuilder httpPartBuilder = super.body(body, contentTypeString);
        Intrinsics.checkNotNull((Object)httpPartBuilder, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.HttpResponseBuilder");
        return (HttpResponseBuilder)httpPartBuilder;
    }

    @Override
    @NotNull
    public HttpResponseBuilder body(@NotNull DslPart dslPart) {
        Intrinsics.checkNotNullParameter((Object)dslPart, (String)"dslPart");
        HttpPartBuilder httpPartBuilder = super.body(dslPart);
        Intrinsics.checkNotNull((Object)httpPartBuilder, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.HttpResponseBuilder");
        return (HttpResponseBuilder)httpPartBuilder;
    }

    @Override
    @NotNull
    public HttpResponseBuilder body(@NotNull BodyBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        HttpPartBuilder httpPartBuilder = super.body(builder);
        Intrinsics.checkNotNull((Object)httpPartBuilder, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.HttpResponseBuilder");
        return (HttpResponseBuilder)httpPartBuilder;
    }

    @Override
    @NotNull
    public HttpResponseBuilder bodyMatchingContentType(@NotNull String contentType, @NotNull byte[] exampleContents) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)exampleContents, (String)"exampleContents");
        HttpPartBuilder httpPartBuilder = super.bodyMatchingContentType(contentType, exampleContents);
        Intrinsics.checkNotNull((Object)httpPartBuilder, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.HttpResponseBuilder");
        return (HttpResponseBuilder)httpPartBuilder;
    }

    @Override
    @NotNull
    public HttpResponseBuilder bodyMatchingContentType(@NotNull String contentType, @NotNull String exampleContents) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)exampleContents, (String)"exampleContents");
        HttpPartBuilder httpPartBuilder = super.bodyMatchingContentType(contentType, exampleContents);
        Intrinsics.checkNotNull((Object)httpPartBuilder, (String)"null cannot be cast to non-null type au.com.dius.pact.consumer.dsl.HttpResponseBuilder");
        return (HttpResponseBuilder)httpPartBuilder;
    }
}

