/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.MessagePactBuilder;
import au.com.dius.pact.consumer.MockHttpServerKt;
import au.com.dius.pact.consumer.dsl.InteractionConfigurationError;
import au.com.dius.pact.consumer.dsl.PactBuilder;
import au.com.dius.pact.consumer.dsl.PactDslWithProvider;
import au.com.dius.pact.consumer.dsl.SynchronousMessagePactBuilder;
import au.com.dius.pact.core.matchers.ContentMatcher;
import au.com.dius.pact.core.matchers.MatcherExecutorKt;
import au.com.dius.pact.core.matchers.MatchingConfig;
import au.com.dius.pact.core.model.BasePact;
import au.com.dius.pact.core.model.Consumer;
import au.com.dius.pact.core.model.ContentType;
import au.com.dius.pact.core.model.IHttpPart;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.InteractionMarkup;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.Provider;
import au.com.dius.pact.core.model.UnknownPactSource;
import au.com.dius.pact.core.model.V4Interaction;
import au.com.dius.pact.core.model.V4Pact;
import au.com.dius.pact.core.model.generators.Generators;
import au.com.dius.pact.core.model.matchingrules.MatchingRuleCategory;
import au.com.dius.pact.core.model.matchingrules.MatchingRules;
import au.com.dius.pact.core.model.matchingrules.MatchingRulesImpl;
import au.com.dius.pact.core.model.v4.MessageContents;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.core.support.json.JsonValue;
import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Ok;
import com.github.michaelbull.result.Result;
import io.pact.plugins.jvm.core.CatalogueEntry;
import io.pact.plugins.jvm.core.CatalogueEntryProviderType;
import io.pact.plugins.jvm.core.CatalogueEntryType;
import io.pact.plugins.jvm.core.CatalogueManager;
import io.pact.plugins.jvm.core.DefaultPluginManager;
import io.pact.plugins.jvm.core.InteractionContents;
import io.pact.plugins.jvm.core.PactPlugin;
import io.pact.plugins.jvm.core.PactPluginEntryNotFoundException;
import io.pact.plugins.jvm.core.PactPluginNotFoundException;
import io.pact.plugins.jvm.core.PluginConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 H2\u00020\u0001:\u0001HB#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00170!H\u0002J$\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0003H\u0007J\u001c\u0010&\u001a\u0004\u0018\u00010\u00192\u0006\u0010'\u001a\u00020\u00032\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0002J\"\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020+2\u0006\u0010#\u001a\u00020\u00032\b\u0010%\u001a\u0004\u0018\u00010\u0003H\u0002J\u000e\u0010,\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u0006J\u0016\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010!H\u0002J>\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u00032\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010!2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\rH\u0002J\"\u00105\u001a\u00020\u001d2\b\u00106\u001a\u0004\u0018\u00010\u00012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000207H\u0002J,\u00108\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020<0:092\b\u00106\u001a\u0004\u0018\u00010\u00012\u0006\u00104\u001a\u00020\rH\u0002J\u0006\u0010=\u001a\u00020>J\u0006\u0010?\u001a\u00020@J\u0006\u0010A\u001a\u00020BJ\u001c\u0010C\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u00032\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u0003H\u0007J\u0006\u0010D\u001a\u00020EJ\u001c\u0010F\u001a\u00020\u00002\u0014\u0010G\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010!R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R&\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00170\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\t\"\u0004\b\u001b\u0010\u000b\u00a8\u0006\u0002"}, d2={"Lau/com/dius/pact/consumer/dsl/PactBuilder;", "", "consumer", "", "provider", "pactVersion", "Lau/com/dius/pact/core/model/PactSpecVersion;", "(Ljava/lang/String;Ljava/lang/String;Lau/com/dius/pact/core/model/PactSpecVersion;)V", "getConsumer", "()Ljava/lang/String;", "setConsumer", "(Ljava/lang/String;)V", "currentInteraction", "Lau/com/dius/pact/core/model/V4Interaction;", "interactions", "", "Lau/com/dius/pact/core/model/Interaction;", "getPactVersion", "()Lau/com/dius/pact/core/model/PactSpecVersion;", "setPactVersion", "(Lau/com/dius/pact/core/model/PactSpecVersion;)V", "pluginConfiguration", "", "Lau/com/dius/pact/core/support/json/JsonValue;", "plugins", "Lio/pact/plugins/jvm/core/PactPlugin;", "getProvider", "setProvider", "addPluginConfiguration", "", "contentMatcher", "Lio/pact/plugins/jvm/core/ContentMatcher;", "pactConfiguration", "", "expectsToReceive", "description", "interactionType", "key", "findPlugin", "name", "version", "forEntry", "entry", "Lio/pact/plugins/jvm/core/CatalogueEntry;", "pactSpecVersion", "pluginMetadata", "setupBodyFromPlugin", "matcher", "contentType", "bodyConfig", "part", "Lau/com/dius/pact/core/model/IHttpPart;", "interaction", "setupContents", "contents", "Lau/com/dius/pact/core/model/V4Interaction$SynchronousHttp;", "setupMessageContents", "", "Lkotlin/Pair;", "Lau/com/dius/pact/core/model/v4/MessageContents;", "Lau/com/dius/pact/core/model/InteractionMarkup;", "toPact", "Lau/com/dius/pact/core/model/V4Pact;", "usingLegacyDsl", "Lau/com/dius/pact/consumer/dsl/PactDslWithProvider;", "usingLegacyMessageDsl", "Lau/com/dius/pact/consumer/MessagePactBuilder;", "usingPlugin", "usingSynchronousMessageDsl", "Lau/com/dius/pact/consumer/dsl/SynchronousMessagePactBuilder;", "with", "values", "Companion"})
public class PactBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String consumer;
    @NotNull
    private String provider;
    @NotNull
    private PactSpecVersion pactVersion;
    @NotNull
    private final List<PactPlugin> plugins;
    @NotNull
    private final List<Interaction> interactions;
    @Nullable
    private V4Interaction currentInteraction;
    @NotNull
    private final Map<String, Map<String, JsonValue>> pluginConfiguration;

    public PactBuilder(@NotNull String consumer, @NotNull String provider, @NotNull PactSpecVersion pactVersion) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)pactVersion, (String)"pactVersion");
        this.consumer = consumer;
        this.provider = provider;
        this.pactVersion = pactVersion;
        boolean bl = false;
        this.plugins = new ArrayList();
        bl = false;
        this.interactions = new ArrayList();
        bl = false;
        this.pluginConfiguration = new LinkedHashMap();
        CatalogueManager.INSTANCE.registerCoreEntries(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)MatchingConfig.INSTANCE.contentMatcherCatalogueEntries(), (Iterable)MatcherExecutorKt.matcherCatalogueEntries()), (Iterable)MockHttpServerKt.interactionCatalogueEntries()), (Iterable)MatchingConfig.INSTANCE.contentHandlerCatalogueEntries()));
    }

    public /* synthetic */ PactBuilder(String string, String string2, PactSpecVersion pactSpecVersion, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "consumer";
        }
        if ((n & 2) != 0) {
            string2 = "provider";
        }
        if ((n & 4) != 0) {
            pactSpecVersion = PactSpecVersion.V4;
        }
        this(string, string2, pactSpecVersion);
    }

    @NotNull
    public final String getConsumer() {
        return this.consumer;
    }

    public final void setConsumer(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.consumer = string;
    }

    @NotNull
    public final String getProvider() {
        return this.provider;
    }

    public final void setProvider(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.provider = string;
    }

    @NotNull
    public final PactSpecVersion getPactVersion() {
        return this.pactVersion;
    }

    public final void setPactVersion(@NotNull PactSpecVersion pactSpecVersion) {
        Intrinsics.checkNotNullParameter((Object)pactSpecVersion, (String)"<set-?>");
        this.pactVersion = pactSpecVersion;
    }

    @NotNull
    public final PactDslWithProvider usingLegacyDsl() {
        return new PactDslWithProvider(new ConsumerPactBuilder(this.consumer), this.provider, this.pactVersion);
    }

    @NotNull
    public final MessagePactBuilder usingLegacyMessageDsl() {
        return new MessagePactBuilder(this.pactVersion).consumer(this.consumer).hasPactWith(this.provider);
    }

    @NotNull
    public final SynchronousMessagePactBuilder usingSynchronousMessageDsl() {
        return new SynchronousMessagePactBuilder(this.pactVersion).consumer(this.consumer).hasPactWith(this.provider);
    }

    public final void pactSpecVersion(@NotNull PactSpecVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.pactVersion = version;
    }

    @JvmOverloads
    @NotNull
    public final PactBuilder usingPlugin(@NotNull String name, @Nullable String version) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PactPlugin plugin = this.findPlugin(name, version);
        if (plugin == null) {
            Result result = DefaultPluginManager.INSTANCE.loadPlugin(name, version);
            if (result instanceof Ok) {
                this.plugins.add((PactPlugin)((Ok)result).getValue());
            } else if (result instanceof Err) {
                Companion.getLogger().error((Function0)new Function0<Object>((Result<? extends PactPlugin, String>)result){
                    final /* synthetic */ Result<PactPlugin, String> $result;
                    {
                        this.$result = $result;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return ((Err)this.$result).getError();
                    }
                });
                throw new PactPluginNotFoundException(name, version);
            }
        }
        return this;
    }

    public static /* synthetic */ PactBuilder usingPlugin$default(PactBuilder pactBuilder, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: usingPlugin");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return pactBuilder.usingPlugin(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final PactPlugin findPlugin(String name, String version) {
        PactPlugin pactPlugin;
        if (version == null) {
            Object v0;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.plugins;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PactPlugin it = (PactPlugin)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getManifest().getName(), (Object)name)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    PactPlugin it = (PactPlugin)maxElem$iv;
                    boolean bl = false;
                    Comparable maxValue$iv = (Comparable)((Object)it.getManifest().getVersion());
                    do {
                        Object e$iv = iterator$iv.next();
                        PactPlugin it2 = (PactPlugin)e$iv;
                        $i$a$-maxByOrNull-PactBuilder$findPlugin$2 = false;
                        Comparable v$iv = (Comparable)((Object)it2.getManifest().getVersion());
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            pactPlugin = v0;
        } else {
            Object v2;
            block9: {
                Iterable iterable = this.plugins;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    PactPlugin it = (PactPlugin)t;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual((Object)it.getManifest().getName(), (Object)name) && Intrinsics.areEqual((Object)it.getManifest().getVersion(), (Object)version))) continue;
                    v2 = t;
                    break block9;
                }
                v2 = null;
            }
            pactPlugin = v2;
        }
        return pactPlugin;
    }

    @JvmOverloads
    @NotNull
    public final PactBuilder expectsToReceive(@NotNull String description, @NotNull String interactionType, @Nullable String key) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)interactionType, (String)"interactionType");
        if (this.currentInteraction != null) {
            V4Interaction v4Interaction = this.currentInteraction;
            Intrinsics.checkNotNull((Object)v4Interaction);
            this.interactions.add((Interaction)v4Interaction);
        }
        CatalogueEntry entry = CatalogueManager.INSTANCE.lookupEntry(interactionType);
        if (entry == null) {
            Companion.getLogger().error((Function0)new Function0<Object>(interactionType){
                final /* synthetic */ String $interactionType;
                {
                    this.$interactionType = $interactionType;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "No interaction type of '" + this.$interactionType + "' was found in the catalogue";
                }
            });
            throw new PactPluginEntryNotFoundException(interactionType);
        }
        if (entry.getType() != CatalogueEntryType.INTERACTION) {
            String string = "Interactions of type " + interactionType + " are not currently supported";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        this.currentInteraction = this.forEntry(entry, description, key);
        return this;
    }

    public static /* synthetic */ PactBuilder expectsToReceive$default(PactBuilder pactBuilder, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: expectsToReceive");
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        return pactBuilder.expectsToReceive(string, string2, string3);
    }

    private final V4Interaction forEntry(CatalogueEntry entry, String description, String key) {
        V4Interaction v4Interaction;
        CatalogueEntryProviderType catalogueEntryProviderType = entry.getProviderType();
        int n = WhenMappings.$EnumSwitchMapping$0[catalogueEntryProviderType.ordinal()];
        block0 : switch (n) {
            case 1: {
                switch (entry.getKey()) {
                    case "http": 
                    case "https": {
                        String string = key;
                        boolean bl = false;
                        String string2 = string;
                        if (string2 == null) {
                            string2 = "";
                        }
                        v4Interaction = (V4Interaction)new V4Interaction.SynchronousHttp(string2, description, null, null, null, null, null, false, null, null, 1020, null);
                        break block0;
                    }
                    case "message": {
                        String string = key;
                        boolean bl = false;
                        String string3 = string;
                        if (string3 == null) {
                            string3 = "";
                        }
                        v4Interaction = (V4Interaction)new V4Interaction.AsynchronousMessage(string3, description, null, null, null, null, false, null, null, 508, null);
                        break block0;
                    }
                    case "synchronous-message": {
                        String string = key;
                        boolean bl = false;
                        String string4 = string;
                        if (string4 == null) {
                            string4 = "";
                        }
                        v4Interaction = (V4Interaction)new V4Interaction.SynchronousMessages(string4, description, null, null, null, false, null, null, null, null, 1020, null);
                        break block0;
                    }
                }
                String string = "Interactions of type " + entry.getKey() + " are not currently supported";
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
            case 2: {
                boolean bl = false;
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v4Interaction;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PactBuilder with(@NotNull Map<String, ? extends Object> values) {
        boolean $i$f$filter;
        Intrinsics.checkNotNullParameter(values, (String)"values");
        boolean bl = this.currentInteraction != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "'with' must be preceded by 'expectsToReceive'";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        V4Interaction interaction = this.currentInteraction;
        if (interaction instanceof V4Interaction.SynchronousHttp) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Companion.getLogger().debug((Function0)new Function0<Object>(values){
                final /* synthetic */ Map<String, Object> $values;
                {
                    this.$values = $values;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Configuring interaction from " + this.$values;
                }
            });
            if (values.containsKey("request.contents")) {
                this.setupContents(values.get("request.contents"), (IHttpPart)((V4Interaction.SynchronousHttp)interaction).getRequest(), (V4Interaction.SynchronousHttp)interaction);
            }
            if (values.containsKey("response.contents")) {
                this.setupContents(values.get("response.contents"), (IHttpPart)((V4Interaction.SynchronousHttp)interaction).getResponse(), (V4Interaction.SynchronousHttp)interaction);
            }
            Map<String, ? extends Object> map = values;
            V4Interaction.SynchronousHttp synchronousHttp = (V4Interaction.SynchronousHttp)interaction;
            $i$f$filter = false;
            void bl4 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            void var8_30 = $this$filterTo$iv$iv;
            boolean bl5 = false;
            Iterator iterator = var8_30.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl6 = false;
                if (!(!Intrinsics.areEqual(it.getKey(), (Object)"request.contents") && !Intrinsics.areEqual(it.getKey(), (Object)"response.contents"))) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map map2 = destination$iv$iv;
            synchronousHttp.updateProperties(map2);
        } else if (interaction instanceof V4Interaction.AsynchronousMessage) {
            void $this$filter$iv;
            Companion.getLogger().debug((Function0)new Function0<Object>(values){
                final /* synthetic */ Map<String, Object> $values;
                {
                    this.$values = $values;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Configuring AsynchronousMessage interaction from " + this.$values;
                }
            });
            if (values.containsKey("message.contents")) {
                List<Pair<MessageContents, InteractionMarkup>> messageContents = this.setupMessageContents(values.get("message.contents"), interaction);
                if (messageContents.size() > 1) {
                    Companion.getLogger().warn((Function0)with.5.INSTANCE);
                }
                Pair contents = (Pair)CollectionsKt.first(messageContents);
                ((V4Interaction.AsynchronousMessage)interaction).setContents((MessageContents)contents.getFirst());
                if (((InteractionMarkup)contents.getSecond()).isNotEmpty()) {
                    ((V4Interaction.AsynchronousMessage)interaction).setInteractionMarkup((InteractionMarkup)contents.getSecond());
                }
            }
            Map<String, ? extends Object> messageContents = values;
            V4Interaction.AsynchronousMessage asynchronousMessage = (V4Interaction.AsynchronousMessage)interaction;
            $i$f$filter = false;
            void $this$filterTo$iv$iv = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            void var8_31 = $this$filterTo$iv$iv;
            boolean bl7 = false;
            Iterator iterator = var8_31.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl8 = false;
                if (!(!Intrinsics.areEqual(it.getKey(), (Object)"message.contents"))) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map map = destination$iv$iv;
            asynchronousMessage.updateProperties(map);
        } else if (interaction instanceof V4Interaction.SynchronousMessages) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$filterTo$iv$iv2;
            Object v0;
            Map<String, ? extends Object> $this$filterTo$iv$iv3;
            List<Pair<MessageContents, InteractionMarkup>> result;
            block19: {
                Companion.getLogger().debug((Function0)new Function0<Object>(values){
                    final /* synthetic */ Map<String, Object> $values;
                    {
                        this.$values = $values;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Configuring SynchronousMessages interaction from " + this.$values;
                    }
                });
                result = this.setupMessageContents(values, interaction);
                $this$filterTo$iv$iv3 = result;
                boolean destination$iv$iv = false;
                Iterable $i$f$filterTo = $this$filterTo$iv$iv3;
                boolean bl9 = false;
                for (Object t : $i$f$filterTo) {
                    Pair it = (Pair)t;
                    boolean bl10 = false;
                    if (!Intrinsics.areEqual((Object)((MessageContents)it.getFirst()).getPartName(), (Object)"request")) continue;
                    v0 = t;
                    break block19;
                }
                v0 = null;
            }
            Pair requestContents = v0;
            if (requestContents != null) {
                ((V4Interaction.SynchronousMessages)interaction).setRequest((MessageContents)requestContents.getFirst());
                if (((InteractionMarkup)requestContents.getSecond()).isNotEmpty()) {
                    ((V4Interaction.SynchronousMessages)interaction).setInteractionMarkup((InteractionMarkup)requestContents.getSecond());
                }
            }
            Iterable $this$filter$iv2 = result;
            boolean $i$f$filter22 = false;
            Iterable iterable = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Pair it = (Pair)element$iv$iv;
                boolean bl11 = false;
                if (!Intrinsics.areEqual((Object)((MessageContents)it.getFirst()).getPartName(), (Object)"response")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Pair response : (List)destination$iv$iv) {
                ((V4Interaction.SynchronousMessages)interaction).getResponse().add(response.getFirst());
                if (!((InteractionMarkup)response.getSecond()).isNotEmpty()) continue;
                ((V4Interaction.SynchronousMessages)interaction).setInteractionMarkup(((V4Interaction.SynchronousMessages)interaction).getInteractionMarkup().merge((InteractionMarkup)response.getSecond()));
            }
            $this$filterTo$iv$iv3 = values;
            V4Interaction.SynchronousMessages synchronousMessages = (V4Interaction.SynchronousMessages)interaction;
            boolean $i$f$filter3 = false;
            void $i$f$filter22 = $this$filter$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo2 = false;
            void var10_42 = $this$filterTo$iv$iv;
            boolean bl12 = false;
            Iterator iterator = var10_42.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl13 = false;
                if (!(!Intrinsics.areEqual(it.getKey(), (Object)"request") && !Intrinsics.areEqual(it.getKey(), (Object)"response"))) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map map = destination$iv$iv2;
            synchronousMessages.updateProperties(map);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final List<Pair<MessageContents, InteractionMarkup>> setupMessageContents(Object contents, V4Interaction interaction) {
        void $this$mapTo$iv$iv;
        Result result;
        io.pact.plugins.jvm.core.ContentMatcher matcher;
        List list;
        Iterator iterator;
        block23: {
            void $this$mapTo$iv$iv2;
            boolean $i$f$map2;
            Object $this$map$iv;
            Object result2;
            Object object;
            block22: {
                Map destination$iv$iv;
                String contentType;
                block21: {
                    Companion.getLogger().debug((Function0)setupMessageContents.1.INSTANCE);
                    Object object2 = contents;
                    if (object2 instanceof Map) {
                        Object object3 = (Map)contents;
                        Object object4 = "pact:content-type";
                        boolean bl = false;
                        Map map = object3;
                        if (map == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                        }
                        if (map.containsKey(object4)) {
                            void $this$filterTo$iv$iv;
                            object4 = (Map)contents;
                            String string = "pact:content-type";
                            boolean bl2 = false;
                            contentType = String.valueOf(object4.get(string));
                            Map $this$filter$iv = (Map)contents;
                            boolean $i$f$filter = false;
                            Map map2 = $this$filter$iv;
                            destination$iv$iv = new LinkedHashMap();
                            boolean $i$f$filterTo = false;
                            object = $this$filterTo$iv$iv;
                            boolean bl3 = false;
                            iterator = object.entrySet().iterator();
                            break block21;
                        } else {
                            object3 = Json.toJson((Object)contents).serialise();
                            object4 = Charsets.UTF_8;
                            bl = false;
                            Object object5 = object3;
                            if (object5 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            byte[] byArray = ((String)object5).getBytes((Charset)object4);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                            list = CollectionsKt.listOf((Object)TuplesKt.to((Object)new MessageContents(OptionalBody.Companion.body(byArray), null, null, null, null, 30, null), (Object)new InteractionMarkup(null, null, 3, null)));
                            return list;
                        }
                    }
                    String string = String.valueOf(contents);
                    Charset charset = Charsets.UTF_8;
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray = string2.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    list = CollectionsKt.listOf((Object)TuplesKt.to((Object)new MessageContents(OptionalBody.Companion.body(byArray), null, null, null, null, 30, null), (Object)new InteractionMarkup(null, null, 3, null)));
                    return list;
                }
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry entry2 = entry = iterator.next();
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual(entry2.getKey(), (Object)"pact:content-type"))) continue;
                    destination$iv$iv.put(entry.getKey(), entry.getValue());
                }
                Map bodyConfig = destination$iv$iv;
                matcher = CatalogueManager.INSTANCE.findContentMatcher(new ContentType(contentType));
                Companion.getLogger().debug((Function0)new Function0<Object>(contentType, matcher){
                    final /* synthetic */ String $contentType;
                    final /* synthetic */ io.pact.plugins.jvm.core.ContentMatcher $matcher;
                    {
                        this.$contentType = $contentType;
                        this.$matcher = $matcher;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Found a matcher for '" + this.$contentType + "': " + this.$matcher;
                    }
                });
                if (matcher == null || matcher.isCore()) {
                    Companion.getLogger().debug((Function0)setupMessageContents.3.INSTANCE);
                    ContentMatcher contentMatcher = MatchingConfig.lookupContentMatcher((String)contentType);
                    if (contentMatcher != null) {
                        result2 = contentMatcher.setupBodyFromConfig(bodyConfig);
                        if (!(result2 instanceof Ok)) {
                            if (!(result2 instanceof Err)) throw new NoWhenBranchMatchedException();
                            throw new InteractionConfigurationError("Failed to set the interaction: " + ((Err)result2).getError());
                        }
                        break block22;
                    } else {
                        result2 = Json.toJson((Object)bodyConfig).serialise();
                        $this$map$iv = Charsets.UTF_8;
                        $i$f$map2 = false;
                        Object object6 = result2;
                        if (object6 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        byte[] byArray = ((String)object6).getBytes((Charset)$this$map$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                        list = CollectionsKt.listOf((Object)TuplesKt.to((Object)new MessageContents(OptionalBody.Companion.body(byArray, new ContentType(contentType)), null, null, null, null, 30, null), (Object)new InteractionMarkup(null, null, 3, null)));
                        return list;
                    }
                }
                Companion.getLogger().debug((Function0)setupMessageContents.5.INSTANCE);
                result = matcher.configureContent(contentType, bodyConfig);
                if (!(result instanceof Ok)) {
                    if (!(result instanceof Err)) throw new NoWhenBranchMatchedException();
                    throw new InteractionConfigurationError("Failed to set the interaction: " + ((Err)result).getError());
                }
                break block23;
            }
            $this$map$iv = (Iterable)((Ok)result2).getValue();
            $i$f$map2 = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
            while (true) {
                Generators generators;
                void it;
                if (!iterator2.hasNext()) {
                    list = (List)destination$iv$iv;
                    return list;
                }
                Object t = iterator2.next();
                InteractionContents bl = (InteractionContents)t;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                void var18_37 = it;
                String partName = var18_37.component1();
                OptionalBody body = var18_37.component2();
                MatchingRuleCategory rules = var18_37.component3();
                Generators generators2 = var18_37.component4();
                String interactionMarkup = var18_37.component7();
                String interactionMarkupType = var18_37.component8();
                MatchingRulesImpl matchingRules = new MatchingRulesImpl();
                if (rules != null) {
                    matchingRules.addCategory(rules);
                }
                boolean bl5 = false;
                Pair pair = TuplesKt.to((Object)new MessageContents(body, MapsKt.emptyMap(), (MatchingRules)matchingRules, (generators = generators2) == null ? new Generators(null, 1, null) : generators, partName), (Object)new InteractionMarkup(interactionMarkup, interactionMarkupType));
                collection.add(pair);
            }
        }
        Iterable $this$map$iv = (Iterable)((Ok)result).getValue();
        boolean $i$f$map = false;
        Iterable $i$f$map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                list = (List)destination$iv$iv;
                return list;
            }
            Map.Entry entry = iterator.next();
            InteractionContents interactionContents = (InteractionContents)entry;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            InteractionContents interactionContents2 = interactionContents;
            String partName = interactionContents2.component1();
            OptionalBody body = interactionContents2.component2();
            MatchingRuleCategory rules = interactionContents2.component3();
            Generators generators = interactionContents2.component4();
            Map metadata = interactionContents2.component5();
            PluginConfiguration config = interactionContents2.component6();
            String interactionMarkup = interactionContents2.component7();
            String interactionMarkupType = interactionContents2.component8();
            MatchingRulesImpl matchingRules = new MatchingRulesImpl();
            if (rules != null) {
                matchingRules.addCategory(rules);
            }
            Map map = config.getInteractionConfiguration();
            boolean bl6 = false;
            if (!map.isEmpty()) {
                interaction.addPluginConfiguration(matcher.getPluginName(), config.getInteractionConfiguration());
            }
            map = config.getPactConfiguration();
            bl6 = false;
            if (!map.isEmpty()) {
                this.addPluginConfiguration(matcher, config.getPactConfiguration());
            }
            Pair pair = TuplesKt.to((Object)new MessageContents(body, metadata, (MatchingRules)matchingRules, (Generators)((map = generators) == null ? new Generators(null, 1, null) : map), partName), (Object)new InteractionMarkup(interactionMarkup, interactionMarkupType));
            collection.add(pair);
        }
    }

    private final void addPluginConfiguration(io.pact.plugins.jvm.core.ContentMatcher contentMatcher, Map<String, ? extends JsonValue> pactConfiguration) {
        if (this.pluginConfiguration.containsKey(contentMatcher.getPluginName())) {
            KotlinLanguageSupportKt.deepMerge(this.pluginConfiguration.get(contentMatcher.getPluginName()), pactConfiguration);
        } else {
            Map<String, Map<String, JsonValue>> map = this.pluginConfiguration;
            String string = contentMatcher.getPluginName();
            Map map2 = MapsKt.toMutableMap(pactConfiguration);
            boolean bl = false;
            map.put(string, map2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setupContents(Object contents, IHttpPart part, V4Interaction.SynchronousHttp interaction) {
        Companion.getLogger().debug((Function0)setupContents.1.INSTANCE);
        Object object = contents;
        if (object instanceof Map) {
            Object object2 = (Map)contents;
            Object object3 = "pact:content-type";
            boolean bl = false;
            Map map = object2;
            if (map == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            if (map.containsKey(object3)) {
                void $this$filterTo$iv$iv;
                object3 = (Map)contents;
                String string = "pact:content-type";
                boolean bl2 = false;
                String contentType = String.valueOf(object3.get(string));
                Map $this$filter$iv = (Map)contents;
                boolean $i$f$filter = false;
                Object object4 = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                void var12_18 = $this$filterTo$iv$iv;
                boolean bl3 = false;
                Iterator iterator = var12_18.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = iterator.next();
                    boolean bl4 = false;
                    if (!(!Intrinsics.areEqual(it.getKey(), (Object)"pact:content-type"))) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Map bodyConfig = destination$iv$iv;
                io.pact.plugins.jvm.core.ContentMatcher matcher = CatalogueManager.INSTANCE.findContentMatcher(new ContentType(contentType));
                Companion.getLogger().debug((Function0)new Function0<Object>(contentType, matcher){
                    final /* synthetic */ String $contentType;
                    final /* synthetic */ io.pact.plugins.jvm.core.ContentMatcher $matcher;
                    {
                        this.$contentType = $contentType;
                        this.$matcher = $matcher;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Found a matcher for '" + this.$contentType + "': " + this.$matcher;
                    }
                });
                if (matcher == null || matcher.isCore()) {
                    Charset charset;
                    Companion.getLogger().debug((Function0)setupContents.3.INSTANCE);
                    ContentMatcher contentMatcher = MatchingConfig.lookupContentMatcher((String)contentType);
                    if (contentMatcher != null) {
                        Result result = contentMatcher.setupBodyFromConfig(bodyConfig);
                        if (result instanceof Ok) {
                            if (((List)((Ok)result).getValue()).size() > 1) {
                                Companion.getLogger().warn((Function0)setupContents.4.INSTANCE);
                            }
                            charset = (InteractionContents)CollectionsKt.first((List)((List)((Ok)result).getValue()));
                            OptionalBody body = charset.component2();
                            MatchingRuleCategory rules = charset.component3();
                            Generators generators = charset.component4();
                            part.setBody(body);
                            if (rules != null) {
                                part.getMatchingRules().addCategory(rules);
                            }
                            if (generators != null) {
                                Generators.addGenerators$default((Generators)part.getGenerators(), (Generators)generators, null, (int)2, null);
                            }
                        } else if (result instanceof Err) {
                            throw new InteractionConfigurationError("Failed to set the interaction: " + ((Err)result).getError());
                        }
                    } else {
                        object4 = Json.toJson((Object)bodyConfig).serialise();
                        charset = Charsets.UTF_8;
                        boolean bl5 = false;
                        Object object5 = object4;
                        if (object5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        byte[] byArray = ((String)object5).getBytes(charset);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                        part.setBody(OptionalBody.Companion.body(byArray, new ContentType(contentType)));
                    }
                } else {
                    Companion.getLogger().debug((Function0)setupContents.5.INSTANCE);
                    this.setupBodyFromPlugin(matcher, contentType, bodyConfig, part, (V4Interaction)interaction);
                }
            } else {
                object2 = Json.toJson((Object)contents).serialise();
                object3 = Charsets.UTF_8;
                bl = false;
                Object object6 = object2;
                if (object6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = ((String)object6).getBytes((Charset)object3);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                part.setBody(OptionalBody.Companion.body(byArray));
            }
        } else {
            String string = String.valueOf(contents);
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            part.setBody(OptionalBody.Companion.body(byArray));
        }
    }

    private final void setupBodyFromPlugin(io.pact.plugins.jvm.core.ContentMatcher matcher, String contentType, Map<String, ? extends Object> bodyConfig, IHttpPart part, V4Interaction interaction) {
        Result result = matcher.configureContent(contentType, bodyConfig);
        if (result instanceof Ok) {
            Map map;
            if (((List)((Ok)result).getValue()).size() > 1) {
                Companion.getLogger().warn((Function0)setupBodyFromPlugin.1.INSTANCE);
            }
            InteractionContents interactionContents = (InteractionContents)CollectionsKt.first((List)((List)((Ok)result).getValue()));
            OptionalBody body = interactionContents.component2();
            MatchingRuleCategory rules = interactionContents.component3();
            Generators generators = interactionContents.component4();
            PluginConfiguration config = interactionContents.component6();
            String interactionMarkup = interactionContents.component7();
            String interactionMarkupType = interactionContents.component8();
            part.setBody(body);
            if (!part.hasHeader("content-type")) {
                map = part.getHeaders();
                String string = "content-type";
                List list = CollectionsKt.listOf((Object)body.getContentType().toString());
                boolean bl = false;
                map.put(string, list);
            }
            if (rules != null) {
                part.getMatchingRules().addCategory(rules);
            }
            if (generators != null) {
                Generators.addGenerators$default((Generators)part.getGenerators(), (Generators)generators, null, (int)2, null);
            }
            Companion.getLogger().debug((Function0)new Function0<Object>(part){
                final /* synthetic */ IHttpPart $part;
                {
                    this.$part = $part;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Http part from plugin: " + this.$part;
                }
            });
            Companion.getLogger().debug((Function0)new Function0<Object>(config){
                final /* synthetic */ PluginConfiguration $config;
                {
                    this.$config = $config;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Plugin config: " + this.$config;
                }
            });
            map = config.getInteractionConfiguration();
            boolean bl = false;
            if (!map.isEmpty()) {
                interaction.addPluginConfiguration(matcher.getPluginName(), config.getInteractionConfiguration());
            }
            map = config.getPactConfiguration();
            bl = false;
            if (!map.isEmpty()) {
                this.addPluginConfiguration(matcher, config.getPactConfiguration());
            }
            if (KotlinLanguageSupportKt.isNotEmpty((String)interactionMarkup)) {
                interaction.setInteractionMarkup(new InteractionMarkup(interactionMarkup, interactionMarkupType));
            }
        } else if (result instanceof Err) {
            throw new InteractionConfigurationError("Failed to set the interaction: " + ((Err)result).getError());
        }
    }

    @NotNull
    public final V4Pact toPact() {
        if (this.currentInteraction != null) {
            V4Interaction v4Interaction = this.currentInteraction;
            Intrinsics.checkNotNull((Object)v4Interaction);
            this.interactions.add((Interaction)v4Interaction);
        }
        return new V4Pact(new Consumer(this.consumer), new Provider(this.provider), this.interactions, MapsKt.plus((Map)BasePact.Companion.metaData(null, PactSpecVersion.V4), this.pluginMetadata()), (PactSource)UnknownPactSource.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> pluginMetadata() {
        Collection<Map> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.plugins;
        String string = "plugins";
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PactPlugin pactPlugin = (PactPlugin)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object object = new Pair[]{TuplesKt.to((Object)"name", (Object)it.getManifest().getName()), TuplesKt.to((Object)"version", (Object)it.getManifest().getVersion())};
            Map map = MapsKt.mutableMapOf((Pair[])object);
            if (this.pluginConfiguration.containsKey(it.getManifest().getName())) {
                object = map;
                String string2 = "configuration";
                Map<String, JsonValue> map2 = this.pluginConfiguration.get(it.getManifest().getName());
                boolean bl2 = false;
                object.put(string2, map2);
            }
            Map map3 = map;
            collection.add(map3);
        }
        collection = (List)destination$iv$iv;
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)collection));
    }

    @JvmOverloads
    @NotNull
    public final PactBuilder usingPlugin(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return PactBuilder.usingPlugin$default(this, name, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final PactBuilder expectsToReceive(@NotNull String description, @NotNull String interactionType) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)interactionType, (String)"interactionType");
        return PactBuilder.expectsToReceive$default(this, description, interactionType, null, 4, null);
    }

    public PactBuilder() {
        this(null, null, null, 7, null);
    }

    @JvmStatic
    @NotNull
    public static final String textFile(@NotNull String filePath) {
        return Companion.textFile(filePath);
    }

    @JvmStatic
    @NotNull
    public static final String filePath(@NotNull String filePath) {
        return Companion.filePath(filePath);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lau/com/dius/pact/consumer/dsl/PactBuilder$Companion;", "Lmu/KLogging;", "()V", "filePath", "", "textFile", "consumer"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String textFile(@NotNull String filePath) {
            Path path;
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Comparable<Path> comparable = path = Paths.get(filePath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"path");
            Object object = new LinkOption[]{};
            int n = 0;
            if (!Files.exists(comparable, Arrays.copyOf(object, ((LinkOption[])object).length))) {
                Path cwd = Path.of("", new String[0]).toAbsolutePath();
                path = cwd.resolve(filePath).toAbsolutePath();
            }
            comparable = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"path.toFile()");
            object = Charsets.UTF_8;
            n = 8192;
            boolean bl = false;
            Object object2 = comparable;
            boolean bl2 = false;
            Object object3 = object2;
            boolean bl3 = false;
            object3 = new FileInputStream((File)object3);
            bl3 = false;
            object2 = new InputStreamReader((InputStream)object3, (Charset)object);
            bl2 = false;
            return TextStreamsKt.readText((Reader)(object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n)));
        }

        @JvmStatic
        @NotNull
        public final String filePath(@NotNull String filePath) {
            Path path;
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Path path2 = path = Paths.get(filePath, new String[0]).toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            boolean bl = false;
            if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Path cwd = Path.of("", new String[0]).toAbsolutePath();
                path = cwd.resolve(filePath).toAbsolutePath();
            }
            return ((Object)path.normalize()).toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CatalogueEntryProviderType.values().length];
            nArray[CatalogueEntryProviderType.CORE.ordinal()] = 1;
            nArray[CatalogueEntryProviderType.PLUGIN.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

