/* *******************************************************************
 * Copyright (c) 1999-2001 Xerox Corporation, 
 *               2002 Palo Alto Research Center, Incorporated (PARC).
 * All rights reserved. 
 * This program and the accompanying materials are made available 
 * under the terms of the Common Public License v1.0 
 * which accompanies this distribution and is available at 
 * http://www.eclipse.org/legal/cpl-v10.html 
 *  
 * Contributors: 
 *     Xerox/PARC     initial implementation 
 *    Alex Vasseur    wired up for @AJ proceeding
 * ******************************************************************/


package org.aspectj.runtime.internal;

import org.aspectj.lang.ProceedingJoinPoint;

public abstract class AroundClosure {
    protected Object[] state;
    protected Object[] preInitializationState;

    public AroundClosure() {
    }
    
    public AroundClosure(Object[] state) {
    	this.state = state;
    }
    
    

    public Object[] getState() {
      return state;
    }
    
	public Object[] getPreInitializationState() {
		return preInitializationState;
	}

	/**
	 * This takes in the same arguments as are passed to the proceed
	 * call in the around advice (with primitives coerced to Object types)
	 */
    public abstract Object run(Object[] args) throws Throwable;

    /**
     * This method is called to implicitly associate the closure with the joinpoint
     * as required for @AJ aspect proceed()
     */
    public ProceedingJoinPoint linkClosureAndJoinPoint() {
        //TODO is this cast safe ?
        ProceedingJoinPoint jp = (ProceedingJoinPoint)state[state.length-1];
        jp.set$AroundClosure(this);
        return jp;
    }
}
