/*
 * Decompiled with CFR 0.152.
 */
package water.webserver.config;

public class ConnectionConfiguration {
    private final boolean _secure;
    private final String _scheme;

    public ConnectionConfiguration(boolean isSecured) {
        this._secure = isSecured;
        this._scheme = isSecured ? "https" : "http";
    }

    public boolean isSecure() {
        return this._secure;
    }

    public int getRequestHeaderSize() {
        return this.getSysPropInt("requestHeaderSize", 32768);
    }

    public int getRequestBufferSize() {
        return this.getSysPropInt("requestBufferSize", 32768);
    }

    public int getResponseHeaderSize() {
        return this.getSysPropInt("responseHeaderSize", 32768);
    }

    public int getOutputBufferSize(int defaultOutputBufferSize) {
        return this.getSysPropInt("responseBufferSize", defaultOutputBufferSize);
    }

    public int getIdleTimeout() {
        return this.getSysPropInt("jetty.idleTimeout", 300000);
    }

    public boolean isRelativeRedirectAllowed() {
        return this.getSysPropBool("relativeRedirectAllowed", true);
    }

    private int getSysPropInt(String suffix, int defaultValue) {
        return Integer.parseInt(this.getProperty("sys.ai.h2o." + this._scheme + "." + suffix, String.valueOf(defaultValue)));
    }

    private boolean getSysPropBool(String suffix, boolean defaultValue) {
        return Boolean.parseBoolean(this.getProperty("sys.ai.h2o." + this._scheme + "." + suffix, String.valueOf(defaultValue)));
    }

    protected String getProperty(String name, String defaultValue) {
        return System.getProperty(name, defaultValue);
    }
}

