/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.tools;

import hex.genmodel.GenMunger;
import hex.genmodel.easy.RowData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;

public class MungeCsv {
    private static String assemblyClassName;
    private static String inputCSVFileName;
    private static String outputCSVFileName;
    private static int haveHeaders;

    private static void usage() {
        System.out.println("");
        System.out.println("usage:  java [...java args...] hex.genmodel.tools.MungeCsv --header --model modelClassName --input inputCSVFileName --output outputCSVFileName");
        System.out.println("");
        System.out.println("        assembly class name is something like AssemblyPojo_bleehbleehbleeh.");
        System.out.println("");
        System.out.println("        inputCSVFileName is the test data set.");
        System.out.println("        Specifying --header is required for h2o-3.");
        System.out.println("");
        System.out.println("        outputCSVFileName is the munged data set (one row per data set row).");
        System.out.println("");
        System.exit(1);
    }

    private static void parseArgs(String[] args) {
        block12: for (int i = 0; i < args.length; ++i) {
            String s;
            switch (s = args[i]) {
                case "--munger": {
                    if (++i >= args.length) {
                        MungeCsv.usage();
                    }
                    assemblyClassName = args[i];
                    continue block12;
                }
                case "--input": {
                    if (++i >= args.length) {
                        MungeCsv.usage();
                    }
                    inputCSVFileName = args[i];
                    continue block12;
                }
                case "--output": {
                    if (++i >= args.length) {
                        MungeCsv.usage();
                    }
                    outputCSVFileName = args[i];
                    continue block12;
                }
                case "--header": {
                    haveHeaders = 1;
                    continue block12;
                }
                default: {
                    System.out.println("bad param... skipping.");
                }
            }
        }
        if (haveHeaders != 1) {
            System.out.println("ERROR: header not specified");
            MungeCsv.usage();
        }
        if (assemblyClassName == null) {
            System.out.println("ERROR: model not specified");
            MungeCsv.usage();
        }
        if (inputCSVFileName == null) {
            System.out.println("ERROR: input not specified");
            MungeCsv.usage();
        }
        if (outputCSVFileName == null) {
            System.out.println("ERROR: output not specified");
            MungeCsv.usage();
        }
    }

    private static RowData parseDataRow(String line, GenMunger munger) {
        if (line.isEmpty() || line.equals("")) {
            return null;
        }
        String[] inputData = line.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)|(,)", -1);
        for (int i = 0; i < inputData.length; ++i) {
            inputData[i] = inputData[i] == null ? "" : inputData[i];
        }
        if (inputData.length != munger.inNames().length) {
            return null;
        }
        return munger.fillDefault(inputData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        MungeCsv.parseArgs(args);
        GenMunger rawMunger = (GenMunger)Class.forName(assemblyClassName).newInstance();
        BufferedReader input = new BufferedReader(new FileReader(inputCSVFileName));
        BufferedWriter output = new BufferedWriter(new FileWriter(outputCSVFileName));
        String[] rawHeader = rawMunger.outNames();
        StringBuilder header = new StringBuilder();
        for (int i = 0; i < rawHeader.length; ++i) {
            header.append("\"").append(rawHeader[i]).append("\"");
            if (i >= rawHeader.length - 1) continue;
            header.append(",");
        }
        output.write(header.toString());
        output.write("\n");
        int lineNum = 0;
        try {
            String line;
            while ((line = input.readLine()) != null) {
                RowData row;
                if (++lineNum == 1) continue;
                try {
                    row = MungeCsv.parseDataRow(line, rawMunger);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    System.out.println("Failed to parse row: " + lineNum);
                    throw new RuntimeException();
                }
                RowData mungedRow = rawMunger.fit(row);
                for (int i = 0; i < rawMunger.outNames().length; ++i) {
                    Double val;
                    Double d = val = mungedRow == null ? Double.valueOf(Double.NaN) : mungedRow.get(rawMunger.outNames()[i]);
                    if (val instanceof Double) {
                        output.write(String.valueOf(val));
                    } else {
                        output.write("\"" + val + "\"");
                    }
                    if (i >= rawMunger.outNames().length - 1) continue;
                    output.write(",");
                }
                output.write("\n");
            }
        }
        catch (Exception e) {
            System.out.println("Caught exception on line " + lineNum);
            System.out.println("");
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            output.close();
            input.close();
        }
        System.exit(0);
    }

    static {
        haveHeaders = -1;
    }
}

