/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.descriptor;

import hex.ModelCategory;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.attributes.ModelAttributes;
import hex.genmodel.attributes.parameters.ColumnSpecifier;
import hex.genmodel.descriptor.ModelDescriptor;
import hex.genmodel.utils.ArrayUtils;
import java.io.Serializable;
import java.util.Arrays;

public class ModelDescriptorBuilder {
    public static ModelDescriptor makeDescriptor(MojoModel mojoModel, String fullAlgorithmName, ModelAttributes modelAttributes) {
        return new MojoModelDescriptor(mojoModel, fullAlgorithmName, modelAttributes);
    }

    public static ModelDescriptor makeDescriptor(GenModel pojoModel) {
        return new PojoModelDescriptor(pojoModel);
    }

    public static class PojoModelDescriptor
    implements ModelDescriptor,
    Serializable {
        private final ModelCategory _category;
        private final boolean _supervised;
        private final int _nfeatures;
        private final int _nclasses;
        private final String _offsetColumn;
        private final String[][] _domains;
        private final String[][] _origDomains;
        private final String[] _names;
        private final String[] _origNames;

        private PojoModelDescriptor(GenModel mojoModel) {
            this._category = mojoModel.getModelCategory();
            this._supervised = mojoModel.isSupervised();
            this._nfeatures = mojoModel.nfeatures();
            this._nclasses = mojoModel.getNumResponseClasses();
            this._offsetColumn = mojoModel.getOffsetName();
            this._domains = mojoModel.getDomainValues();
            this._origDomains = mojoModel.getOrigDomainValues();
            String[] names = mojoModel.getNames();
            if (names.length == this._domains.length - 1 && mojoModel.isSupervised() && !names[names.length - 1].equals(mojoModel._responseColumn)) {
                names = ArrayUtils.append(names, mojoModel._responseColumn);
            }
            this._names = names;
            this._origNames = mojoModel.getOrigNames();
        }

        @Override
        public String[][] scoringDomains() {
            return this._domains;
        }

        @Override
        public String projectVersion() {
            return "unknown";
        }

        @Override
        public String algoName() {
            return "pojo";
        }

        @Override
        public String algoFullName() {
            return "POJO Scorer";
        }

        @Override
        public String offsetColumn() {
            return this._offsetColumn;
        }

        @Override
        public String weightsColumn() {
            return null;
        }

        @Override
        public String foldColumn() {
            return null;
        }

        @Override
        public String treatmentColumn() {
            return null;
        }

        @Override
        public ModelCategory getModelCategory() {
            return this._category;
        }

        @Override
        public boolean isSupervised() {
            return this._supervised;
        }

        @Override
        public int nfeatures() {
            return this._nfeatures;
        }

        @Override
        public String[] features() {
            return Arrays.copyOf(this.columnNames(), this.nfeatures());
        }

        @Override
        public int nclasses() {
            return this._nclasses;
        }

        @Override
        public String[] columnNames() {
            return this._names;
        }

        @Override
        public boolean balanceClasses() {
            return false;
        }

        @Override
        public double defaultThreshold() {
            return Double.NaN;
        }

        @Override
        public double[] priorClassDist() {
            return null;
        }

        @Override
        public double[] modelClassDist() {
            return null;
        }

        @Override
        public String uuid() {
            return null;
        }

        @Override
        public String timestamp() {
            return null;
        }

        @Override
        public String[] getOrigNames() {
            return this._origNames;
        }

        @Override
        public String[][] getOrigDomains() {
            return this._origDomains;
        }
    }

    public static class MojoModelDescriptor
    implements ModelDescriptor,
    Serializable {
        private final String _h2oVersion;
        private final ModelCategory _category;
        private final String _uuid;
        private final boolean _supervised;
        private final int _nfeatures;
        private final int _nclasses;
        private final boolean _balanceClasses;
        private final double _defaultThreshold;
        private final double[] _priorClassDistrib;
        private final double[] _modelClassDistrib;
        private final String _offsetColumn;
        private final String _foldColumn;
        private final String _weightsColumn;
        private final String _treatmentColumn;
        private final String[][] _domains;
        private final String[][] _origDomains;
        private final String[] _names;
        private final String[] _origNames;
        private final String _algoName;
        private final String _fullAlgoName;

        private MojoModelDescriptor(MojoModel mojoModel, String fullAlgorithmName, ModelAttributes modelAttributes) {
            ColumnSpecifier weightsColSpec;
            this._category = mojoModel._category;
            this._uuid = mojoModel._uuid;
            this._supervised = mojoModel.isSupervised();
            this._nfeatures = mojoModel.nfeatures();
            this._nclasses = mojoModel._nclasses;
            this._balanceClasses = mojoModel._balanceClasses;
            this._defaultThreshold = mojoModel._defaultThreshold;
            this._priorClassDistrib = mojoModel._priorClassDistrib;
            this._modelClassDistrib = mojoModel._modelClassDistrib;
            this._h2oVersion = mojoModel._h2oVersion;
            this._offsetColumn = mojoModel._offsetColumn;
            this._foldColumn = mojoModel._foldColumn;
            this._domains = mojoModel._domains;
            this._origDomains = mojoModel.getOrigDomainValues();
            this._names = mojoModel._names;
            this._origNames = mojoModel.getOrigNames();
            this._algoName = mojoModel._algoName;
            this._fullAlgoName = fullAlgorithmName;
            this._weightsColumn = modelAttributes != null ? ((weightsColSpec = (ColumnSpecifier)modelAttributes.getParameterValueByName("weights_column")) != null ? weightsColSpec.getColumnName() : null) : null;
            this._treatmentColumn = modelAttributes != null ? (String)modelAttributes.getParameterValueByName("treatment_column") : null;
        }

        @Override
        public String[][] scoringDomains() {
            return this._domains;
        }

        @Override
        public String projectVersion() {
            return this._h2oVersion;
        }

        @Override
        public String algoName() {
            return this._algoName;
        }

        @Override
        public String algoFullName() {
            return this._fullAlgoName;
        }

        @Override
        public String offsetColumn() {
            return this._offsetColumn;
        }

        @Override
        public String weightsColumn() {
            return this._weightsColumn;
        }

        @Override
        public String foldColumn() {
            return this._foldColumn;
        }

        @Override
        public String treatmentColumn() {
            return this._treatmentColumn;
        }

        @Override
        public ModelCategory getModelCategory() {
            return this._category;
        }

        @Override
        public boolean isSupervised() {
            return this._supervised;
        }

        @Override
        public int nfeatures() {
            return this._nfeatures;
        }

        @Override
        public String[] features() {
            return Arrays.copyOf(this.columnNames(), this.nfeatures());
        }

        @Override
        public int nclasses() {
            return this._nclasses;
        }

        @Override
        public String[] columnNames() {
            return this._names;
        }

        @Override
        public boolean balanceClasses() {
            return this._balanceClasses;
        }

        @Override
        public double defaultThreshold() {
            return this._defaultThreshold;
        }

        @Override
        public double[] priorClassDist() {
            return this._priorClassDistrib;
        }

        @Override
        public double[] modelClassDist() {
            return this._modelClassDistrib;
        }

        @Override
        public String uuid() {
            return this._uuid;
        }

        @Override
        public String timestamp() {
            return null;
        }

        @Override
        public String[] getOrigNames() {
            return this._origNames;
        }

        @Override
        public String[][] getOrigDomains() {
            return this._origDomains;
        }
    }
}

